/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler.codegen.kotlin;

import com.apollographql.apollo.compiler.InflectorKt;
import com.apollographql.apollo.compiler.ast.CustomTypes;
import com.apollographql.apollo.compiler.ast.Schema;
import com.apollographql.apollo.compiler.ast.SchemaVisitor;
import com.apollographql.apollo.compiler.ast.builder.SchemaBuilderKt;
import com.apollographql.apollo.compiler.codegen.kotlin.SchemaCodegen;
import com.apollographql.apollo.compiler.ir.CodeGenerationIR;
import com.apollographql.apollo.compiler.ir.ScalarType;
import com.apollographql.apollo.compiler.ir.TypeDeclaration;
import com.squareup.kotlinpoet.ClassNames;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003J&\u0010\u0014\u001a\u00020\u0015*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000b\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/apollographql/apollo/compiler/codegen/kotlin/GraphQLKompiler;", "", "irFile", "Ljava/io/File;", "customTypeMap", "", "", "outputPackageName", "useSemanticNaming", "", "(Ljava/io/File;Ljava/util/Map;Ljava/lang/String;Z)V", "irAdapter", "Lcom/squareup/moshi/JsonAdapter;", "Lcom/apollographql/apollo/compiler/ir/CodeGenerationIR;", "kotlin.jvm.PlatformType", "moshi", "Lcom/squareup/moshi/Moshi;", "write", "", "outputDir", "supportedCustomTypes", "Lcom/apollographql/apollo/compiler/ast/CustomTypes;", "typeDeclarations", "", "Lcom/apollographql/apollo/compiler/ir/TypeDeclaration;", "apollo-compiler"})
public final class GraphQLKompiler {
    private final Moshi moshi;
    private final JsonAdapter<CodeGenerationIR> irAdapter;
    private final File irFile;
    private final Map<String, String> customTypeMap;
    private final String outputPackageName;
    private final boolean useSemanticNaming;

    public final void write(@NotNull File outputDir) {
        SchemaCodegen schemaCodegen;
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        Object object = this.irAdapter.fromJson(FilesKt.readText$default((File)this.irFile, null, (int)1, null));
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"irAdapter.fromJson(irFile.readText())!!");
        CodeGenerationIR ir = (CodeGenerationIR)object;
        String string = this.outputPackageName;
        if (string == null) {
            String string2 = this.irFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"irFile.absolutePath");
            string = InflectorKt.formatPackageName(string2);
        }
        String irPackageName = string;
        CharSequence charSequence = irPackageName;
        boolean bl = false;
        String fragmentsPackage = charSequence.length() > 0 ? irPackageName + ".fragment" : "fragment";
        CharSequence charSequence2 = irPackageName;
        boolean bl2 = false;
        String typesPackageName = charSequence2.length() > 0 ? irPackageName + ".type" : "type";
        CustomTypes customTypeMap = this.supportedCustomTypes(this.customTypeMap, ir.getTypesUsed());
        Schema schema = SchemaBuilderKt.ast(ir, customTypeMap, typesPackageName, fragmentsPackage, this.useSemanticNaming);
        CharSequence charSequence3 = irPackageName;
        boolean bl3 = false;
        if (charSequence3.length() > 0) {
            FilesKt.deleteRecursively((File)new File(outputDir, StringsKt.replace$default((String)irPackageName, (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null)));
        }
        SchemaCodegen schemaCodegen2 = schemaCodegen = new SchemaCodegen(typesPackageName, fragmentsPackage, this.outputPackageName);
        boolean bl4 = false;
        boolean bl5 = false;
        SchemaVisitor p1 = schemaCodegen2;
        boolean bl6 = false;
        schema.accept(p1);
        schemaCodegen2.writeTo(outputDir);
    }

    /*
     * WARNING - void declaration
     */
    private final CustomTypes supportedCustomTypes(@NotNull Map<String, String> $this$supportedCustomTypes, List<TypeDeclaration> typeDeclarations) {
        void $this$associateTo$iv$iv;
        void $this$filterTo$iv$iv;
        String string = ScalarType.ID.INSTANCE.getName();
        String string2 = $this$supportedCustomTypes.get(ScalarType.ID.INSTANCE.getName());
        if (string2 == null) {
            string2 = ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(String.class)).toString();
        }
        Pair idScalarTypeMap = TuplesKt.to((Object)string, (Object)string2);
        Iterable $this$filter$iv = typeDeclarations;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TypeDeclaration it = (TypeDeclaration)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getKind(), (Object)TypeDeclaration.Companion.getKIND_SCALAR_TYPE())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object object = (List)destination$iv$iv;
        Iterable $this$associate$iv = (Iterable)object;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            TypeDeclaration it = (TypeDeclaration)element$iv$iv;
            boolean bl = false;
            String string3 = it.getName();
            String string4 = $this$supportedCustomTypes.get(it.getName());
            if (string4 == null) {
                string4 = ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(Object.class)).getCanonicalName();
            }
            Pair pair = TuplesKt.to((Object)string3, (Object)string4);
            boolean bl2 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        object = destination$iv$iv2;
        Map map = MapsKt.plus((Map)object, (Pair)idScalarTypeMap);
        return new CustomTypes(map);
    }

    public GraphQLKompiler(@NotNull File irFile, @NotNull Map<String, String> customTypeMap, @Nullable String outputPackageName, boolean useSemanticNaming) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        Intrinsics.checkParameterIsNotNull(customTypeMap, (String)"customTypeMap");
        this.irFile = irFile;
        this.customTypeMap = customTypeMap;
        this.outputPackageName = outputPackageName;
        this.useSemanticNaming = useSemanticNaming;
        this.moshi = new Moshi.Builder().build();
        this.irAdapter = this.moshi.adapter(CodeGenerationIR.class);
    }
}

