/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.internal;

import com.apollographql.apollo.api.CustomTypeAdapter;
import com.apollographql.apollo.api.CustomTypeValue;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.internal.ResponseFieldMarshaller;
import com.apollographql.apollo.api.internal.ResponseWriter;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.api.internal.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleResponseWriter
implements ResponseWriter {
    private final Map<String, Object> data = new LinkedHashMap<String, Object>();
    private final ScalarTypeAdapters scalarTypeAdapters;

    public SimpleResponseWriter(@NotNull ScalarTypeAdapters scalarTypeAdapters) {
        this.scalarTypeAdapters = Utils.checkNotNull(scalarTypeAdapters, "scalarTypeAdapters == null");
    }

    public String toJson(String indent) throws IOException {
        Buffer buffer = new Buffer();
        JsonWriter jsonWriter = JsonWriter.of((BufferedSink)buffer);
        jsonWriter.setIndent(indent);
        jsonWriter.beginObject();
        jsonWriter.name("data");
        com.apollographql.apollo.api.internal.json.Utils.writeToJson(this.data, jsonWriter);
        jsonWriter.endObject();
        jsonWriter.close();
        return buffer.readUtf8();
    }

    @Override
    public void writeString(@NotNull ResponseField field, @Nullable String value) {
        this.data.put(field.responseName(), value);
    }

    @Override
    public void writeInt(@NotNull ResponseField field, @Nullable Integer value) {
        this.data.put(field.responseName(), value);
    }

    @Override
    public void writeLong(@NotNull ResponseField field, @Nullable Long value) {
        this.data.put(field.responseName(), value);
    }

    @Override
    public void writeDouble(@NotNull ResponseField field, @Nullable Double value) {
        this.data.put(field.responseName(), value);
    }

    @Override
    public void writeBoolean(@NotNull ResponseField field, @Nullable Boolean value) {
        this.data.put(field.responseName(), value);
    }

    @Override
    public void writeCustom(@NotNull ResponseField.CustomTypeField field, @Nullable Object value) {
        if (value == null) {
            this.data.put(field.responseName(), null);
        } else {
            CustomTypeAdapter<Object> typeAdapter = this.scalarTypeAdapters.adapterFor(field.scalarType());
            CustomTypeValue customTypeValue = typeAdapter.encode(value);
            this.data.put(field.responseName(), customTypeValue.value);
        }
    }

    @Override
    public void writeObject(@NotNull ResponseField field, @Nullable ResponseFieldMarshaller marshaller) {
        if (marshaller == null) {
            this.data.put(field.responseName(), null);
        } else {
            SimpleResponseWriter objectResponseWriter = new SimpleResponseWriter(this.scalarTypeAdapters);
            marshaller.marshal(objectResponseWriter);
            this.data.put(field.responseName(), objectResponseWriter.data);
        }
    }

    @Override
    public void writeFragment(@Nullable ResponseFieldMarshaller marshaller) {
        if (marshaller != null) {
            marshaller.marshal(this);
        }
    }

    @Override
    public <T> void writeList(@NotNull ResponseField field, @Nullable List<T> values, @NotNull ResponseWriter.ListWriter<T> listWriter) {
        if (values == null) {
            this.data.put(field.responseName(), null);
        } else {
            CustomListItemWriter listItemWriter = new CustomListItemWriter(this.scalarTypeAdapters);
            listWriter.write(values, listItemWriter);
            this.data.put(field.responseName(), listItemWriter.data);
        }
    }

    private static class CustomListItemWriter
    implements ResponseWriter.ListItemWriter {
        private final List<Object> data = new ArrayList<Object>();
        private final ScalarTypeAdapters scalarTypeAdapters;

        CustomListItemWriter(ScalarTypeAdapters scalarTypeAdapters) {
            this.scalarTypeAdapters = scalarTypeAdapters;
        }

        @Override
        public void writeString(@Nullable String value) {
            this.data.add(value);
        }

        @Override
        public void writeInt(@Nullable Integer value) {
            this.data.add(value);
        }

        @Override
        public void writeLong(@Nullable Long value) {
            this.data.add(value);
        }

        @Override
        public void writeDouble(@Nullable Double value) {
            this.data.add(value);
        }

        @Override
        public void writeBoolean(@Nullable Boolean value) {
            this.data.add(value);
        }

        @Override
        public void writeCustom(@NotNull ScalarType scalarType, @Nullable Object value) {
            if (value == null) {
                this.data.add(null);
            } else {
                CustomTypeAdapter<Object> typeAdapter = this.scalarTypeAdapters.adapterFor(scalarType);
                CustomTypeValue customTypeValue = typeAdapter.encode(value);
                this.data.add(customTypeValue.value);
            }
        }

        @Override
        public void writeObject(@Nullable ResponseFieldMarshaller marshaller) {
            if (marshaller == null) {
                this.data.add(null);
            } else {
                SimpleResponseWriter objectResponseWriter = new SimpleResponseWriter(this.scalarTypeAdapters);
                marshaller.marshal(objectResponseWriter);
                this.data.add(objectResponseWriter.data);
            }
        }

        @Override
        public <T> void writeList(@Nullable List<T> items, @NotNull ResponseWriter.ListWriter<T> listWriter) {
            if (items == null) {
                this.data.add(null);
            } else {
                CustomListItemWriter listItemWriter = new CustomListItemWriter(this.scalarTypeAdapters);
                listWriter.write(items, listItemWriter);
                this.data.add(listItemWriter.data);
            }
        }
    }
}

