/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.internal.json;

import com.apollographql.apollo.api.InputFieldMarshaller;
import com.apollographql.apollo.api.InputFieldWriter;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.api.internal.json.JsonWriter;
import com.apollographql.apollo.response.CustomTypeAdapter;
import com.apollographql.apollo.response.CustomTypeValue;
import com.apollographql.apollo.response.ScalarTypeAdapters;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputFieldJsonWriter
implements InputFieldWriter {
    private final JsonWriter jsonWriter;
    private final ScalarTypeAdapters scalarTypeAdapters;

    public InputFieldJsonWriter(JsonWriter jsonWriter, ScalarTypeAdapters scalarTypeAdapters) {
        this.jsonWriter = jsonWriter;
        this.scalarTypeAdapters = scalarTypeAdapters;
    }

    @Override
    public void writeString(@NotNull String fieldName, @Nullable String value) throws IOException {
        Utils.checkNotNull(fieldName, "fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    @Override
    public void writeInt(@NotNull String fieldName, @Nullable Integer value) throws IOException {
        Utils.checkNotNull(fieldName, "fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    @Override
    public void writeLong(@NotNull String fieldName, @Nullable Long value) throws IOException {
        Utils.checkNotNull(fieldName, "fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    @Override
    public void writeDouble(@NotNull String fieldName, @Nullable Double value) throws IOException {
        Utils.checkNotNull(fieldName, "fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    @Override
    public void writeNumber(@NotNull String fieldName, @Nullable Number value) throws IOException {
        Utils.checkNotNull(fieldName, "fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    @Override
    public void writeBoolean(@NotNull String fieldName, @Nullable Boolean value) throws IOException {
        Utils.checkNotNull(fieldName, "fieldName == null");
        if (value != null) {
            this.jsonWriter.name(fieldName).value(value);
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeCustom(@NotNull String fieldName, @NotNull ScalarType scalarType, @Nullable Object value) throws IOException {
        Utils.checkNotNull(fieldName, "fieldName == null");
        if (value != null) {
            CustomTypeAdapter<Object> customTypeAdapter = this.scalarTypeAdapters.adapterFor(scalarType);
            CustomTypeValue customTypeValue = customTypeAdapter.encode(value);
            if (customTypeValue instanceof CustomTypeValue.GraphQLString) {
                this.writeString(fieldName, (String)((CustomTypeValue.GraphQLString)customTypeValue).value);
                return;
            } else if (customTypeValue instanceof CustomTypeValue.GraphQLBoolean) {
                this.writeBoolean(fieldName, (Boolean)((CustomTypeValue.GraphQLBoolean)customTypeValue).value);
                return;
            } else if (customTypeValue instanceof CustomTypeValue.GraphQLNumber) {
                this.writeNumber(fieldName, (Number)((CustomTypeValue.GraphQLNumber)customTypeValue).value);
                return;
            } else if (customTypeValue instanceof CustomTypeValue.GraphQLJsonObject) {
                this.jsonWriter.name(fieldName);
                com.apollographql.apollo.api.internal.json.Utils.writeToJson(((CustomTypeValue.GraphQLJsonObject)customTypeValue).value, this.jsonWriter);
                return;
            } else {
                if (!(customTypeValue instanceof CustomTypeValue.GraphQLJsonList)) throw new IllegalArgumentException("Unsupported custom value type: " + customTypeValue);
                this.jsonWriter.name(fieldName);
                com.apollographql.apollo.api.internal.json.Utils.writeToJson(((CustomTypeValue.GraphQLJsonList)customTypeValue).value, this.jsonWriter);
            }
            return;
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    @Override
    public void writeObject(@NotNull String fieldName, @Nullable InputFieldMarshaller marshaller) throws IOException {
        Utils.checkNotNull(fieldName, "fieldName == null");
        if (marshaller != null) {
            this.jsonWriter.name(fieldName).beginObject();
            marshaller.marshal(this);
            this.jsonWriter.endObject();
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    @Override
    public void writeList(@NotNull String fieldName, @Nullable InputFieldWriter.ListWriter listWriter) throws IOException {
        Utils.checkNotNull(fieldName, "fieldName == null");
        if (listWriter != null) {
            this.jsonWriter.name(fieldName).beginArray();
            listWriter.write(new JsonListItemWriter(this.jsonWriter, this.scalarTypeAdapters));
            this.jsonWriter.endArray();
        } else {
            this.jsonWriter.name(fieldName).nullValue();
        }
    }

    @Override
    public void writeMap(@NotNull String fieldName, @Nullable Map<String, Object> value) throws IOException {
        Utils.checkNotNull(fieldName, "fieldName == null");
        if (value == null) {
            this.jsonWriter.name(fieldName).nullValue();
        } else {
            this.jsonWriter.name(fieldName);
            com.apollographql.apollo.api.internal.json.Utils.writeToJson(value, this.jsonWriter);
        }
    }

    private static final class JsonListItemWriter
    implements InputFieldWriter.ListItemWriter {
        private final JsonWriter jsonWriter;
        private final ScalarTypeAdapters scalarTypeAdapters;

        JsonListItemWriter(JsonWriter jsonWriter, ScalarTypeAdapters scalarTypeAdapters) {
            this.jsonWriter = jsonWriter;
            this.scalarTypeAdapters = scalarTypeAdapters;
        }

        @Override
        public void writeString(@Nullable String value) throws IOException {
            if (value == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.value(value);
            }
        }

        @Override
        public void writeInt(@Nullable Integer value) throws IOException {
            if (value == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.value(value);
            }
        }

        @Override
        public void writeLong(@Nullable Long value) throws IOException {
            if (value == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.value(value);
            }
        }

        @Override
        public void writeDouble(@Nullable Double value) throws IOException {
            if (value == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.value(value);
            }
        }

        @Override
        public void writeNumber(@Nullable Number value) throws IOException {
            if (value == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.value(value);
            }
        }

        @Override
        public void writeBoolean(@Nullable Boolean value) throws IOException {
            if (value == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.value(value);
            }
        }

        @Override
        public void writeMap(@Nullable Map<String, Object> value) throws IOException {
            com.apollographql.apollo.api.internal.json.Utils.writeToJson(value, this.jsonWriter);
        }

        @Override
        public void writeCustom(@NotNull ScalarType scalarType, @Nullable Object value) throws IOException {
            if (value == null) {
                this.jsonWriter.nullValue();
            } else {
                CustomTypeAdapter<Object> customTypeAdapter = this.scalarTypeAdapters.adapterFor(scalarType);
                CustomTypeValue customTypeValue = customTypeAdapter.encode(value);
                if (customTypeValue instanceof CustomTypeValue.GraphQLString) {
                    this.writeString((String)((CustomTypeValue.GraphQLString)customTypeValue).value);
                } else if (customTypeValue instanceof CustomTypeValue.GraphQLBoolean) {
                    this.writeBoolean((Boolean)((CustomTypeValue.GraphQLBoolean)customTypeValue).value);
                } else if (customTypeValue instanceof CustomTypeValue.GraphQLNumber) {
                    this.writeNumber((Number)((CustomTypeValue.GraphQLNumber)customTypeValue).value);
                } else if (customTypeValue instanceof CustomTypeValue.GraphQLJsonObject) {
                    com.apollographql.apollo.api.internal.json.Utils.writeToJson(((CustomTypeValue.GraphQLJsonObject)customTypeValue).value, this.jsonWriter);
                } else if (customTypeValue instanceof CustomTypeValue.GraphQLJsonList) {
                    com.apollographql.apollo.api.internal.json.Utils.writeToJson(((CustomTypeValue.GraphQLJsonList)customTypeValue).value, this.jsonWriter);
                } else {
                    throw new IllegalArgumentException("Unsupported custom value type: " + customTypeValue);
                }
            }
        }

        @Override
        public void writeObject(@Nullable InputFieldMarshaller marshaller) throws IOException {
            if (marshaller == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.beginObject();
                marshaller.marshal(new InputFieldJsonWriter(this.jsonWriter, this.scalarTypeAdapters));
                this.jsonWriter.endObject();
            }
        }

        @Override
        public void writeList(@Nullable InputFieldWriter.ListWriter listWriter) throws IOException {
            if (listWriter == null) {
                this.jsonWriter.nullValue();
            } else {
                this.jsonWriter.beginArray();
                listWriter.write(new JsonListItemWriter(this.jsonWriter, this.scalarTypeAdapters));
                this.jsonWriter.endArray();
            }
        }
    }
}

