/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResponseField {
    private final Type type;
    private final String responseName;
    private final String fieldName;
    private final Map<String, Object> arguments;
    private final boolean optional;
    private final List<Condition> conditions;
    private static final String VARIABLE_IDENTIFIER_KEY = "kind";
    private static final String VARIABLE_IDENTIFIER_VALUE = "Variable";
    private static final String VARIABLE_NAME_KEY = "variableName";

    public static ResponseField forString(String responseName, String fieldName, Map<String, Object> arguments, boolean optional, List<Condition> conditions) {
        return new ResponseField(Type.STRING, responseName, fieldName, arguments, optional, conditions);
    }

    public static ResponseField forInt(String responseName, String fieldName, Map<String, Object> arguments, boolean optional, List<Condition> conditions) {
        return new ResponseField(Type.INT, responseName, fieldName, arguments, optional, conditions);
    }

    public static ResponseField forLong(String responseName, String fieldName, Map<String, Object> arguments, boolean optional, List<Condition> conditions) {
        return new ResponseField(Type.LONG, responseName, fieldName, arguments, optional, conditions);
    }

    public static ResponseField forDouble(String responseName, String fieldName, Map<String, Object> arguments, boolean optional, List<Condition> conditions) {
        return new ResponseField(Type.DOUBLE, responseName, fieldName, arguments, optional, conditions);
    }

    public static ResponseField forBoolean(String responseName, String fieldName, Map<String, Object> arguments, boolean optional, List<Condition> conditions) {
        return new ResponseField(Type.BOOLEAN, responseName, fieldName, arguments, optional, conditions);
    }

    public static ResponseField forEnum(String responseName, String fieldName, Map<String, Object> arguments, boolean optional, List<Condition> conditions) {
        return new ResponseField(Type.ENUM, responseName, fieldName, arguments, optional, conditions);
    }

    public static ResponseField forObject(String responseName, String fieldName, Map<String, Object> arguments, boolean optional, List<Condition> conditions) {
        return new ResponseField(Type.OBJECT, responseName, fieldName, arguments, optional, conditions);
    }

    public static ResponseField forList(String responseName, String fieldName, Map<String, Object> arguments, boolean optional, List<Condition> conditions) {
        return new ResponseField(Type.LIST, responseName, fieldName, arguments, optional, conditions);
    }

    public static CustomTypeField forCustomType(String responseName, String fieldName, Map<String, Object> arguments, boolean optional, ScalarType scalarType, List<Condition> conditions) {
        return new CustomTypeField(responseName, fieldName, arguments, optional, scalarType, conditions);
    }

    public static ResponseField forFragment(String responseName, String fieldName, List<String> typeConditions) {
        ArrayList<Condition> conditions = new ArrayList<Condition>(typeConditions.size());
        for (String typeCondition : typeConditions) {
            conditions.add(Condition.typeCondition(typeCondition));
        }
        return new ResponseField(Type.FRAGMENT, responseName, fieldName, Collections.emptyMap(), false, conditions);
    }

    public static ResponseField forInlineFragment(String responseName, String fieldName, List<String> typeConditions) {
        ArrayList<Condition> conditions = new ArrayList<Condition>(typeConditions.size());
        for (String typeCondition : typeConditions) {
            conditions.add(Condition.typeCondition(typeCondition));
        }
        return new ResponseField(Type.INLINE_FRAGMENT, responseName, fieldName, Collections.emptyMap(), false, conditions);
    }

    ResponseField(Type type, String responseName, String fieldName, Map<String, Object> arguments, boolean optional, List<Condition> conditions) {
        this.type = type;
        this.responseName = responseName;
        this.fieldName = fieldName;
        this.arguments = arguments == null ? Collections.emptyMap() : Collections.unmodifiableMap(arguments);
        this.optional = optional;
        this.conditions = conditions == null ? Collections.emptyList() : Collections.unmodifiableList(conditions);
    }

    public Type type() {
        return this.type;
    }

    public String responseName() {
        return this.responseName;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Map<String, Object> arguments() {
        return this.arguments;
    }

    public boolean optional() {
        return this.optional;
    }

    public List<Condition> conditions() {
        return this.conditions;
    }

    public String cacheKey(Operation.Variables variables) {
        if (this.arguments.isEmpty()) {
            return this.fieldName();
        }
        return String.format("%s(%s)", this.fieldName(), this.orderIndependentKey(this.arguments, variables));
    }

    @Nullable
    public Object resolveArgument(@NotNull String name, @NotNull Operation.Variables variables) {
        Utils.checkNotNull(name, "name == null");
        Utils.checkNotNull(variables, "variables == null");
        Map<String, Object> variableValues = variables.valueMap();
        Object argumentValue = this.arguments.get(name);
        if (argumentValue instanceof Map) {
            Map argumentValueMap = (Map)argumentValue;
            if (this.isArgumentValueVariableType(argumentValueMap)) {
                String variableName = argumentValueMap.get(VARIABLE_NAME_KEY).toString();
                return variableValues.get(variableName);
            }
            return null;
        }
        return argumentValue;
    }

    private String orderIndependentKey(Map<String, Object> objectMap, Operation.Variables variables) {
        if (this.isArgumentValueVariableType(objectMap)) {
            return this.orderIndependentKeyForVariableArgument(objectMap, variables);
        }
        ArrayList<Map.Entry<String, Object>> sortedArguments = new ArrayList<Map.Entry<String, Object>>(objectMap.entrySet());
        Collections.sort(sortedArguments, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> argumentOne, Map.Entry<String, Object> argumentTwo) {
                return argumentOne.getKey().compareTo(argumentTwo.getKey());
            }
        });
        StringBuilder independentKey = new StringBuilder();
        independentKey.append("{");
        for (int i = 0; i < sortedArguments.size(); ++i) {
            Map.Entry argument = (Map.Entry)sortedArguments.get(i);
            if (argument.getValue() instanceof Map) {
                Map objectArg = (Map)argument.getValue();
                independentKey.append("\"").append((String)argument.getKey()).append("\":").append(this.orderIndependentKey(objectArg, variables));
            } else {
                independentKey.append("\"").append((String)argument.getKey()).append("\":").append(this.asJsonValue(argument.getValue()));
            }
            if (i >= sortedArguments.size() - 1) continue;
            independentKey.append(",");
        }
        independentKey.append("}");
        return independentKey.toString();
    }

    private String asJsonValue(Object o) {
        if (o instanceof Boolean || o instanceof Number) {
            return o.toString();
        }
        return "\"" + o.toString() + "\"";
    }

    private boolean isArgumentValueVariableType(Map<String, Object> objectMap) {
        return objectMap.containsKey(VARIABLE_IDENTIFIER_KEY) && objectMap.get(VARIABLE_IDENTIFIER_KEY).equals(VARIABLE_IDENTIFIER_VALUE) && objectMap.containsKey(VARIABLE_NAME_KEY);
    }

    private String orderIndependentKeyForVariableArgument(Map<String, Object> objectMap, Operation.Variables variables) {
        Object variable = objectMap.get(VARIABLE_NAME_KEY);
        Object resolvedVariable = variables.valueMap().get(variable);
        if (resolvedVariable == null) {
            return null;
        }
        if (resolvedVariable instanceof Map) {
            return this.orderIndependentKey((Map)resolvedVariable, variables);
        }
        return this.asJsonValue(resolvedVariable);
    }

    public static final class BooleanCondition
    extends Condition {
        private final String variableName;
        private final boolean inverted;

        BooleanCondition(@NotNull String variableName, boolean inverted) {
            this.variableName = Utils.checkNotNull(variableName, "variableName == null");
            this.inverted = inverted;
        }

        @NotNull
        public String variableName() {
            return this.variableName;
        }

        public boolean inverted() {
            return this.inverted;
        }
    }

    public static final class TypeNameCondition
    extends Condition {
        private final String typeName;

        TypeNameCondition(String typeName) {
            this.typeName = Utils.checkNotNull(typeName, "typeName == null");
        }

        public String typeName() {
            return this.typeName;
        }
    }

    public static class Condition {
        Condition() {
        }

        @NotNull
        public static TypeNameCondition typeCondition(@NotNull String type) {
            return new TypeNameCondition(type);
        }

        @NotNull
        public static BooleanCondition booleanCondition(@NotNull String variableName, boolean inverted) {
            return new BooleanCondition(variableName, inverted);
        }
    }

    public static final class CustomTypeField
    extends ResponseField {
        private final ScalarType scalarType;

        CustomTypeField(String responseName, String fieldName, Map<String, Object> arguments, boolean optional, ScalarType scalarType, List<Condition> conditions) {
            super(Type.CUSTOM, responseName, fieldName, arguments, optional, conditions);
            this.scalarType = scalarType;
        }

        public ScalarType scalarType() {
            return this.scalarType;
        }
    }

    public static enum Type {
        STRING,
        INT,
        LONG,
        DOUBLE,
        BOOLEAN,
        ENUM,
        OBJECT,
        LIST,
        CUSTOM,
        FRAGMENT,
        INLINE_FRAGMENT;

    }
}

