/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.cache.http;

import com.apollographql.apollo.api.internal.Utils;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public final class HttpCachePolicy {
    public static final ExpirePolicy CACHE_ONLY = new ExpirePolicy(FetchStrategy.CACHE_ONLY);
    public static final Policy NETWORK_ONLY = new Policy(FetchStrategy.NETWORK_ONLY, 0L, null, false);
    public static final ExpirePolicy CACHE_FIRST = new ExpirePolicy(FetchStrategy.CACHE_FIRST);
    public static final ExpirePolicy NETWORK_FIRST = new ExpirePolicy(FetchStrategy.NETWORK_FIRST);

    private HttpCachePolicy() {
    }

    public static enum FetchStrategy {
        CACHE_ONLY,
        NETWORK_ONLY,
        CACHE_FIRST,
        NETWORK_FIRST;

    }

    public static final class ExpirePolicy
    extends Policy {
        ExpirePolicy(FetchStrategy fetchStrategy) {
            super(fetchStrategy, 0L, null, false);
        }

        private ExpirePolicy(FetchStrategy fetchStrategy, long expireTimeout, TimeUnit expireTimeUnit, boolean expireAfterRead) {
            super(fetchStrategy, expireTimeout, expireTimeUnit, expireAfterRead);
        }

        public ExpirePolicy expireAfter(long expireTimeout, @Nonnull TimeUnit expireTimeUnit) {
            return new ExpirePolicy(this.fetchStrategy, expireTimeout, Utils.checkNotNull(expireTimeUnit), this.expireAfterRead);
        }

        public ExpirePolicy expireAfterRead() {
            return new ExpirePolicy(this.fetchStrategy, this.expireTimeout, this.expireTimeUnit, true);
        }
    }

    public static class Policy {
        public final FetchStrategy fetchStrategy;
        public final long expireTimeout;
        public final TimeUnit expireTimeUnit;
        public final boolean expireAfterRead;

        Policy(FetchStrategy fetchStrategy, long expireTimeout, TimeUnit expireTimeUnit, boolean expireAfterRead) {
            this.fetchStrategy = fetchStrategy;
            this.expireTimeout = expireTimeout;
            this.expireTimeUnit = expireTimeUnit;
            this.expireAfterRead = expireAfterRead;
        }

        public long expireTimeoutMs() {
            if (this.expireTimeUnit == null) {
                return 0L;
            }
            return this.expireTimeUnit.toMillis(this.expireTimeout);
        }
    }
}

