/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.internal;

import com.apollographql.apollo.api.internal.Action;
import com.apollographql.apollo.api.internal.Function;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;

final class Absent<T>
extends Optional<T> {
    static final Absent<Object> INSTANCE = new Absent();
    private static final long serialVersionUID = 0L;

    static <T> Optional<T> withType() {
        return INSTANCE;
    }

    private Absent() {
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @Override
    public T get() {
        throw new IllegalStateException("Optional.get() cannot be called on an absent value");
    }

    @Override
    public T or(T defaultValue) {
        return Utils.checkNotNull(defaultValue, "use Optional.orNull() instead of Optional.or(null)");
    }

    @Override
    public Optional<T> or(Optional<? extends T> secondChoice) {
        return Utils.checkNotNull(secondChoice);
    }

    @Override
    @Nullable
    public T orNull() {
        return null;
    }

    @Override
    public <V> Optional<V> transform(Function<? super T, V> function) {
        Utils.checkNotNull(function);
        return Optional.absent();
    }

    @Override
    public <V> Optional<V> map(Function<? super T, V> function) {
        Utils.checkNotNull(function);
        return Optional.absent();
    }

    @Override
    public <V> Optional<V> flatMap(Function<? super T, Optional<V>> function) {
        Utils.checkNotNull(function);
        return Optional.absent();
    }

    @Override
    public Optional<T> apply(Action<T> action) {
        Utils.checkNotNull(action);
        return Optional.absent();
    }

    @Override
    public Set<T> asSet() {
        return Collections.emptySet();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return object == this;
    }

    @Override
    public int hashCode() {
        return 2040732332;
    }

    @Override
    public String toString() {
        return "Optional.absent()";
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

