/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ResponseField {
    private final Type type;
    private final String responseName;
    private final String fieldName;
    private final Map<String, Object> arguments;
    private final boolean optional;
    private static final String VARIABLE_IDENTIFIER_KEY = "kind";
    private static final String VARIABLE_IDENTIFIER_VALUE = "Variable";
    private static final String VARIABLE_NAME_KEY = "variableName";

    public static ResponseField forString(String responseName, String fieldName, Map<String, Object> arguments, boolean optional) {
        return new ResponseField(Type.STRING, responseName, fieldName, arguments, optional);
    }

    public static ResponseField forInt(String responseName, String fieldName, Map<String, Object> arguments, boolean optional) {
        return new ResponseField(Type.INT, responseName, fieldName, arguments, optional);
    }

    public static ResponseField forLong(String responseName, String fieldName, Map<String, Object> arguments, boolean optional) {
        return new ResponseField(Type.LONG, responseName, fieldName, arguments, optional);
    }

    public static ResponseField forDouble(String responseName, String fieldName, Map<String, Object> arguments, boolean optional) {
        return new ResponseField(Type.DOUBLE, responseName, fieldName, arguments, optional);
    }

    public static ResponseField forBoolean(String responseName, String fieldName, Map<String, Object> arguments, boolean optional) {
        return new ResponseField(Type.BOOLEAN, responseName, fieldName, arguments, optional);
    }

    public static ResponseField forEnum(String responseName, String fieldName, Map<String, Object> arguments, boolean optional) {
        return new ResponseField(Type.ENUM, responseName, fieldName, arguments, optional);
    }

    public static ResponseField forObject(String responseName, String fieldName, Map<String, Object> arguments, boolean optional) {
        return new ResponseField(Type.OBJECT, responseName, fieldName, arguments, optional);
    }

    public static ResponseField forScalarList(String responseName, String fieldName, Map<String, Object> arguments, boolean optional) {
        return new ResponseField(Type.SCALAR_LIST, responseName, fieldName, arguments, optional);
    }

    public static ResponseField forCustomList(String responseName, String fieldName, Map<String, Object> arguments, boolean optional) {
        return new ResponseField(Type.CUSTOM_LIST, responseName, fieldName, arguments, optional);
    }

    public static ResponseField forObjectList(String responseName, String fieldName, Map<String, Object> arguments, boolean optional) {
        return new ResponseField(Type.OBJECT_LIST, responseName, fieldName, arguments, optional);
    }

    public static ResponseField forCustomType(String responseName, String fieldName, Map<String, Object> arguments, boolean optional, ScalarType scalarType) {
        return new CustomTypeField(responseName, fieldName, arguments, optional, scalarType);
    }

    public static ResponseField forFragment(String responseName, String fieldName, List<String> conditionalTypes) {
        return new ConditionalTypeField(Type.FRAGMENT, responseName, fieldName, conditionalTypes);
    }

    public static ResponseField forInlineFragment(String responseName, String fieldName, List<String> conditionalTypes) {
        return new ConditionalTypeField(Type.INLINE_FRAGMENT, responseName, fieldName, conditionalTypes);
    }

    private ResponseField(Type type, String responseName, String fieldName, Map<String, Object> arguments, boolean optional) {
        this.type = type;
        this.responseName = responseName;
        this.fieldName = fieldName;
        this.arguments = arguments == null ? Collections.emptyMap() : Collections.unmodifiableMap(arguments);
        this.optional = optional;
    }

    public Type type() {
        return this.type;
    }

    public String responseName() {
        return this.responseName;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Map<String, Object> arguments() {
        return this.arguments;
    }

    public boolean optional() {
        return this.optional;
    }

    public String cacheKey(Operation.Variables variables) {
        if (this.arguments.isEmpty()) {
            return this.fieldName();
        }
        return String.format("%s(%s)", this.fieldName(), this.orderIndependentKey(this.arguments, variables));
    }

    @Nullable
    public Object resolveArgument(@Nonnull String name, @Nonnull Operation.Variables variables) {
        Utils.checkNotNull(name, "name == null");
        Utils.checkNotNull(variables, "variables == null");
        Map<String, Object> variableValues = variables.valueMap();
        Object argumentValue = this.arguments.get(name);
        if (argumentValue instanceof Map) {
            Map argumentValueMap = (Map)argumentValue;
            if (this.isArgumentValueVariableType(argumentValueMap)) {
                String variableName = argumentValueMap.get(VARIABLE_NAME_KEY).toString();
                return variableValues.get(variableName);
            }
            return null;
        }
        return argumentValue;
    }

    private String orderIndependentKey(Map<String, Object> objectMap, Operation.Variables variables) {
        if (this.isArgumentValueVariableType(objectMap)) {
            return this.orderIndependentKeyForVariableArgument(objectMap, variables);
        }
        ArrayList<Map.Entry<String, Object>> sortedArguments = new ArrayList<Map.Entry<String, Object>>(objectMap.entrySet());
        Collections.sort(sortedArguments, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> argumentOne, Map.Entry<String, Object> argumentTwo) {
                return argumentOne.getKey().compareTo(argumentTwo.getKey());
            }
        });
        StringBuilder independentKey = new StringBuilder();
        for (int i = 0; i < sortedArguments.size(); ++i) {
            Map.Entry argument = (Map.Entry)sortedArguments.get(i);
            if (argument.getValue() instanceof Map) {
                Map objectArg = (Map)argument.getValue();
                boolean isArgumentVariable = this.isArgumentValueVariableType(objectArg);
                independentKey.append((String)argument.getKey()).append(":").append(isArgumentVariable ? "" : "[").append(this.orderIndependentKey(objectArg, variables)).append(isArgumentVariable ? "" : "]");
            } else {
                independentKey.append((String)argument.getKey()).append(":").append(argument.getValue().toString());
            }
            if (i >= sortedArguments.size() - 1) continue;
            independentKey.append(",");
        }
        return independentKey.toString();
    }

    private boolean isArgumentValueVariableType(Map<String, Object> objectMap) {
        return objectMap.containsKey(VARIABLE_IDENTIFIER_KEY) && objectMap.get(VARIABLE_IDENTIFIER_KEY).equals(VARIABLE_IDENTIFIER_VALUE) && objectMap.containsKey(VARIABLE_NAME_KEY);
    }

    private String orderIndependentKeyForVariableArgument(Map<String, Object> objectMap, Operation.Variables variables) {
        Object variable = objectMap.get(VARIABLE_NAME_KEY);
        Object resolvedVariable = variables.valueMap().get(variable);
        if (resolvedVariable == null) {
            return null;
        }
        if (resolvedVariable instanceof Map) {
            return this.orderIndependentKey((Map)resolvedVariable, variables);
        }
        return resolvedVariable.toString();
    }

    public static final class ConditionalTypeField
    extends ResponseField {
        private final List<String> conditionalTypes;

        ConditionalTypeField(Type type, String responseName, String fieldName, List<String> conditionalTypes) {
            super(type, responseName, fieldName, Collections.emptyMap(), false);
            this.conditionalTypes = conditionalTypes != null ? Collections.unmodifiableList(conditionalTypes) : Collections.emptyList();
        }

        public List<String> conditionalTypes() {
            return this.conditionalTypes;
        }
    }

    public static final class CustomTypeField
    extends ResponseField {
        private final ScalarType scalarType;

        CustomTypeField(String responseName, String fieldName, Map<String, Object> arguments, boolean optional, ScalarType scalarType) {
            super(Type.CUSTOM, responseName, fieldName, arguments, optional);
            this.scalarType = scalarType;
        }

        public ScalarType scalarType() {
            return this.scalarType;
        }
    }

    public static enum Type {
        STRING,
        INT,
        LONG,
        DOUBLE,
        BOOLEAN,
        ENUM,
        OBJECT,
        SCALAR_LIST,
        CUSTOM_LIST,
        OBJECT_LIST,
        CUSTOM,
        FRAGMENT,
        INLINE_FRAGMENT;

    }
}

