/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class Error {
    private final String message;
    @Nullable
    private final List<Location> locations;

    public Error(String message, @Nullable List<Location> locations) {
        this.message = message;
        this.locations = locations;
    }

    public String message() {
        return this.message;
    }

    @Nullable
    public List<Location> locations() {
        return this.locations != null ? new ArrayList<Location>(this.locations) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error that = (Error)o;
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        return this.locations != null ? this.locations.equals(that.locations) : that.locations == null;
    }

    public int hashCode() {
        int result = this.message != null ? this.message.hashCode() : 0;
        result = 31 * result + (this.locations != null ? this.locations.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Error{message='" + this.message + '\'' + ", locations=" + this.locations + '}';
    }

    public static class Location {
        private final long line;
        private final long column;

        public Location(long line, long column) {
            this.line = line;
            this.column = column;
        }

        public long line() {
            return this.line;
        }

        public long column() {
            return this.column;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            if (this.line != location.line) {
                return false;
            }
            return this.column == location.column;
        }

        public int hashCode() {
            int result = (int)(this.line ^ this.line >>> 32);
            result = 31 * result + (int)(this.column ^ this.column >>> 32);
            return result;
        }

        public String toString() {
            return "Location{line=" + this.line + ", column=" + this.column + '}';
        }
    }
}

