/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.internal;

import com.apollographql.apollo.api.ApolloResponse;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.DeferredFragmentIdentifier;
import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.Executables;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.internal.ResponseParserKt;
import com.apollographql.apollo.api.json.-JsonReaders;
import com.apollographql.apollo.api.json.JsonReader;
import com.apollographql.apollo.api.json.MapJsonReader;
import com.apollographql.apollo.exception.JsonDataException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JT\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000b2\u000e\u0010\f\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012J\u001c\u0010\u0014\u001a\u00020\u00152\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0017\u00a8\u0006\u0019"}, d2={"Lcom/apollographql/apollo/api/internal/ResponseParser;", "", "<init>", "()V", "parse", "Lcom/apollographql/apollo/api/ApolloResponse;", "D", "Lcom/apollographql/apollo/api/Operation$Data;", "jsonReader", "Lcom/apollographql/apollo/api/json/JsonReader;", "operation", "Lcom/apollographql/apollo/api/Operation;", "requestUuid", "Ljava/util/UUID;", "Lcom/benasher44/uuid/Uuid;", "customScalarAdapters", "Lcom/apollographql/apollo/api/CustomScalarAdapters;", "deferredFragmentIds", "", "Lcom/apollographql/apollo/api/DeferredFragmentIdentifier;", "parseError", "Lcom/apollographql/apollo/api/Error;", "payload", "", "", "apollo-api"})
@SourceDebugExtension(value={"SMAP\nResponseParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseParser.kt\ncom/apollographql/apollo/api/internal/ResponseParser\n+ 2 uuid.kt\ncom/benasher44/uuid/UuidKt\n*L\n1#1,170:1\n100#2:171\n*S KotlinDebug\n*F\n+ 1 ResponseParser.kt\ncom/apollographql/apollo/api/internal/ResponseParser\n*L\n55#1:171\n*E\n"})
public final class ResponseParser {
    @NotNull
    public static final ResponseParser INSTANCE = new ResponseParser();

    private ResponseParser() {
    }

    @NotNull
    public final <D extends Operation.Data> ApolloResponse<D> parse(@NotNull JsonReader jsonReader, @NotNull Operation<D> operation, @Nullable UUID requestUuid, @NotNull CustomScalarAdapters customScalarAdapters, @Nullable Set<DeferredFragmentIdentifier> deferredFragmentIds) {
        Intrinsics.checkNotNullParameter((Object)jsonReader, (String)"jsonReader");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
        jsonReader.beginObject();
        Operation.Data data = null;
        List<Error> errors = null;
        Map extensions = null;
        block10: while (jsonReader.hasNext()) {
            switch (jsonReader.nextName()) {
                case "data": {
                    Set<String> falseVariables = Executables.falseVariables(operation, customScalarAdapters);
                    data = (Operation.Data)Executables.parseData(operation, jsonReader, customScalarAdapters, falseVariables, deferredFragmentIds, errors);
                    continue block10;
                }
                case "errors": {
                    errors = ResponseParserKt.readErrors(jsonReader);
                    continue block10;
                }
                case "extensions": {
                    Object object = -JsonReaders.readAny(jsonReader);
                    extensions = object instanceof Map ? (Map)object : null;
                    continue block10;
                }
            }
            if (!jsonReader.ignoreUnknownKeys()) {
                String name;
                throw new JsonDataException("Unknown key '" + name + "' found at path: '" + CollectionsKt.joinToString$default((Iterable)jsonReader.getPath(), (CharSequence)".", null, null, (int)0, null, null, (int)62, null) + '\'');
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        UUID uUID = requestUuid;
        if (uUID == null) {
            boolean $i$f$uuid4 = false;
            UUID uUID2 = UUID.randomUUID();
            uUID = uUID2;
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"randomUUID(...)");
        }
        return new ApolloResponse.Builder<D>(operation, uUID).errors(errors).data(data).extensions(extensions).build();
    }

    @NotNull
    public final Error parseError(@NotNull Map<String, ? extends Object> payload) {
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        return ResponseParserKt.access$readError(new MapJsonReader(payload, null, 2, null));
    }
}

