/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.http;

import com.apollographql.apollo.api.ExecutionContext;
import com.apollographql.apollo.api.http.HttpHeader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB;\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lcom/apollographql/apollo/api/http/HttpResponse;", "", "statusCode", "", "headers", "", "Lcom/apollographql/apollo/api/http/HttpHeader;", "bodySource", "Lokio/BufferedSource;", "bodyString", "Lokio/ByteString;", "executionContext", "Lcom/apollographql/apollo/api/ExecutionContext;", "<init>", "(ILjava/util/List;Lokio/BufferedSource;Lokio/ByteString;Lcom/apollographql/apollo/api/ExecutionContext;)V", "getStatusCode", "()I", "getHeaders", "()Ljava/util/List;", "getExecutionContext", "()Lcom/apollographql/apollo/api/ExecutionContext;", "body", "getBody", "()Lokio/BufferedSource;", "newBuilder", "Lcom/apollographql/apollo/api/http/HttpResponse$Builder;", "Builder", "apollo-api"})
@SourceDebugExtension(value={"SMAP\nHttp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http.kt\ncom/apollographql/apollo/api/http/HttpResponse\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1#2:211\n*E\n"})
public final class HttpResponse {
    private final int statusCode;
    @NotNull
    private final List<HttpHeader> headers;
    @Nullable
    private final BufferedSource bodySource;
    @Nullable
    private final ByteString bodyString;
    @NotNull
    private final ExecutionContext executionContext;

    private HttpResponse(int statusCode, List<HttpHeader> headers, BufferedSource bodySource, ByteString bodyString, ExecutionContext executionContext) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.bodySource = bodySource;
        this.bodyString = bodyString;
        this.executionContext = executionContext;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    @NotNull
    public final List<HttpHeader> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @Nullable
    public final BufferedSource getBody() {
        BufferedSource bufferedSource = this.bodySource;
        if (bufferedSource == null) {
            Buffer buffer;
            ByteString byteString = this.bodyString;
            if (byteString != null) {
                ByteString it = byteString;
                boolean bl = false;
                buffer = new Buffer().write(it);
            } else {
                buffer = null;
            }
            bufferedSource = (BufferedSource)buffer;
        }
        return bufferedSource;
    }

    @NotNull
    public final Builder newBuilder() {
        Builder builder;
        Builder $this$newBuilder_u24lambda_u240 = builder = new Builder(this.statusCode);
        boolean bl = false;
        if (this.bodySource != null) {
            $this$newBuilder_u24lambda_u240.body(this.bodySource);
        }
        if (this.bodyString != null) {
            $this$newBuilder_u24lambda_u240.body((BufferedSource)new Buffer().write(this.bodyString));
        }
        $this$newBuilder_u24lambda_u240.addHeaders(this.headers);
        return builder;
    }

    public /* synthetic */ HttpResponse(int statusCode, List headers, BufferedSource bodySource, ByteString bodyString, ExecutionContext executionContext, DefaultConstructorMarker $constructor_marker) {
        this(statusCode, headers, bodySource, bodyString, executionContext);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0015\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J\u0014\u0010\u001a\u001a\u00020\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001bJ\u0014\u0010\f\u001a\u00020\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u001d\u001a\u00020\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/apollographql/apollo/api/http/HttpResponse$Builder;", "", "statusCode", "", "<init>", "(I)V", "getStatusCode", "()I", "bodySource", "Lokio/BufferedSource;", "bodyString", "Lokio/ByteString;", "headers", "", "Lcom/apollographql/apollo/api/http/HttpHeader;", "hasBody", "", "getHasBody", "()Z", "executionContext", "Lcom/apollographql/apollo/api/ExecutionContext;", "body", "addHeader", "name", "", "value", "addHeaders", "", "addExecutionContext", "build", "Lcom/apollographql/apollo/api/http/HttpResponse;", "apollo-api"})
    @SourceDebugExtension(value={"SMAP\nHttp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http.kt\ncom/apollographql/apollo/api/http/HttpResponse$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1#2:211\n*E\n"})
    public static final class Builder {
        private final int statusCode;
        @Nullable
        private BufferedSource bodySource;
        @Nullable
        private ByteString bodyString;
        @NotNull
        private final List<HttpHeader> headers;
        @NotNull
        private ExecutionContext executionContext;

        public Builder(int statusCode) {
            this.statusCode = statusCode;
            this.headers = new ArrayList();
            this.executionContext = ExecutionContext.Empty;
        }

        public final int getStatusCode() {
            return this.statusCode;
        }

        private final boolean getHasBody() {
            return this.bodySource != null || this.bodyString != null;
        }

        @NotNull
        public final Builder body(@NotNull BufferedSource bodySource) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)bodySource, (String)"bodySource");
            Builder $this$body_u24lambda_u240 = builder = this;
            boolean bl = false;
            if (!(!$this$body_u24lambda_u240.getHasBody())) {
                boolean bl2 = false;
                String string = "body() can only be called once";
                throw new IllegalStateException(string.toString());
            }
            $this$body_u24lambda_u240.bodySource = bodySource;
            return builder;
        }

        @Deprecated(message="Use body(BufferedSource) instead", replaceWith=@ReplaceWith(expression="body(Buffer().write(bodyString))", imports={"okio.Buffer"}), level=DeprecationLevel.ERROR)
        @NotNull
        public final Builder body(@NotNull ByteString bodyString) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)bodyString, (String)"bodyString");
            Builder $this$body_u24lambda_u241 = builder = this;
            boolean bl = false;
            if (!(!$this$body_u24lambda_u241.getHasBody())) {
                boolean bl2 = false;
                String string = "body() can only be called once";
                throw new IllegalStateException(string.toString());
            }
            $this$body_u24lambda_u241.bodyString = bodyString;
            return builder;
        }

        @NotNull
        public final Builder addHeader(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$addHeader_u24lambda_u240 = builder = this;
            boolean bl = false;
            ((Collection)$this$addHeader_u24lambda_u240.headers).add(new HttpHeader(name, value));
            return builder;
        }

        @NotNull
        public final Builder addHeaders(@NotNull List<HttpHeader> headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Builder $this$addHeaders_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$addHeaders_u24lambda_u240.headers.addAll((Collection<HttpHeader>)headers);
            return builder;
        }

        @NotNull
        public final Builder headers(@NotNull List<HttpHeader> headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Builder $this$headers_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$headers_u24lambda_u240.headers.clear();
            $this$headers_u24lambda_u240.headers.addAll((Collection<HttpHeader>)headers);
            return builder;
        }

        @NotNull
        public final Builder addExecutionContext(@NotNull ExecutionContext executionContext) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Builder $this$addExecutionContext_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$addExecutionContext_u24lambda_u240.executionContext = $this$addExecutionContext_u24lambda_u240.executionContext.plus(executionContext);
            return builder;
        }

        @NotNull
        public final HttpResponse build() {
            return new HttpResponse(this.statusCode, this.headers, this.bodySource, this.bodyString, this.executionContext, null);
        }
    }
}

