/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.http;

import com.apollographql.apollo.api.http.HttpBody;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSink;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/apollographql/apollo/api/http/ByteStringHttpBody;", "Lcom/apollographql/apollo/api/http/HttpBody;", "contentType", "", "byteString", "Lokio/ByteString;", "<init>", "(Ljava/lang/String;Lokio/ByteString;)V", "string", "(Ljava/lang/String;Ljava/lang/String;)V", "getContentType", "()Ljava/lang/String;", "contentLength", "", "getContentLength", "()J", "writeTo", "", "bufferedSink", "Lokio/BufferedSink;", "apollo-api"})
public final class ByteStringHttpBody
implements HttpBody {
    @NotNull
    private final String contentType;
    @NotNull
    private final ByteString byteString;

    public ByteStringHttpBody(@NotNull String contentType, @NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
        this.contentType = contentType;
        this.byteString = byteString;
    }

    @Override
    @NotNull
    public String getContentType() {
        return this.contentType;
    }

    public ByteStringHttpBody(@NotNull String contentType, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this(contentType, ByteString.Companion.encodeUtf8(string));
    }

    @Override
    public long getContentLength() {
        return this.byteString.size();
    }

    @Override
    public void writeTo(@NotNull BufferedSink bufferedSink) {
        Intrinsics.checkNotNullParameter((Object)bufferedSink, (String)"bufferedSink");
        bufferedSink.write(this.byteString);
    }
}

