/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.web.uri;

import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.web.uri.UriValidationPolicy;
import java.net.URI;
import java.util.Objects;

public final class UriUtils {
    private UriUtils() {
    }

    public static final boolean isURI(String value) {
        return value != null && !value.isBlank() && !Keywords.matchForm(value.strip()) && UriUtils.create(value.strip()) != null;
    }

    public static final URI create(String uri) {
        Object uriValue = Objects.requireNonNull(uri, "The paramenter 'uri' cannot be null").strip();
        if (((String)uriValue).isEmpty()) {
            return null;
        }
        if (((String)uriValue).endsWith(":")) {
            uriValue = (String)uriValue + ".";
        } else if (((String)uriValue).endsWith("[") || ((String)uriValue).endsWith("]")) {
            uriValue = ((String)uriValue).substring(0, ((String)uriValue).length() - 1);
        }
        try {
            return URI.create((String)uriValue);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static final boolean endsWithGenDelim(String uri) {
        return uri.endsWith(":") || uri.endsWith("/") || uri.endsWith("?") || uri.endsWith("#") || uri.endsWith("[") || uri.endsWith("]") || uri.endsWith("@");
    }

    public static final boolean isNotURI(String uri) {
        return uri == null || uri.isBlank() || Keywords.matchForm(uri.strip()) || UriUtils.create(uri.strip()) == null;
    }

    public static final boolean isNotAbsoluteUri(String uri, UriValidationPolicy policy) {
        return !UriUtils.isAbsoluteUri(uri, policy);
    }

    public static final boolean isAbsoluteUri(String uri, UriValidationPolicy policy) {
        switch (policy) {
            case None: {
                return true;
            }
            case SchemeOnly: {
                return UriUtils.startsWithScheme(uri);
            }
            case Full: {
                if (uri == null || uri.length() < 3) {
                    return false;
                }
                try {
                    return URI.create(uri).isAbsolute();
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
        }
        return false;
    }

    private static final boolean startsWithScheme(String uri) {
        if (uri == null || uri.length() < 2 || !Character.isLetter(uri.codePointAt(0))) {
            return false;
        }
        for (int i = 1; i < uri.length(); ++i) {
            if (Character.isLetterOrDigit(uri.codePointAt(i)) || uri.charAt(i) == '-' || uri.charAt(i) == '+' || uri.charAt(i) == '.') continue;
            return uri.charAt(i) == ':';
        }
        return false;
    }

    protected static final String recompose(String scheme, String authority, String path, String query, String fragment) {
        StringBuilder builder = new StringBuilder();
        if (scheme != null) {
            builder.append(scheme);
            builder.append(":");
        }
        if (authority != null) {
            builder.append("//");
            builder.append(authority);
        }
        if (path != null) {
            builder.append(path);
        }
        if (query != null) {
            builder.append('?');
            builder.append(query);
        }
        if (fragment != null) {
            builder.append('#');
            builder.append(fragment);
        }
        return builder.toString();
    }
}

