/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.web.uri;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public record Path(List<String> segments, String leaf, boolean relative) {
    public static final Path EMPTY = new Path(null, null, true);
    private static final Pattern SEGMENTS_DEL_RE = Pattern.compile("/");

    public Path {
        segments = segments != null ? List.copyOf(segments) : List.of();
    }

    public static final Path of(String path) {
        boolean relative = !path.startsWith("/");
        ArrayList<String> segments = new ArrayList<String>(List.of(SEGMENTS_DEL_RE.split(relative ? path : path.substring(1))));
        String leaf = path.length() > 1 && path.endsWith("/") ? null : segments.remove(segments.size() - 1);
        return new Path(segments, leaf == null || leaf.isBlank() ? null : leaf, relative);
    }

    public Path relativize(String base) {
        return this.relativize(Path.of(base));
    }

    public Path relativize(Path base) {
        int i;
        int rightIndex;
        int leftIndex;
        if (this.segments.isEmpty() && base.segments.isEmpty()) {
            if (Objects.equals(this.leaf, base.leaf)) {
                return new Path(Path.EMPTY.segments, null, !base.relative);
            }
            return new Path(Path.EMPTY.segments, this.leaf, !this.relative && !base.relative);
        }
        if (base.segments.isEmpty() && base.leaf == null) {
            return new Path(this.segments, this.leaf, !base.relative && !this.relative);
        }
        for (leftIndex = 0; leftIndex < Math.min(this.segments.size(), base.segments.size()) && this.segments.get(leftIndex).equals(base.segments.get(leftIndex)); ++leftIndex) {
        }
        if (leftIndex == this.segments.size() && leftIndex == base.segments.size()) {
            if (Objects.equals(this.leaf, base.leaf)) {
                return EMPTY;
            }
            return new Path(Path.EMPTY.segments, this.leaf, !this.segments.isEmpty());
        }
        if (leftIndex >= base.segments.size()) {
            if (this.segments.size() - leftIndex == 1 && this.segments.get(leftIndex).equals(base.leaf)) {
                return new Path(Arrays.asList("."), this.leaf, true);
            }
            return new Path(this.segments.subList(leftIndex, this.segments.size()), this.leaf, true);
        }
        ArrayList<String> diff = new ArrayList<String>();
        for (rightIndex = 0; rightIndex < Math.min(this.segments.size(), base.segments.size()) - leftIndex && this.segments.get(this.segments.size() - rightIndex - 1).equals(base.segments.get(base.segments.size() - rightIndex - 1)); ++rightIndex) {
            diff.add("..");
        }
        for (i = 0; i < base.segments.size() - leftIndex - rightIndex; ++i) {
            diff.add("..");
        }
        for (i = 0; i < this.segments.size() - leftIndex - rightIndex; ++i) {
            diff.add(this.segments.get(i + leftIndex));
        }
        return new Path(diff, Objects.equals(this.leaf, base.leaf) ? null : this.leaf, true);
    }

    public boolean isEmpty() {
        return this.segments.isEmpty() && this.leaf == null && !this.relative;
    }

    public boolean isNotEmpty() {
        return !this.segments.isEmpty() || this.leaf != null || !this.relative;
    }

    public boolean isAbsolute() {
        return !this.relative;
    }

    @Override
    public String toString() {
        return (this.relative ? "" : "/").concat(String.join((CharSequence)"/", this.segments)).concat(this.segments.isEmpty() ? "" : "/").concat(this.leaf != null ? this.leaf : "");
    }
}

