/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.loader;

import com.apicatalog.jsonld.Document;
import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.FileLoader;
import com.apicatalog.tree.io.TreeIO;
import com.apicatalog.tree.io.TreeIOException;
import com.apicatalog.tree.io.TreeParser;
import com.apicatalog.web.media.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public final class ClasspathLoader
implements DocumentLoader {
    private final Map<MediaType, TreeParser> parsers;
    private final TreeParser defaultParser;
    private final Class<?> baseClass;

    private ClasspathLoader(Map<MediaType, TreeParser> parsers, TreeParser defaultParser, Class<?> base) {
        this.parsers = parsers;
        this.defaultParser = defaultParser;
        this.baseClass = base;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Document loadDocument(URI url, DocumentLoader.Options options) throws JsonLdException {
        Document document;
        block10: {
            if (!"classpath".equalsIgnoreCase(url.getScheme())) {
                throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, "Unsupported URL scheme [" + url.getScheme() + "]. Only classpath: scheme is accepted, url=" + String.valueOf(url));
            }
            String path = url.getPath() != null ? url.getPath() : url.getSchemeSpecificPart();
            MediaType contentType = FileLoader.fromFileExtension(path);
            TreeParser parser = this.parsers.getOrDefault(contentType, this.defaultParser);
            if (parser == null) {
                throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, "Cannot parse content-type=" + String.valueOf(contentType) + ", uri=" + String.valueOf(url) + ", base=" + this.baseClass.getPackageName());
            }
            InputStream is = this.baseClass.getResourceAsStream(path);
            try {
                TreeIO node = parser.parse(is);
                document = Document.of(node, contentType, url);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TreeIOException | IOException e) {
                    throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, "Document loader failed for uri=" + String.valueOf(url) + ", base=" + this.baseClass.getPackageName(), e);
                }
            }
            is.close();
        }
        return document;
    }

    public static final class Builder {
        private final Map<MediaType, TreeParser> parsers = new HashMap<MediaType, TreeParser>();
        private TreeParser defaultParser = null;
        private Class<?> baseClass = ClasspathLoader.class;

        Builder() {
        }

        public Builder parser(MediaType contentType, TreeParser parser) {
            this.parsers.put(contentType, parser);
            return this;
        }

        public Builder defaultParser(TreeParser parser) {
            this.defaultParser = parser;
            return this;
        }

        public Builder base(Class<?> baseClass) {
            this.baseClass = baseClass;
            return this;
        }

        public ClasspathLoader build() {
            return new ClasspathLoader(Map.copyOf(this.parsers), this.defaultParser, this.baseClass);
        }
    }
}

