/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.framing;

import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.framing.Frame;
import com.apicatalog.jsonld.framing.FrameMatcher;
import com.apicatalog.jsonld.framing.FramingState;
import com.apicatalog.jsonld.lang.Embed;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.lang.LdAdapter;
import com.apicatalog.tree.io.java.NativeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Framing {
    private final FramingState state;
    private final List<String> subjects;
    private final Frame frame;
    private final Map<String, Object> parent;
    private String activeProperty;
    private boolean ordered;

    private Framing(FramingState state, List<String> subjects, Frame frame, Map<String, Object> parent, String activeProperty) {
        this.state = state;
        this.subjects = subjects;
        this.frame = frame;
        this.parent = parent;
        this.activeProperty = activeProperty;
        this.ordered = false;
    }

    public static final Framing with(FramingState state, List<String> subjects, Frame frame, Map<String, Object> parent, String activeProperty) {
        return new Framing(state, subjects, frame, parent, activeProperty);
    }

    public Framing ordered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void frame() throws JsonLdException {
        Iterator<String> ids;
        Embed embed = this.frame.getEmbed(this.state.getEmbed());
        boolean isExplicit = this.frame.isExplicit(this.state.isExplicitInclusion());
        boolean isRequireAll = this.frame.isRequireAll(this.state.isRequireAll());
        List<String> matchedSubjects = FrameMatcher.with(this.state, this.frame, isRequireAll).match(this.subjects);
        Iterator<String> iterator = ids = this.ordered ? matchedSubjects.stream().sorted().iterator() : matchedSubjects.iterator();
        while (ids.hasNext()) {
            Object reverseObject;
            Object subframe;
            Iterator<String> properties;
            String stringNodeId;
            String id = ids.next();
            Map node = this.state.getGraphMap().find(this.state.getGraphName(), id).orElse(Map.of());
            Object v = node.get("@id");
            String nodeId = v instanceof String ? (stringNodeId = (String)v) : null;
            LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
            output.put("@id", id);
            if (this.activeProperty == null) {
                this.state.clearDone();
            }
            if (!this.state.isEmbedded() && this.state.isDone(id)) continue;
            if (this.state.isEmbedded() && (Embed.NEVER == embed || this.state.isParent(nodeId))) {
                Framing.addToResult(this.parent, this.activeProperty, output);
                continue;
            }
            if (this.state.isEmbedded() && Embed.ONCE == embed && this.state.isDone(id)) {
                Framing.addToResult(this.parent, this.activeProperty, output);
                continue;
            }
            this.state.markDone(id);
            this.state.addParent(nodeId);
            if (this.state.getGraphMap().contains(id)) {
                Frame subframe2;
                boolean recurse;
                if (!this.frame.contains("@graph")) {
                    recurse = !"@merged".equals(this.state.getGraphName());
                    Frame subframe22 = Frame.EMPTY;
                } else {
                    recurse = !"@merged".equals(id) && !"@default".equals(id);
                    Object graph = this.frame.get("@graph");
                    subframe2 = graph instanceof Map || graph instanceof Collection ? Frame.of(graph) : Frame.EMPTY;
                }
                if (recurse) {
                    FramingState graphState = new FramingState(this.state);
                    graphState.setGraphName(id);
                    graphState.setEmbedded(false);
                    Framing.with(graphState, new ArrayList<String>(this.state.getGraphMap().find(id).or(() -> this.state.getGraphMap().find(this.state.getGraphName())).map(Map::keySet).orElse(Set.of())), subframe2, output, "@graph").ordered(this.ordered).frame();
                }
            }
            if (this.frame.contains("@included")) {
                FramingState includedState = new FramingState(this.state);
                includedState.setEmbedded(false);
                Framing.with(includedState, this.subjects, Frame.of(this.frame.get("@included")), output, "@included").ordered(this.ordered).frame();
            }
            Collection<String> unsortedProps = this.state.getGraphMap().properties(this.state.getGraphName(), id);
            Iterator<String> iterator2 = properties = this.ordered ? unsortedProps.stream().sorted().iterator() : unsortedProps.iterator();
            while (properties.hasNext()) {
                String property = properties.next();
                Object objects = this.state.getGraphMap().get(this.state.getGraphName(), id, property);
                if (Keywords.contains(property)) {
                    output.put(property, objects);
                    continue;
                }
                if (isExplicit && !this.frame.contains(property)) continue;
                for (Object e : NativeAdapter.asCollection((Object)objects)) {
                    Map itemMap;
                    Map itemMap2;
                    subframe = this.frame.get(property);
                    if (subframe == null) {
                        subframe = Map.of("@embed", "@".concat(embed.name().toLowerCase()), "@explicit", isExplicit, "@requireAll", isRequireAll);
                    }
                    if (e instanceof Map && LdAdapter.isList(itemMap2 = (Map)e)) {
                        Object object;
                        Collection array;
                        Map<String, Boolean> listFrameValue = null;
                        Object propertyValue = this.frame.get(property);
                        if (propertyValue instanceof Collection && !(array = (Collection)propertyValue).isEmpty() && (object = array.iterator().next()) instanceof Map) {
                            Map map = (Map)object;
                            listFrameValue = map.get("@list");
                        }
                        if (listFrameValue == null) {
                            listFrameValue = Map.of("@embed", "@".concat(embed.name().toLowerCase()), "@explicit", isExplicit, "@requireAll", isRequireAll);
                        }
                        Frame listFrame = Frame.of(listFrameValue);
                        ArrayList<Object> list = new ArrayList<Object>();
                        object = NativeAdapter.asCollection(itemMap2.get("@list")).iterator();
                        while (object.hasNext()) {
                            Object listItem = object.next();
                            if (LdAdapter.isReference(listItem)) {
                                FramingState listState = new FramingState(this.state);
                                listState.setEmbedded(true);
                                LinkedHashMap<String, Object> listResult = new LinkedHashMap<String, Object>();
                                String idMap = (String)((Map)listItem).get("@id");
                                Framing.with(listState, Arrays.asList(idMap), listFrame, listResult, "@list").ordered(this.ordered).frame();
                                Object existingList = listResult.get("@list");
                                if (existingList == null) continue;
                                list.add(existingList);
                                continue;
                            }
                            list.add(listItem);
                        }
                        LdAdapter.setOrAdd(output, property, Map.of("@list", list));
                        continue;
                    }
                    if (LdAdapter.isReference(e)) {
                        FramingState clonedState = new FramingState(this.state);
                        clonedState.setEmbedded(true);
                        String idMap = (String)((Map)e).get("@id");
                        Framing.with(clonedState, Arrays.asList(idMap), Frame.of(subframe), output, property).ordered(this.ordered).frame();
                        continue;
                    }
                    if (e instanceof Map && LdAdapter.isValueNode(itemMap = (Map)e)) {
                        if (!Frame.of(subframe).matchValue(e)) continue;
                        LdAdapter.setOrAdd(output, property, e);
                        continue;
                    }
                    LdAdapter.setOrAdd(output, property, e);
                }
            }
            for (String property : this.frame.keys()) {
                void var15_21;
                Collection collection;
                Map propertyFrame;
                if (output.containsKey(property) || !"@type".equals(property) && Keywords.matchForm(property) || "@type".equals(property) && !this.frame.isDefaultObject(property) || Frame.getBoolean(propertyFrame = (subframe = this.frame.get(property)) instanceof Collection && !(collection = (Collection)subframe).isEmpty() ? (Map)collection.iterator().next() : Map.of(), "@omitDefault", this.state.isOmitDefault())) continue;
                Object v2 = propertyFrame.get("@default");
                if (v2 == null) {
                    String string = "@null";
                }
                LdAdapter.setOrAdd(output, property, Map.of("@preserve", var15_21));
            }
            if (this.frame.contains("@reverse") && (reverseObject = this.frame.get("@reverse")) instanceof Map) {
                Map map = (Map)reverseObject;
                for (Map.Entry entry : map.entrySet()) {
                    subframe = Frame.of(map.get(entry.getValue()));
                    Set<String> subjectProperties = this.state.getReversePropertySubjects(this.state.getGraphName(), (String)entry.getKey(), id);
                    if (subjectProperties.isEmpty()) continue;
                    LinkedHashMap<String, Object> reverseResult = new LinkedHashMap<String, Object>();
                    FramingState reverseState = new FramingState(this.state);
                    reverseState.setEmbedded(true);
                    Framing.with(reverseState, new ArrayList<String>(subjectProperties), subframe, reverseResult, null).ordered(this.ordered).frame();
                    LinkedHashMap<String, Object> reverse = (LinkedHashMap<String, Object>)output.get("@reverse");
                    if (reverse == null) {
                        reverse = new LinkedHashMap<String, Object>();
                        output.put("@reverse", reverse);
                    }
                    LdAdapter.setOrAdd(reverse, (String)entry.getKey(), reverseResult.values());
                }
            }
            this.state.removeLastParent();
            Framing.addToResult(this.parent, this.activeProperty, output);
        }
    }

    private static void addToResult(Map<String, Object> result, String property, Object value) {
        if (property == null) {
            result.put(Integer.toHexString(result.size()), value);
            return;
        }
        LdAdapter.setOrAdd(result, property, value);
    }
}

