/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.lang;

import java.util.Arrays;
import java.util.function.IntPredicate;

public final class BlankNode {
    static final IntPredicate ASCII_ALPHA = ch -> 97 <= ch && ch <= 122 || 65 <= ch && ch <= 90;
    static final IntPredicate ASCII_DIGIT = ch -> 48 <= ch && ch <= 57;
    static final IntPredicate PN_CHARS_BASE = ASCII_ALPHA.or(ch -> 192 <= ch && ch <= 214 || 216 <= ch && ch <= 246 || 248 <= ch && ch <= 767 || 880 <= ch && ch <= 893 || 895 <= ch && ch <= 8191 || 8204 <= ch && ch <= 8205 || 8304 <= ch && ch <= 8591 || 11264 <= ch && ch <= 12271 || 12289 <= ch && ch <= 55295 || 63744 <= ch && ch <= 64975 || 65008 <= ch && ch <= 65533 || 65536 <= ch && ch <= 983039);
    static final IntPredicate PN_CHARS_U = PN_CHARS_BASE.or(ch -> 95 == ch || 58 == ch);
    static final IntPredicate PN_CHARS = PN_CHARS_U.or(ASCII_DIGIT).or(ch -> 45 == ch || 183 == ch || 768 <= ch && ch <= 879 || 8255 <= ch && ch <= 8256);

    private BlankNode() {
    }

    public static boolean hasPrefix(String value) {
        return value.startsWith("_:");
    }

    public static boolean isWellFormed(String blankNodeId) {
        if (blankNodeId.length() < 3) {
            return false;
        }
        int[] chars = blankNodeId.codePoints().toArray();
        if (chars[0] != 95 || chars[1] != 58 || PN_CHARS_U.negate().test(chars[2]) && ASCII_DIGIT.negate().test(chars[2]) || chars[chars.length - 1] == 46) {
            return false;
        }
        if (chars.length == 3) {
            return true;
        }
        return Arrays.stream(chars, 3, chars.length - 1).allMatch(PN_CHARS.or(ch -> ch == 46));
    }
}

