/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public final class JsonLdException
extends Exception {
    private static final long serialVersionUID = -7548366490116267200L;
    private final ErrorCode code;

    public JsonLdException(ErrorCode code) {
        super(Objects.requireNonNull(code, "code must not be null").description());
        this.code = code;
    }

    public JsonLdException(ErrorCode code, String message) {
        super(message);
        this.code = Objects.requireNonNull(code, "code must not be null");
    }

    public JsonLdException(ErrorCode code, Throwable cause) {
        super(Objects.requireNonNull(code, "code must not be null").description(), cause);
        this.code = code;
    }

    public JsonLdException(ErrorCode code, String message, Throwable cause) {
        super(message, cause);
        this.code = Objects.requireNonNull(code, "code must not be null");
    }

    public ErrorCode code() {
        return this.code;
    }

    @Override
    public String toString() {
        return "JsonLdException[" + this.code.name() + ", message=" + this.getMessage() + "]";
    }

    public static enum ErrorCode {
        COLLIDING_KEYWORDS("Two properties which expand to the same keyword have been detected"),
        CONFLICTING_INDEXES("Multiple conflicting indexes have been found for the same node"),
        CONTEXT_OVERFLOW("Maximum number of @context URLs exceeded"),
        CYCLIC_IRI_MAPPING("A cycle in IRI mappings has been detected"),
        INVALID_KEYWORD_ID_VALUE("An @id entry was encountered whose value was not a string"),
        INVALID_KEYWORD_IMPORT_VALUE("An invalid value for @import has been found"),
        INVALID_KEYWORD_INCLUDED_VALUE("An included block contains an invalid value"),
        INVALID_KEYWORD_INDEX_VALUE("An @index entry was encountered whose value was not a string"),
        INVALID_KEYWORD_NEST_VALUE("An invalid value for @nest has been found"),
        INVALID_KEYWORD_PREFIX_VALUE("An invalid value for @prefix has been found"),
        INVALID_KEYWORD_PROPAGATE_VALUE("An invalid value for @propagate has been found"),
        INVALID_KEYWORD_PROTECTED_VALUE("An invalid value for @protected has been found"),
        INVALID_KEYWORD_REVERSE_VALUE("An invalid value for an @reverse entry has been detected"),
        INVALID_KEYWORD_VERSION_VALUE("The @version entry was used in a context with an out of range value"),
        INVALID_BASE_DIRECTION("The value of @direction is not \"ltr\", \"rtl\", or null and thus invalid"),
        INVALID_BASE_IRI("An invalid base IRI has been detected"),
        INVALID_CONTAINER_MAPPING("An @container entry was encountered whose value was not one of the following strings: @list, @set, @language, @index, @id, @graph, or @type"),
        INVALID_CONTEXT_ENTRY("An entry in a context is invalid due to processing mode incompatibility"),
        INVALID_CONTEXT_NULLIFICATION("An attempt was made to nullify a context containing protected term definitions"),
        INVALID_DEFAULT_LANGUAGE("The value of the default language is not a string or null and thus invalid"),
        INVALID_IRI_MAPPING("A local context contains a term that has an invalid or missing IRI mapping"),
        INVALID_JSON_LITERAL("An invalid JSON literal was detected"),
        INVALID_KEYWORD_ALIAS("An invalid keyword alias definition has been encountered"),
        INVALID_LANGUAGE_MAP_VALUE("An invalid value in a language map has been detected. It MUST be a string or an array of strings"),
        INVALID_LANGUAGE_MAPPING("An @language entry in a term definition was encountered whose value was neither a string nor null and thus invalid"),
        INVALID_LANGUAGE_TAGGED_STRING("A language-tagged string with an invalid language value was detected"),
        INVALID_LANGUAGE_TAGGED_VALUE("A number, true, or false with an associated language tag was detected"),
        INVALID_LOCAL_CONTEXT("In invalid local context was detected"),
        INVALID_REMOTE_CONTEXT("No valid context document has been found for a referenced remote context"),
        INVALID_REVERSE_PROPERTY_MAP("An invalid reverse property definition has been detected"),
        INVALID_REVERSE_PROPERTY_VALUE("An invalid reverse property map has been detected. No keywords apart from @context are allowed in reverse property maps"),
        INVALID_REVERSE_PROPERTY("An invalid value for a reverse property has been detected. The value of an inverse property must be a node object"),
        INVALID_SCOPED_CONTEXT("The local context defined within a term definition is invalid"),
        INVALID_SCRIPT_ELEMENT("A script element in HTML input which is the target of a fragment identifier does not have an appropriate type attribute"),
        INVALID_SET_OR_LIST_OBJECT("A set object or list object with disallowed entries has been detected"),
        INVALID_TERM_DEFINITION("An invalid term definition has been detected"),
        INVALID_TYPE_MAPPING("An @type entry in a term definition was encountered whose value could not be expanded to an IRI"),
        INVALID_TYPE_VALUE("An invalid value for an @type entry has been detected"),
        INVALID_TYPED_VALUE("A typed value with an invalid type was detected"),
        INVALID_VALUE_OBJECT_VALUE("An invalid value for the @value< entry of a value object has been detected"),
        INVALID_VALUE_OBJECT("A value object with disallowed entries has been detected"),
        INVALID_VOCAB_MAPPING("An invalid vocabulary mapping has been detected"),
        IRI_CONFUSED_WITH_PREFIX("When compacting an IRI would result in an IRI which could be confused with a compact IRI"),
        KEYWORD_REDEFINITION("A keyword redefinition has been detected"),
        LOADING_DOCUMENT_FAILED("The document could not be loaded or parsed"),
        LOADING_REMOTE_CONTEXT_FAILED("There was a problem encountered loading a remote context"),
        MULTIPLE_CONTEXT_LINK_HEADERS("Multiple HTTP Link Headers [RFC8288] using the http://www.w3.org/ns/json-ld#context link relation have been detected"),
        PROCESSING_MODE_CONFLICT("An attempt was made to change the processing mode which is incompatible with the previous specified version"),
        PROTECTED_TERM_REDEFINITION("An attempt was made to redefine a protected term"),
        INVALID_FRAME("The frame is invalid"),
        INVALID_KEYWORD_EMBED_VALUE("The value for @embed is not one recognized for the object embed flag"),
        INVALID_EMBEDDED_NODE("An invalid embedded node has been detected"),
        INVALID_ANNOTATION("An invalid annotation has been detected"),
        LOADING_DOCUMENT_TIMEOUT("A response has not been received within a specified time period"),
        PROCESSING_TIMEOUT_EXCEEDED("A processing has exceeded a defined timeout"),
        UNDEFINED_TERM("An undefined term has been found. Set policy to ignore to pass"),
        INLINE_CONTEXT_IS_NOT_ALLOWED("Inline contexts are not allowed"),
        UNSPECIFIED("An unspecified processing error"),
        MISSING_DOCUMENT_LOADER("A document loader is not present");

        private final String description;

        private ErrorCode(String description) {
            this.description = description;
        }

        public String description() {
            return this.description;
        }

        public static Optional<ErrorCode> find(String name) {
            return Arrays.stream(ErrorCode.values()).filter(code -> code.name().equalsIgnoreCase(name)).findFirst();
        }

        public String toString() {
            return this.description + ", code=" + this.name() + ".";
        }
    }
}

