/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.Document;
import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.Options;
import com.apicatalog.jsonld.compaction.Compaction;
import com.apicatalog.jsonld.compaction.UriCompaction;
import com.apicatalog.jsonld.context.Context;
import com.apicatalog.jsonld.flattening.NodeMap;
import com.apicatalog.jsonld.flattening.NodeMapBuilder;
import com.apicatalog.jsonld.framing.Frame;
import com.apicatalog.jsonld.framing.Framing;
import com.apicatalog.jsonld.framing.FramingState;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.processor.Execution;
import com.apicatalog.jsonld.processor.Expander;
import com.apicatalog.tree.io.TreeIO;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Framer {
    public static Map<String, ?> frame(Document document, Document frame, Options options, Execution runtime) throws JsonLdException {
        TreeIO contextNode = Context.extract(frame.content());
        return Context.inject(Framer.frame(Framer.expand(document, options, runtime), Frame.of(frame, options, runtime), Framer.context(document.url(), contextNode, Frame.contextBase(frame, options), options, runtime), options), contextNode);
    }

    public static final Context context(URI baseUrl, TreeIO localContext, URI localContextBase, Options options, Execution runtime) throws JsonLdException {
        return new Context.Builder(baseUrl, baseUrl, options.mode()).runtime(runtime).loader(options.loader()).update(localContext, localContextBase).build();
    }

    public static final Collection<?> expand(Document document, Options options, Execution runtime) throws JsonLdException {
        return Expander.expand(document, Options.copyOf(options).ordered(false), runtime);
    }

    public static final Collection<?> expand(TreeIO document, Options options, Execution runtime) throws JsonLdException {
        return Expander.expand(document, Expander.context(null, null, options, runtime), options.base(), Options.copyOf(options).ordered(false), runtime);
    }

    public static final Map<String, ?> frame(Collection<?> expanded, Frame frame, Context context, Options options) throws JsonLdException {
        boolean omitGraph;
        Execution runtime = Execution.of(options);
        FramingState state = new FramingState();
        state.setEmbed(options.embed());
        state.setEmbedded(false);
        state.setExplicitInclusion(options.isExplicit());
        state.setRequireAll(options.isRequiredAll());
        state.setOmitDefault(options.isOmitDefault());
        state.setGraphMap(new NodeMapBuilder(expanded, new NodeMap()).build());
        String graphKey = UriCompaction.withVocab(context, "@graph", options);
        if (frame.isDefault(graphKey)) {
            state.setGraphName("@default");
        } else {
            state.setGraphName("@merged");
            state.getGraphMap().merge();
        }
        state.setReversePropertyIndex(Framer.buildReversePropertyIndex(state.getGraphMap()));
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        Framing.with(state, new ArrayList<String>(state.getGraphMap().subjects(state.getGraphName())), frame, resultMap, null).ordered(options.isOrdered()).frame();
        Stream<Object> result = null;
        if (!context.isV10()) {
            Collection<Object> values = resultMap.values();
            List<String> remove = Framer.findBlankNodes(values);
            result = !remove.isEmpty() ? values.stream().map(v -> Framer.removeBlankIdKey(v, remove)) : values.stream();
        }
        if (result == null) {
            result = resultMap.values().stream();
        }
        List<Object> filtered = result.map(Framer::removePreserve).toList();
        Map<Object, Object> compactedOutput = Compaction.with(context, options, runtime).compactArrays(options.isCompactArrays()).ordered(options.isOrdered()).compact(filtered);
        if (compactedOutput instanceof Collection) {
            Collection col = (Collection)((Object)compactedOutput);
            compactedOutput = col.isEmpty() ? Map.of() : Map.of(graphKey, compactedOutput);
        }
        compactedOutput = Framer.replaceNull(compactedOutput);
        boolean bl = omitGraph = options.isOmitGraph() == null ? context.isV11() : options.isOmitGraph().booleanValue();
        if (!omitGraph && !compactedOutput.containsKey(graphKey)) {
            compactedOutput = compactedOutput.isEmpty() ? Map.of(graphKey, List.of()) : Map.of(graphKey, List.of(compactedOutput));
        }
        if (compactedOutput instanceof Map) {
            Map<Object, Object> map;
            Map<Object, Object> typedMap = map = compactedOutput;
            return typedMap;
        }
        throw new IllegalStateException();
    }

    private static final Object removePreserve(Object value) {
        if (value instanceof Collection) {
            Collection array = (Collection)value;
            return array.stream().map(Framer::removePreserve).toList();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            LinkedHashMap object = new LinkedHashMap();
            for (Map.Entry entry : map.entrySet()) {
                if ("@preserve".equals(entry.getKey())) {
                    return entry.getValue();
                }
                object.put(entry.getKey(), Framer.removePreserve(entry.getValue()));
            }
            return object;
        }
        return value;
    }

    private static final Object replaceNull(Object node) {
        if (node == null || "@null".equals(node)) {
            return null;
        }
        if (node instanceof Collection) {
            Collection col = (Collection)node;
            List<Object> result = col.stream().map(Framer::replaceNull).toList();
            return result.size() != 1 || result.get(0) != null ? result : List.of();
        }
        if (node instanceof Map) {
            Map map = (Map)node;
            LinkedHashMap result = new LinkedHashMap(map.size());
            for (Map.Entry entry : map.entrySet()) {
                result.put(entry.getKey(), Framer.replaceNull(entry.getValue()));
            }
            return result;
        }
        return node;
    }

    private static final Object removeBlankIdKey(Object value, List<String> blankNodes) {
        if (value instanceof Collection) {
            Collection array = (Collection)value;
            return array.stream().map(item -> Framer.removeBlankIdKey(item, blankNodes)).toList();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            LinkedHashMap object = new LinkedHashMap();
            for (Map.Entry entry : map.entrySet()) {
                String stringValue;
                Object v;
                if ("@id".equals(entry.getKey()) && (v = entry.getValue()) instanceof String && blankNodes.contains(stringValue = (String)v)) continue;
                object.put(entry.getKey(), Framer.removeBlankIdKey(entry.getValue(), blankNodes));
            }
            return object;
        }
        return value;
    }

    private static final List<String> findBlankNodes(Collection<?> array) {
        HashMap candidates = new HashMap();
        array.forEach(v -> Framer.findBlankNodes(v, candidates));
        return candidates.entrySet().stream().filter(e -> (Integer)e.getValue() == 1).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private static final void findBlankNodes(Object value, Map<String, Integer> blankNodes) {
        if (value instanceof String) {
            String string = (String)value;
            if (BlankNode.isWellFormed(string)) {
                Integer count = blankNodes.computeIfAbsent(string, x -> 0);
                count = count + 1;
                blankNodes.put(string, count);
            }
            return;
        }
        if (value instanceof Collection) {
            Collection array = (Collection)value;
            array.forEach(item -> Framer.findBlankNodes(item, blankNodes));
            return;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            map.values().forEach(v -> Framer.findBlankNodes(v, blankNodes));
        }
    }

    private static Map<String, Map<String, Map<String, Set<String>>>> buildReversePropertyIndex(NodeMap graphMap) {
        HashMap<String, Map<String, Map<String, Set<String>>>> index = new HashMap<String, Map<String, Map<String, Set<String>>>>();
        for (String graphName : graphMap.graphs()) {
            Map graphIndex = index.computeIfAbsent(graphName, k -> new HashMap());
            for (String subject : graphMap.subjects(graphName)) {
                Map node = graphMap.find(graphName, subject).orElse(Map.of());
                if (node == null) continue;
                for (Map.Entry propEntry : node.entrySet()) {
                    Map map;
                    Iterator<Object> iterator;
                    String property = (String)propEntry.getKey();
                    if (Keywords.contains(property)) continue;
                    Object value = propEntry.getValue();
                    if (value instanceof Collection) {
                        Collection items = (Collection)value;
                        iterator = items.iterator();
                        while (iterator.hasNext()) {
                            Map map2;
                            Object v;
                            Object item = iterator.next();
                            if (!(item instanceof Map) || !((v = (map2 = (Map)item).get("@id")) instanceof String)) continue;
                            String targetId = (String)v;
                            graphIndex.computeIfAbsent(property, k -> new HashMap()).computeIfAbsent(targetId, k -> new HashSet()).add(subject);
                        }
                        continue;
                    }
                    if (!(value instanceof Map) || !((iterator = (map = (Map)value).get("@id")) instanceof String)) continue;
                    String targetId = (String)((Object)iterator);
                    graphIndex.computeIfAbsent(property, k -> new HashMap()).computeIfAbsent(targetId, k -> new HashSet()).add(subject);
                }
            }
        }
        return index;
    }
}

