/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.loader;

import com.apicatalog.jsonld.Document;
import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.tree.io.TreeIO;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class StaticLoader
implements DocumentLoader {
    private final Map<URI, Document> resources;
    private final DocumentLoader loader;

    private StaticLoader(Map<URI, Document> resources, DocumentLoader loader) {
        this.resources = resources;
        this.loader = loader;
    }

    public static final Builder newBuilder() {
        return StaticLoader.newBuilder(Map.of());
    }

    public static final Builder newBuilder(StaticLoader loader) {
        return new Builder(loader.resources, loader.loader);
    }

    public static final Builder newBuilder(Map<URI, Document> resources) {
        return new Builder(Objects.requireNonNull(resources), null);
    }

    @Override
    public Document loadDocument(URI url, DocumentLoader.Options options) throws JsonLdException {
        Document document = this.resources.getOrDefault(Objects.requireNonNull(url, "The url must not be null."), null);
        if (document != null) {
            return document;
        }
        if (this.loader != null) {
            return this.loader.loadDocument(url, options);
        }
        throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, "URL [" + String.valueOf(url) + "] is not recogized and fallback loader is not set.");
    }

    public static final class Builder {
        private final Map<URI, Document> resources;
        private DocumentLoader loader;

        Builder(Map<URI, Document> resources, DocumentLoader loader) {
            this.resources = new LinkedHashMap<URI, Document>(resources);
            this.loader = loader;
        }

        public Builder set(String url, Document document) {
            return this.set(URI.create(url), document);
        }

        public Builder set(URI url, Document document) {
            this.resources.put(url, document);
            return this;
        }

        public Builder set(String url, TreeIO node) {
            return this.set(URI.create(url), node);
        }

        public Builder set(URI url, TreeIO node) {
            this.resources.put(url, Document.of(node, url));
            return this;
        }

        public Builder fallback(DocumentLoader loader) {
            this.loader = loader;
            return this;
        }

        public StaticLoader build() {
            return new StaticLoader(Map.copyOf(this.resources), this.loader);
        }
    }
}

