/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.lang;

import java.util.Objects;

public record CompactUri(String prefix, String suffix) {
    public CompactUri {
        Objects.requireNonNull(prefix, "Prefix must not be null");
        Objects.requireNonNull(suffix, "Suffix must not be null");
    }

    public static CompactUri of(String value) {
        if (value == null || value.length() < 3) {
            return null;
        }
        int splitIndex = value.indexOf(58, 1);
        if (splitIndex != -1) {
            String prefix = value.substring(0, splitIndex);
            String suffix = value.substring(splitIndex + 1);
            if (!suffix.startsWith("/") && ("_".equals(prefix) || Character.isAlphabetic(prefix.charAt(0)))) {
                return new CompactUri(prefix, suffix);
            }
        }
        return null;
    }

    public boolean isNotBlank() {
        return !this.isBlank();
    }

    public boolean isBlank() {
        return "_".equals(this.prefix);
    }

    @Override
    public String toString() {
        return this.prefix + ":" + this.suffix;
    }
}

