/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.flattening;

import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.flattening.NodeMap;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.LdAdapter;
import com.apicatalog.tree.io.TreeAdapter;
import com.apicatalog.tree.io.java.NativeAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public final class NodeMapBuilder {
    private final Object element;
    private final NodeMap nodeMap;
    private final String activeGraph;
    private String activeSubject;
    private String activeProperty;
    private Map<String, String> referencedNode;
    private Map<String, Collection<?>> list;

    public NodeMapBuilder(Object element, NodeMap nodeMap) {
        this(element, nodeMap, "@default");
    }

    public NodeMapBuilder(Object element, NodeMap nodeMap, String activeGraph) {
        this.element = element;
        this.nodeMap = nodeMap;
        this.activeGraph = activeGraph;
        this.activeSubject = null;
        this.activeProperty = null;
        this.list = null;
        this.referencedNode = null;
    }

    public NodeMapBuilder activeProperty(String activeProperty) {
        this.activeProperty = activeProperty;
        return this;
    }

    public NodeMapBuilder activeSubject(String activeSubject) {
        this.activeSubject = activeSubject;
        return this;
    }

    public NodeMapBuilder list(Map<String, Collection<?>> list) {
        this.list = list;
        return this;
    }

    public NodeMapBuilder referencedNode(Map<String, String> referencedNode) {
        this.referencedNode = referencedNode;
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NodeMap build() throws JsonLdException {
        Iterator iterator = this.element;
        if (iterator instanceof Collection) {
            Collection elements = (Collection)((Object)iterator);
            for (Object e : elements) {
                if (!(e instanceof Map) && !(e instanceof Collection)) {
                    throw new IllegalStateException();
                }
                new NodeMapBuilder(e, this.nodeMap, this.activeGraph).activeProperty(this.activeProperty).activeSubject(this.activeSubject).list(this.list).referencedNode(this.referencedNode).build();
            }
            return this.nodeMap;
        }
        if (!(this.element instanceof Map)) {
            throw new IllegalStateException();
        }
        LinkedHashMap<String, void> elementMap = new LinkedHashMap<String, void>((Map)this.element);
        Object elementTypeValue = elementMap.get("@type");
        if (elementTypeValue != null) {
            void var3_7;
            if (elementTypeValue instanceof Collection) {
                Collection collection = (Collection)elementTypeValue;
                List<String> list = collection.stream().map(String.class::cast).map(item -> BlankNode.hasPrefix(item) ? this.nodeMap.createIdentifier((String)item) : item).toList();
            } else {
                if (!(elementTypeValue instanceof String)) throw new IllegalStateException();
                String value = (String)elementTypeValue;
                Set<String> set = Set.of(BlankNode.hasPrefix(value) ? this.nodeMap.createIdentifier(value) : value);
            }
            elementMap.put("@type", var3_7);
        }
        if (elementMap.containsKey("@value")) {
            if (this.list == null) {
                Object object = this.nodeMap.get(this.activeGraph, this.activeSubject, this.activeProperty);
                if (object != null) {
                    if (object instanceof Collection) {
                        Collection values = (Collection)object;
                        if (!values.stream().noneMatch(this.element::equals)) return this.nodeMap;
                        if (object instanceof ArrayList) {
                            ArrayList arrayList;
                            ArrayList list = arrayList = (ArrayList)object;
                            list.add(this.element);
                            return this.nodeMap;
                        } else {
                            ArrayList<Object> list = new ArrayList<Object>(values);
                            list.add(this.element);
                            this.nodeMap.set(this.activeGraph, this.activeSubject, this.activeProperty, list);
                        }
                        return this.nodeMap;
                    } else {
                        this.nodeMap.set(this.activeGraph, this.activeSubject, this.activeProperty, List.of(object, this.element));
                    }
                    return this.nodeMap;
                } else {
                    this.nodeMap.set(this.activeGraph, this.activeSubject, this.activeProperty, Set.of(elementMap));
                }
                return this.nodeMap;
            } else {
                this.list.put("@list", NodeMapBuilder.append(this.list.get("@list"), this.element));
            }
            return this.nodeMap;
        } else if (elementMap.containsKey("@list")) {
            LinkedHashMap linkedHashMap = new LinkedHashMap(Map.of("@list", List.of()));
            new NodeMapBuilder(elementMap.get("@list"), this.nodeMap, this.activeGraph).activeSubject(this.activeSubject).activeProperty(this.activeProperty).referencedNode(this.referencedNode).list(linkedHashMap).build();
            if (this.list == null) {
                Object propertyValue = this.nodeMap.get(this.activeGraph, this.activeSubject, this.activeProperty);
                if (propertyValue != null) {
                    this.nodeMap.set(this.activeGraph, this.activeSubject, this.activeProperty, NodeMapBuilder.append(propertyValue, linkedHashMap));
                    return this.nodeMap;
                } else {
                    this.nodeMap.set(this.activeGraph, this.activeSubject, this.activeProperty, Set.of(linkedHashMap));
                }
                return this.nodeMap;
            } else {
                this.list.put("@list", NodeMapBuilder.append(this.list.get("@list"), linkedHashMap));
            }
            return this.nodeMap;
        } else {
            Object includedMap;
            Object v;
            Object reverseMap;
            void var3_15;
            if (!LdAdapter.isNode(this.element, (TreeAdapter)NativeAdapter.instance())) return this.nodeMap;
            Object var3_10 = null;
            if (elementMap.containsKey("@id")) {
                Object v2 = elementMap.get("@id");
                if (!(v2 instanceof String)) return this.nodeMap;
                String idString = (String)v2;
                if (BlankNode.hasPrefix(idString)) {
                    String string = this.nodeMap.createIdentifier(idString);
                } else {
                    String string = idString;
                }
                elementMap.remove("@id");
            } else {
                String string = this.nodeMap.createIdentifier();
            }
            if (var3_15 != null && this.nodeMap.find(this.activeGraph, (String)var3_15).isEmpty()) {
                this.nodeMap.set(this.activeGraph, (String)var3_15, "@id", var3_15);
            }
            if (this.referencedNode != null) {
                Object activePropertyValue = this.nodeMap.get(this.activeGraph, (String)var3_15, this.activeProperty);
                if (activePropertyValue != null) {
                    if (((Collection)activePropertyValue).stream().filter(Map.class::isInstance).noneMatch(this.referencedNode::equals)) {
                        this.nodeMap.set(this.activeGraph, (String)var3_15, this.activeProperty, NodeMapBuilder.append(activePropertyValue, this.referencedNode));
                    }
                } else {
                    this.nodeMap.set(this.activeGraph, (String)var3_15, this.activeProperty, Set.of(this.referencedNode));
                }
            } else if (this.activeProperty != null) {
                Map<String, void> reference = Map.of("@id", var3_15);
                if (this.list == null) {
                    Object object = this.nodeMap.get(this.activeGraph, this.activeSubject, this.activeProperty);
                    if (object != null) {
                        if (((Collection)object).stream().noneMatch(reference::equals)) {
                            this.nodeMap.set(this.activeGraph, this.activeSubject, this.activeProperty, NodeMapBuilder.append(object, reference));
                        }
                    } else {
                        this.nodeMap.set(this.activeGraph, this.activeSubject, this.activeProperty, Set.of(reference));
                    }
                } else {
                    this.list.put("@list", NodeMapBuilder.append(this.list.get("@list"), reference));
                }
            }
            if (elementMap.containsKey("@type")) {
                LinkedHashSet<Object> nodeType = new LinkedHashSet<Object>();
                Object object = this.nodeMap.get(this.activeGraph, (String)var3_15, "@type");
                if (object instanceof Collection) {
                    Collection col = (Collection)object;
                    col.stream().filter(Predicate.not(Objects::isNull)).forEach(nodeType::add);
                } else if (object != null) {
                    nodeType.add(object);
                }
                Iterator typeValue = elementMap.get("@type");
                if (typeValue instanceof Collection) {
                    Collection values = (Collection)((Object)typeValue);
                    values.stream().filter(Predicate.not(Objects::isNull)).map(String.class::cast).forEach(nodeType::add);
                } else {
                    if (!(typeValue instanceof String)) throw new IllegalStateException();
                    String value = (String)((Object)typeValue);
                    nodeType.add(value);
                }
                this.nodeMap.set(this.activeGraph, (String)var3_15, "@type", nodeType);
                elementMap.remove("@type");
            }
            if (elementMap.containsKey("@index")) {
                if (this.nodeMap.contains(this.activeGraph, (String)var3_15, "@index")) {
                    throw new JsonLdException(JsonLdException.ErrorCode.CONFLICTING_INDEXES);
                }
                this.nodeMap.set(this.activeGraph, (String)var3_15, "@index", elementMap.get("@index"));
                elementMap.remove("@index");
            }
            if ((reverseMap = elementMap.get("@reverse")) != null) {
                Map<String, void> map = Map.of("@id", var3_15);
                for (Map.Entry entry : ((Map)reverseMap).entrySet()) {
                    for (Object e : (Collection)entry.getValue()) {
                        new NodeMapBuilder(e, this.nodeMap, this.activeGraph).referencedNode(map).activeProperty(entry.getKey().toString()).build();
                    }
                }
                elementMap.remove("@reverse");
            }
            if ((v = elementMap.get("@graph")) != null) {
                new NodeMapBuilder(v, this.nodeMap, (String)var3_15).build();
                elementMap.remove("@graph");
            }
            if ((includedMap = elementMap.get("@included")) != null) {
                new NodeMapBuilder(includedMap, this.nodeMap, this.activeGraph).build();
                elementMap.remove("@included");
            }
            Iterator properties = elementMap.keySet().stream().sorted().iterator();
            while (properties.hasNext()) {
                String property = (String)properties.next();
                Object v3 = elementMap.get(property);
                if (v3 == null || !(v3 instanceof Map) && !(v3 instanceof Collection)) continue;
                if (BlankNode.hasPrefix(property)) {
                    property = this.nodeMap.createIdentifier(property);
                }
                if (!this.nodeMap.contains(this.activeGraph, (String)var3_15, property)) {
                    this.nodeMap.set(this.activeGraph, (String)var3_15, property, List.of());
                }
                new NodeMapBuilder(v3, this.nodeMap, this.activeGraph).activeSubject((String)var3_15).activeProperty(property).build();
            }
        }
        return this.nodeMap;
    }

    private static Collection<?> append(Object container, Object value) {
        if (container instanceof Collection) {
            Collection col = (Collection)container;
            if (col.isEmpty()) {
                return Set.of(value);
            }
            if (col instanceof ArrayList) {
                ArrayList array = (ArrayList)col;
                array.add(value);
                return array;
            }
            ArrayList<Object> array = new ArrayList<Object>(col);
            array.add(value);
            return array;
        }
        throw new IllegalStateException();
    }
}

