/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.expansion;

import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.Options;
import com.apicatalog.jsonld.context.Context;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.processor.Execution;
import com.apicatalog.tree.io.TreeAdapter;
import com.apicatalog.web.uri.UriResolver;
import com.apicatalog.web.uri.UriUtils;
import com.apicatalog.web.uri.UriValidationPolicy;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class UriExpansion {
    private static final Logger LOGGER = Logger.getLogger(UriExpansion.class.getName());
    private final Context activeContext;
    private final DocumentLoader loader;
    private final Execution runtime;
    private boolean documentRelative;
    private boolean vocab;
    private UriValidationPolicy uriValidation;
    private Object localContext;
    private TreeAdapter adapter;
    private Map<String, Boolean> defined;

    private UriExpansion(Context activeContext, DocumentLoader loader, Execution runtime) {
        this.activeContext = activeContext;
        this.loader = loader;
        this.runtime = runtime;
        this.documentRelative = false;
        this.vocab = false;
        this.localContext = null;
        this.adapter = null;
        this.defined = null;
        this.uriValidation = Options.DEFAULT_URI_VALIDATION;
    }

    public static final UriExpansion with(Context activeContext, DocumentLoader loader, Execution runtime) {
        return new UriExpansion(activeContext, loader, runtime);
    }

    public String expand(String value) throws JsonLdException {
        if (value == null || Keywords.contains(value)) {
            return value;
        }
        if (Keywords.matchForm(value)) {
            LOGGER.log(Level.WARNING, "Value [{0}] of keyword form [@1*ALPHA] is not allowed.", value);
            return null;
        }
        this.initLocalContext(value);
        Optional<TermDefinition> definition = this.activeContext.findTerm(value).filter(term -> this.vocab || Keywords.contains(term.getUriMapping()));
        if (definition.isPresent()) {
            return definition.get().getUriMapping();
        }
        String result = value;
        int splitIndex = result.indexOf(58, 1);
        if (splitIndex != -1) {
            if (splitIndex == 1 && result.charAt(0) == '_' || splitIndex + 2 < result.length() && result.charAt(splitIndex + 1) == '/' && result.charAt(splitIndex + 2) == '/') {
                return result;
            }
            if (BlankNode.hasPrefix(result = this.initPropertyContext(result.substring(0, splitIndex), splitIndex + 1 < result.length() ? result.substring(splitIndex + 1) : "", result)) || UriUtils.isAbsoluteUri(result, this.uriValidation)) {
                return result;
            }
        }
        return this.expandResult(result);
    }

    public UriExpansion documentRelative(boolean value) {
        this.documentRelative = value;
        return this;
    }

    public UriExpansion vocab(boolean value) {
        this.vocab = value;
        return this;
    }

    public UriExpansion localContext(Object value, TreeAdapter adapter) {
        this.localContext = value;
        this.adapter = adapter;
        return this;
    }

    public UriExpansion defined(Map<String, Boolean> value) {
        this.defined = value;
        return this;
    }

    public UriExpansion uriValidation(UriValidationPolicy uriValidation) {
        this.uriValidation = uriValidation;
        return this;
    }

    private void initLocalContext(String value) throws JsonLdException {
        String entryValueString;
        Object entryValue;
        if (this.localContext != null && this.adapter.keys(this.localContext).contains(value) && this.adapter.isString(entryValue = this.adapter.property((Object)value, this.localContext)) && (!this.defined.containsKey(entryValueString = this.adapter.stringValue(entryValue)) || Boolean.FALSE.equals(this.defined.get(entryValueString)))) {
            if (this.runtime.collectsContextKeys()) {
                this.adapter.keyStream(this.localContext).map(String.class::cast).forEach(this.runtime::onContextKey);
            }
            this.activeContext.newTerm(this.localContext, this.adapter, this.defined, this.loader, this.runtime).create(value);
        }
    }

    private String initPropertyContext(String prefix, String suffix, String result) throws JsonLdException {
        if (this.localContext != null && this.adapter.keys(this.localContext).contains(prefix) && !Boolean.TRUE.equals(this.defined.get(prefix))) {
            if (this.runtime.collectsContextKeys()) {
                this.adapter.keyStream(this.localContext).map(String.class::cast).forEach(this.runtime::onContextKey);
            }
            this.activeContext.newTerm(this.localContext, this.adapter, this.defined, this.loader, this.runtime).create(prefix);
        }
        return this.activeContext.findTerm(prefix).filter(TermDefinition::isPrefix).map(TermDefinition::getUriMapping).map(uriMapping -> uriMapping.concat(suffix)).orElse(result);
    }

    private String expandResult(String result) {
        if (this.vocab && this.activeContext.getVocabularyMapping() != null) {
            return this.activeContext.getVocabularyMapping().concat(result);
        }
        if (this.documentRelative) {
            return UriResolver.resolve(this.activeContext.getBaseUri(), result);
        }
        return result;
    }
}

