/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.context;

import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.expansion.UriExpansion;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.CompactUri;
import com.apicatalog.jsonld.lang.Direction;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.processor.Execution;
import com.apicatalog.tree.io.NodeType;
import com.apicatalog.tree.io.TreeAdapter;
import com.apicatalog.web.lang.LanguageTag;
import com.apicatalog.web.uri.UriUtils;
import com.apicatalog.web.uri.UriValidationPolicy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TermDefinitionBuilder {
    private static final Logger LOGGER = Logger.getLogger(TermDefinitionBuilder.class.getName());
    private static final Collection<String> CONTAINER_KEYWORDS = Arrays.asList("@graph", "@id", "@index", "@language", "@list", "@set", "@type");
    private static final Collection<String> PROTECTED_KEYWORDS = Arrays.asList("@id", "@reverse", "@container", "@context", "@direction", "@index", "@language", "@nest", "@prefix", "@protected", "@type");
    private final ActiveContext activeContext;
    private final Object localContext;
    private final TreeAdapter adapter;
    private final Map<String, Boolean> defined;
    private final DocumentLoader loader;
    private final Execution runtime;
    private URI baseUrl;
    private boolean protectedFlag;
    private boolean overrideProtectedFlag;
    private Collection<String> remoteContexts;

    private TermDefinitionBuilder(ActiveContext activeContext, Object localContext, TreeAdapter adapter, Map<String, Boolean> defined, DocumentLoader loader, Execution runtime) {
        this.activeContext = activeContext;
        this.localContext = localContext;
        this.adapter = adapter;
        this.defined = defined;
        this.loader = loader;
        this.runtime = runtime;
        this.baseUrl = null;
        this.protectedFlag = false;
        this.overrideProtectedFlag = false;
        this.remoteContexts = new ArrayList<String>();
    }

    public static final TermDefinitionBuilder with(ActiveContext activeContext, Object localContext, TreeAdapter adapter, Map<String, Boolean> defined, DocumentLoader loader, Execution runtime) {
        return new TermDefinitionBuilder(activeContext, localContext, adapter, defined, loader, runtime);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void create(String term) throws JsonLdException {
        Object prefixValue;
        Object nestValue;
        Object directionValue;
        Object languageValue;
        Object contextValue;
        Object reverseValue;
        Object typeValue;
        boolean simpleTerm;
        Object idValue;
        Collection<Object> valueObjectKeys;
        Function<String, Object> propertyGetter;
        if (term == null || term.isBlank()) {
            throw new JsonLdException(JsonLdException.ErrorCode.INVALID_TERM_DEFINITION);
        }
        if (this.defined.containsKey(term)) {
            if (!this.defined.get(term).booleanValue()) throw new JsonLdException(JsonLdException.ErrorCode.CYCLIC_IRI_MAPPING);
            return;
        }
        this.defined.put(term, false);
        Object value = this.adapter.property((Object)term, this.localContext);
        if ("@type".equals(term)) {
            if (this.activeContext.isV10()) {
                throw new JsonLdException(JsonLdException.ErrorCode.KEYWORD_REDEFINITION);
            }
            if (!this.adapter.isMap(value)) throw new JsonLdException(JsonLdException.ErrorCode.KEYWORD_REDEFINITION);
            Object container = this.adapter.property((Object)"@container", value);
            Object protect = this.adapter.property((Object)"@protected", value);
            if (container != null && this.adapter.isSingleEntry(value)) {
                if (!this.adapter.isString(container) || !"@set".equals(this.adapter.stringValue(container))) {
                    throw new JsonLdException(JsonLdException.ErrorCode.KEYWORD_REDEFINITION);
                }
            } else if (container != null && protect != null && this.adapter.keys(value).size() == 2) {
                if (this.adapter.isString(container) && !"@set".equals(this.adapter.stringValue(container))) throw new JsonLdException(JsonLdException.ErrorCode.KEYWORD_REDEFINITION);
                if (this.adapter.isCollection(container)) {
                    if (this.adapter.elementStream(container).map(arg_0 -> ((TreeAdapter)this.adapter).asString(arg_0)).noneMatch("@set"::equals)) throw new JsonLdException(JsonLdException.ErrorCode.KEYWORD_REDEFINITION);
                }
                if (this.adapter.isMap(container)) {
                    if (this.adapter.keyStream(container).map(arg_0 -> ((TreeAdapter)this.adapter).asString(arg_0)).noneMatch("@set"::equals)) {
                        throw new JsonLdException(JsonLdException.ErrorCode.KEYWORD_REDEFINITION);
                    }
                }
            } else if (protect == null || this.adapter.keys(value).size() != 1) {
                throw new JsonLdException(JsonLdException.ErrorCode.KEYWORD_REDEFINITION);
            }
        } else {
            if (Keywords.contains(term)) {
                throw new JsonLdException(JsonLdException.ErrorCode.KEYWORD_REDEFINITION, "A keyword [" + term + "] redefinition has been detected.");
            }
            if (Keywords.matchForm(term)) {
                LOGGER.log(Level.WARNING, "Term [{0}] has form of a keyword. Keywords cannot be overridden.", term);
                return;
            }
        }
        TermDefinition previousDefinition = this.activeContext.removeTerm(term).orElse(null);
        if (this.adapter.isNull(value)) {
            propertyGetter = x -> null;
            valueObjectKeys = Set.of();
            idValue = false;
            simpleTerm = false;
        } else if (this.adapter.isString(value)) {
            propertyGetter = x -> null;
            valueObjectKeys = Set.of();
            idValue = value;
            simpleTerm = true;
        } else {
            if (!this.adapter.isMap(value)) throw new JsonLdException(JsonLdException.ErrorCode.INVALID_TERM_DEFINITION);
            propertyGetter = name -> this.adapter.property(name, value);
            valueObjectKeys = this.adapter.keyStream(value).map(arg_0 -> ((TreeAdapter)this.adapter).stringValue(arg_0)).toList();
            idValue = this.adapter.property((Object)"@id", value);
            simpleTerm = false;
        }
        TermDefinition definition = new TermDefinition(false, this.protectedFlag, false);
        Object protectedValue = propertyGetter.apply("@protected");
        if (protectedValue != null) {
            if (this.activeContext.isV10()) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_TERM_DEFINITION);
            }
            if (!this.adapter.isBoolean(protectedValue)) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_KEYWORD_PROTECTED_VALUE);
            }
            definition.setProtected(this.adapter.isTrue(protectedValue));
        }
        if ((typeValue = propertyGetter.apply("@type")) != null) {
            if (!this.adapter.isString(typeValue)) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_TYPE_MAPPING);
            }
            String expandedTypeString = UriExpansion.with(this.activeContext, this.loader, this.runtime).localContext(this.localContext, this.adapter).defined(this.defined).vocab(true).expand(this.adapter.stringValue(typeValue));
            if (expandedTypeString == null) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_TYPE_MAPPING);
            }
            if (("@json".equals(expandedTypeString) || "@none".equals(expandedTypeString)) && this.activeContext.isV10() || Keywords.noneMatch(expandedTypeString, "@id", "@json", "@none", "@vocab") && UriUtils.isNotAbsoluteUri(expandedTypeString, UriValidationPolicy.Full)) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_TYPE_MAPPING);
            }
            definition.setTypeMapping(expandedTypeString);
        }
        if ((reverseValue = propertyGetter.apply("@reverse")) != null) {
            if (valueObjectKeys.contains("@id") || valueObjectKeys.contains("@nest")) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_REVERSE_PROPERTY);
            }
            if (!this.adapter.isString(reverseValue)) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_IRI_MAPPING);
            }
            String reverseString = this.adapter.stringValue(reverseValue);
            if (Keywords.matchForm(reverseString)) {
                LOGGER.log(Level.WARNING, "The value [{0}] associated with @reverse cannot have form of a keyword.", reverseString);
                return;
            }
            definition.setUriMapping(UriExpansion.with(this.activeContext, this.loader, this.runtime).localContext(this.localContext, this.adapter).defined(this.defined).vocab(true).expand(reverseString));
            if (UriUtils.isNotURI(definition.getUriMapping())) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_IRI_MAPPING);
            }
            Object containerValue = propertyGetter.apply("@container");
            if (containerValue != null) {
                if (!this.adapter.isString(containerValue) && !this.adapter.isNull(containerValue)) {
                    throw new JsonLdException(JsonLdException.ErrorCode.INVALID_REVERSE_PROPERTY);
                }
                if (this.adapter.isString(containerValue)) {
                    String containerString = this.adapter.stringValue(containerValue);
                    if (!"@set".equals(containerString) && !"@index".equals(containerString)) throw new JsonLdException(JsonLdException.ErrorCode.INVALID_REVERSE_PROPERTY);
                    definition.addContainerMapping(containerString);
                }
            }
            definition.setReverseProperty(true);
            this.activeContext.setTerm(term, definition);
            this.defined.put(term, Boolean.TRUE);
        } else if (!(idValue == null || this.adapter.isString(idValue) && term.equals(this.adapter.stringValue(idValue)))) {
            if (!this.adapter.isNull(idValue) && !Boolean.FALSE.equals(idValue)) {
                if (!this.adapter.isString(idValue)) {
                    throw new JsonLdException(JsonLdException.ErrorCode.INVALID_IRI_MAPPING);
                }
                String idValueString = this.adapter.stringValue(idValue);
                if (!Keywords.contains(idValueString) && Keywords.matchForm(idValueString)) {
                    LOGGER.log(Level.WARNING, "The value [{0}] associated with @id has form of a keyword but is not keyword.", idValueString);
                    return;
                }
                definition.setUriMapping(UriExpansion.with(this.activeContext, this.loader, this.runtime).localContext(this.localContext, this.adapter).defined(this.defined).vocab(true).expand(idValueString));
                if ("@context".equals(definition.getUriMapping())) {
                    throw new JsonLdException(JsonLdException.ErrorCode.INVALID_KEYWORD_ALIAS);
                }
                if (!Keywords.contains(definition.getUriMapping()) && UriUtils.isNotURI(definition.getUriMapping()) && !BlankNode.hasPrefix(definition.getUriMapping())) {
                    throw new JsonLdException(JsonLdException.ErrorCode.INVALID_IRI_MAPPING);
                }
                if (term.substring(0, term.length() - 1).indexOf(58, 1) != -1 || term.contains("/")) {
                    this.defined.put(term, Boolean.TRUE);
                    String expandedTerm = UriExpansion.with(this.activeContext, this.loader, this.runtime).localContext(this.localContext, this.adapter).defined(this.defined).vocab(true).expand(term);
                    if (expandedTerm == null || !expandedTerm.equals(definition.getUriMapping())) {
                        throw new JsonLdException(JsonLdException.ErrorCode.INVALID_IRI_MAPPING);
                    }
                }
                if (definition.isNotPrefix()) {
                    definition.setPrefix(!term.contains(":") && !term.contains("/") && simpleTerm && definition.getUriMapping() != null && (UriUtils.endsWithGenDelim(definition.getUriMapping()) && UriUtils.isURI(definition.getUriMapping().substring(0, definition.getUriMapping().length() - 1)) || BlankNode.hasPrefix(definition.getUriMapping())));
                }
            }
        } else if (term.indexOf(58, 1) != -1) {
            CompactUri compactUri = CompactUri.of(term);
            if (compactUri != null && compactUri.isNotBlank() && this.adapter.keys(this.localContext).contains(compactUri.prefix())) {
                this.activeContext.newTerm(this.localContext, this.adapter, this.defined, this.loader, this.runtime).create(compactUri.prefix());
            }
            if (compactUri != null && compactUri.isNotBlank() && this.activeContext.containsTerm(compactUri.prefix())) {
                definition.setUriMapping(this.activeContext.findTerm(compactUri.prefix()).map(TermDefinition::getUriMapping).map(u -> u + compactUri.suffix()).orElse(null));
            } else if (UriUtils.isURI(term) || BlankNode.hasPrefix(term)) {
                definition.setUriMapping(term);
            }
        } else if (term.contains("/")) {
            definition.setUriMapping(UriExpansion.with(this.activeContext, this.loader, this.runtime).localContext(this.localContext, this.adapter).defined(this.defined).vocab(true).expand(term));
            if (UriUtils.isNotURI(definition.getUriMapping())) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_IRI_MAPPING);
            }
        } else if ("@type".equals(term)) {
            definition.setUriMapping("@type");
        } else {
            if (this.activeContext.getVocabularyMapping() == null) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_IRI_MAPPING);
            }
            definition.setUriMapping(this.activeContext.getVocabularyMapping().concat(term));
        }
        Object containerValue = propertyGetter.apply("@container");
        if (containerValue != null) {
            if (!this.validateContainer(containerValue)) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_CONTAINER_MAPPING);
            }
            this.adapter.asStream(containerValue).filter(arg_0 -> ((TreeAdapter)this.adapter).isString(arg_0)).map(arg_0 -> ((TreeAdapter)this.adapter).stringValue(arg_0)).forEach(definition::addContainerMapping);
            if (definition.getContainerMapping().contains("@type")) {
                if (definition.getTypeMapping() == null) {
                    definition.setTypeMapping("@id");
                }
                if (!"@id".equals(definition.getTypeMapping()) && !"@vocab".equals(definition.getTypeMapping())) {
                    throw new JsonLdException(JsonLdException.ErrorCode.INVALID_TYPE_MAPPING);
                }
            }
        }
        if (valueObjectKeys.contains("@index")) {
            if (this.activeContext.isV10() || !definition.getContainerMapping().contains("@index")) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_TERM_DEFINITION);
            }
            Object index = propertyGetter.apply("@index");
            if (!this.adapter.isString(index)) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_TERM_DEFINITION);
            }
            String indexString = this.adapter.stringValue(index);
            String expandedIndex = UriExpansion.with(this.activeContext, this.loader, this.runtime).localContext(this.localContext, this.adapter).defined(this.defined).vocab(true).expand(indexString);
            if (expandedIndex == null || UriUtils.isNotURI(expandedIndex)) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_TERM_DEFINITION);
            }
            definition.setIndexMapping(indexString);
        }
        if ((contextValue = propertyGetter.apply("@context")) != null) {
            if (this.activeContext.isV10()) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_TERM_DEFINITION);
            }
            try {
                this.activeContext.newContext(this.loader, this.runtime).overrideProtected(true).remoteContexts(new ArrayList<String>(this.remoteContexts)).validateScopedContext(false).build(contextValue, this.adapter, this.baseUrl);
            }
            catch (JsonLdException e) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_SCOPED_CONTEXT, (Throwable)e);
            }
            definition.setLocalContext(contextValue, this.adapter);
            definition.setBaseUrl(this.baseUrl);
        }
        if ((languageValue = propertyGetter.apply("@language")) != null && !valueObjectKeys.contains("@type")) {
            if (this.adapter.isNull(languageValue)) {
                definition.setLanguageMapping("@null");
            } else {
                if (!this.adapter.isString(languageValue)) throw new JsonLdException(JsonLdException.ErrorCode.INVALID_LANGUAGE_MAPPING);
                String language = this.adapter.stringValue(languageValue);
                if (!LanguageTag.isWellFormed(language)) {
                    LOGGER.log(Level.WARNING, "Language tag [{0}] is not well formed.", language);
                }
                definition.setLanguageMapping(language);
            }
        }
        if ((directionValue = propertyGetter.apply("@direction")) != null && !valueObjectKeys.contains("@type")) {
            if (this.adapter.isNull(directionValue)) {
                definition.setDirectionMapping(Direction.NULL);
            } else {
                if (!this.adapter.isString(directionValue)) throw new JsonLdException(JsonLdException.ErrorCode.INVALID_BASE_DIRECTION);
                String directionString = this.adapter.stringValue(directionValue);
                if ("ltr".equals(directionString)) {
                    definition.setDirectionMapping(Direction.LTR);
                } else {
                    if (!"rtl".equals(directionString)) throw new JsonLdException(JsonLdException.ErrorCode.INVALID_BASE_DIRECTION);
                    definition.setDirectionMapping(Direction.RTL);
                }
            }
        }
        if ((nestValue = propertyGetter.apply("@nest")) != null) {
            if (this.activeContext.isV10()) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_TERM_DEFINITION);
            }
            if (!this.adapter.isString(nestValue)) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_KEYWORD_NEST_VALUE);
            }
            String nestString = this.adapter.stringValue(nestValue);
            if (Keywords.contains(nestString) && !"@nest".equals(nestString)) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_KEYWORD_NEST_VALUE);
            }
            definition.setNestValue(nestString);
        }
        if ((prefixValue = propertyGetter.apply("@prefix")) != null) {
            if (this.activeContext.isV10() || term.contains(":") || term.contains("/")) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_TERM_DEFINITION);
            }
            NodeType prefixType = this.adapter.type(prefixValue);
            if (prefixType == NodeType.TRUE) {
                definition.setPrefix(true);
            } else {
                if (prefixType != NodeType.FALSE) throw new JsonLdException(JsonLdException.ErrorCode.INVALID_KEYWORD_PREFIX_VALUE);
                definition.setPrefix(false);
            }
            if (definition.isPrefix() && Keywords.contains(definition.getUriMapping())) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_TERM_DEFINITION);
            }
        }
        if (!PROTECTED_KEYWORDS.containsAll(valueObjectKeys)) {
            throw new JsonLdException(JsonLdException.ErrorCode.INVALID_TERM_DEFINITION);
        }
        if (!this.overrideProtectedFlag && previousDefinition != null && previousDefinition.isProtected()) {
            if (definition.isNotSameExcept(previousDefinition)) {
                throw new JsonLdException(JsonLdException.ErrorCode.PROTECTED_TERM_REDEFINITION);
            }
            this.activeContext.setTerm(term, previousDefinition);
        } else {
            this.activeContext.setTerm(term, definition);
        }
        this.defined.put(term, true);
    }

    public TermDefinitionBuilder baseUrl(URI baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public TermDefinitionBuilder protectedFlag(boolean protectedFlag) {
        this.protectedFlag = protectedFlag;
        return this;
    }

    public TermDefinitionBuilder overrideProtectedFlag(boolean overrideProtectedFlag) {
        this.overrideProtectedFlag = overrideProtectedFlag;
        return this;
    }

    public TermDefinitionBuilder remoteContexts(Collection<String> remoteContexts) {
        this.remoteContexts = remoteContexts;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean validateContainer(Object value) {
        if (this.adapter.isNull(value)) {
            return false;
        }
        Object container = value;
        if (this.activeContext.isV10()) {
            if (!this.adapter.isString(container)) return false;
            if (!Keywords.noneMatch(this.adapter.stringValue(container), "@graph", "@id", "@type")) return false;
            return true;
        }
        if (this.adapter.isSingleElement(container)) {
            container = this.adapter.singleElement(container);
        }
        if (this.adapter.isString(container)) {
            return CONTAINER_KEYWORDS.contains(this.adapter.stringValue(container));
        }
        if (!this.adapter.isCollection(container)) return false;
        if (!TermDefinitionBuilder.validateContainerArray(this.adapter.elementStream(container).filter(arg_0 -> ((TreeAdapter)this.adapter).isString(arg_0)).map(arg_0 -> ((TreeAdapter)this.adapter).stringValue(arg_0)).toList())) return false;
        return true;
    }

    private static final boolean validateContainerArray(Collection<String> containers) {
        if (containers.size() > 3) {
            return false;
        }
        if (containers.contains("@graph") && (containers.contains("@id") || containers.contains("@index"))) {
            return containers.size() == 2 || containers.contains("@set");
        }
        return containers.size() == 2 && containers.contains("@set") && (containers.contains("@graph") || containers.contains("@id") || containers.contains("@index") || containers.contains("@language") || containers.contains("@type"));
    }
}

