/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.context;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class InverseContext {
    private final Set<String> variables = new HashSet<String>();
    private final Map<Key, Map<String, String>> mapping = new LinkedHashMap<Key, Map<String, String>>();

    public boolean contains(String variable) {
        return this.variables.contains(variable);
    }

    public boolean contains(String variable, String container, String type) {
        return this.mapping.containsKey(new Key(variable, container, type));
    }

    public InverseContext setIfAbsent(String variable, String container, String type, String key, String value) {
        this.variables.add(variable);
        this.mapping.computeIfAbsent(new Key(variable, container, type), k -> new LinkedHashMap()).putIfAbsent(key, value);
        return this;
    }

    public Optional<String> get(String variable, String container, String type, String key) {
        return Optional.ofNullable(this.mapping.get(new Key(variable, container, type))).map(inner -> (String)inner.get(key));
    }

    private record Key(String variable, String container, String type) {
    }
}

