/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.framing;

import com.apicatalog.jsonld.JsonLdEmbed;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.framing.Frame;
import com.apicatalog.jsonld.framing.FrameMatcher;
import com.apicatalog.jsonld.framing.FramingState;
import com.apicatalog.jsonld.json.JsonMapBuilder;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.lang.ListObject;
import com.apicatalog.jsonld.lang.NodeObject;
import com.apicatalog.jsonld.lang.Utils;
import com.apicatalog.jsonld.lang.ValueObject;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Framing {
    private final FramingState state;
    private final List<String> subjects;
    private final Frame frame;
    private final JsonMapBuilder parent;
    private String activeProperty;
    private boolean ordered;

    private Framing(FramingState state, List<String> subjects, Frame frame, JsonMapBuilder parent, String activeProperty) {
        this.state = state;
        this.subjects = subjects;
        this.frame = frame;
        this.parent = parent;
        this.activeProperty = activeProperty;
        this.ordered = false;
    }

    public static final Framing with(FramingState state, List<String> subjects, Frame frame, JsonMapBuilder parent, String activeProperty) {
        return new Framing(state, subjects, frame, parent, activeProperty);
    }

    public Framing ordered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    public void frame() throws JsonLdError {
        JsonLdEmbed embed = this.frame.getEmbed(this.state.getEmbed());
        boolean explicit = this.frame.getExplicit(this.state.isExplicitInclusion());
        boolean requireAll = this.frame.getRequireAll(this.state.isRequireAll());
        List<String> matchedSubjects = FrameMatcher.with(this.state, this.frame, requireAll).match(this.subjects);
        if (this.ordered) {
            Collections.sort(matchedSubjects);
        }
        for (String id : matchedSubjects) {
            JsonValue reverseObject;
            Map<String, JsonValue> node = this.state.getGraphMap().get(this.state.getGraphName(), id);
            String nodeId = JsonUtils.isString(node.get("@id")) ? ((JsonString)node.get("@id")).getString() : null;
            JsonMapBuilder output = JsonMapBuilder.create();
            output.put("@id", (JsonValue)Json.createValue((String)id));
            if (this.activeProperty == null) {
                this.state.clearDone();
            }
            if (!this.state.isEmbedded() && this.state.isDone(id)) continue;
            if (this.state.isEmbedded() && (JsonLdEmbed.NEVER == embed || this.state.isParent(nodeId))) {
                Framing.addToResult(this.parent, this.activeProperty, (JsonValue)output.build());
                continue;
            }
            if (this.state.isEmbedded() && JsonLdEmbed.ONCE == embed && this.state.isDone(id)) {
                Framing.addToResult(this.parent, this.activeProperty, (JsonValue)output.build());
                continue;
            }
            this.state.markDone(id);
            this.state.addParent(nodeId);
            if (this.state.getGraphMap().contains(id)) {
                Frame subframe;
                boolean recurse;
                if (!this.frame.contains("@graph")) {
                    recurse = !"@merged".equals(this.state.getGraphName());
                    subframe = Frame.of((JsonStructure)JsonValue.EMPTY_JSON_OBJECT);
                } else {
                    recurse = !"@merged".equals(id) && !"@default".equals(id);
                    subframe = JsonUtils.isObject(this.frame.get("@graph")) || JsonUtils.isArray(this.frame.get("@graph")) ? Frame.of((JsonStructure)this.frame.get("@graph")) : Frame.of((JsonStructure)JsonValue.EMPTY_JSON_OBJECT);
                }
                if (recurse) {
                    FramingState graphState = new FramingState(this.state);
                    graphState.setGraphName(id);
                    graphState.setEmbedded(false);
                    Framing.with(graphState, new ArrayList<String>(this.state.getGraphMap().get(id).map(Map::keySet).orElse(Collections.emptySet())), subframe, output, "@graph").ordered(this.ordered).frame();
                }
            }
            if (this.frame.contains("@included")) {
                FramingState includedState = new FramingState(this.state);
                includedState.setEmbedded(false);
                Framing.with(includedState, this.subjects, Frame.of((JsonStructure)this.frame.get("@included")), output, "@included").ordered(this.ordered).frame();
            }
            for (String property : Utils.index(this.state.getGraphMap().properties(this.state.getGraphName(), id), this.ordered)) {
                JsonValue objects = this.state.getGraphMap().get(this.state.getGraphName(), id, property);
                if (Keywords.contains(property)) {
                    output.put(property, objects);
                    continue;
                }
                if (explicit && !this.frame.contains(property)) continue;
                for (JsonValue item : JsonUtils.toCollection(objects)) {
                    JsonValue subframe = this.frame.get(property);
                    if (subframe == null) {
                        subframe = Json.createObjectBuilder().add("@embed", "@".concat(embed.name().toLowerCase())).add("@explicit", explicit).add("@requireAll", requireAll).build();
                    }
                    if (ListObject.isListObject(item)) {
                        JsonObject listFrame = null;
                        if (this.frame.contains(property) && JsonUtils.isNotEmptyArray(this.frame.get(property)) && JsonUtils.isObject((JsonValue)this.frame.get(property).asJsonArray().get(0))) {
                            listFrame = (JsonValue)((JsonValue)this.frame.get(property).asJsonArray().get(0)).asJsonObject().get((Object)"@list");
                        }
                        if (listFrame == null) {
                            listFrame = Json.createObjectBuilder().add("@embed", "@".concat(embed.name().toLowerCase())).add("@explicit", explicit).add("@requireAll", requireAll).build();
                        }
                        JsonArrayBuilder list = Json.createArrayBuilder();
                        for (JsonValue listItem : JsonUtils.toCollection((JsonValue)item.asJsonObject().get((Object)"@list"))) {
                            if (NodeObject.isNodeReference(listItem)) {
                                FramingState listState = new FramingState(this.state);
                                listState.setEmbedded(true);
                                JsonMapBuilder listResult = JsonMapBuilder.create();
                                Framing.with(listState, Arrays.asList(listItem.asJsonObject().getString("@id")), Frame.of((JsonStructure)listFrame), listResult, "@list").ordered(this.ordered).frame();
                                if (!listResult.containsKey("@list")) continue;
                                listResult.get("@list").ifPresent(arg_0 -> ((JsonArrayBuilder)list).add(arg_0));
                                continue;
                            }
                            list.add(listItem);
                        }
                        output.add(property, Json.createObjectBuilder().add("@list", list));
                        continue;
                    }
                    if (NodeObject.isNodeReference(item)) {
                        FramingState clonedState = new FramingState(this.state);
                        clonedState.setEmbedded(true);
                        Framing.with(clonedState, Arrays.asList(item.asJsonObject().getString("@id")), Frame.of((JsonStructure)subframe), output, property).ordered(this.ordered).frame();
                        continue;
                    }
                    if (ValueObject.isValueObject(item)) {
                        if (!Frame.of((JsonStructure)subframe).matchValue(item)) continue;
                        output.add(property, item);
                        continue;
                    }
                    output.add(property, item);
                }
            }
            for (String property : this.frame.keys()) {
                JsonObject propertyFrame;
                if (output.containsKey(property) || !"@type".equals(property) && Keywords.matchForm(property) || "@type".equals(property) && !this.frame.isDefaultObject(property) || Frame.getBoolean(propertyFrame = JsonUtils.isArray(this.frame.get(property)) && JsonUtils.isNotEmptyArray(this.frame.get(property)) ? this.frame.get(property).asJsonArray().getJsonObject(0) : JsonValue.EMPTY_JSON_OBJECT, "@omitDefault", this.state.isOmitDefault())) continue;
                JsonValue defaultValue = (JsonValue)propertyFrame.get((Object)"@default");
                if (JsonUtils.isNull(defaultValue)) {
                    defaultValue = Json.createValue((String)"@null");
                }
                output.add(property, Json.createObjectBuilder().add("@preserve", Json.createArrayBuilder().add(defaultValue)));
            }
            if (this.frame.contains("@reverse") && JsonUtils.isObject(reverseObject = this.frame.get("@reverse"))) {
                for (String reverseProperty : reverseObject.asJsonObject().keySet()) {
                    JsonValue subframe = (JsonValue)reverseObject.asJsonObject().get((Object)reverseProperty);
                    for (String subjectProperty : this.state.getGraphMap().get(this.state.getGraphName()).map(Map::keySet).orElse(Collections.emptySet())) {
                        JsonValue nodeValues = this.state.getGraphMap().get(this.state.getGraphName(), subjectProperty, reverseProperty);
                        if (nodeValues == null) continue;
                        if (!JsonUtils.toCollection(nodeValues).stream().filter(JsonUtils::isObject).map(JsonObject.class::cast).filter(v -> v.containsKey((Object)"@id")).map(v -> v.getString("@id")).anyMatch(vid -> Objects.equals(vid, id))) continue;
                        JsonMapBuilder reverseResult = JsonMapBuilder.create();
                        FramingState reverseState = new FramingState(this.state);
                        reverseState.setEmbedded(true);
                        Framing.with(reverseState, Arrays.asList(subjectProperty), Frame.of((JsonStructure)subframe), reverseResult, null).ordered(this.ordered).frame();
                        output.getMapBuilder("@reverse").add(reverseProperty, (JsonValue)reverseResult.valuesToArray());
                    }
                }
            }
            this.state.removeLastParent();
            Framing.addToResult(this.parent, this.activeProperty, (JsonValue)output.build());
        }
    }

    private static void addToResult(JsonMapBuilder result, String property, JsonValue value) {
        if (property == null) {
            result.put(Integer.toHexString(result.size()), value);
        } else {
            result.add(property, value);
        }
    }
}

