/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld;

import com.apicatalog.jsonld.JsonLdEmbed;
import com.apicatalog.jsonld.JsonLdVersion;
import com.apicatalog.jsonld.context.cache.Cache;
import com.apicatalog.jsonld.context.cache.LruCache;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.SchemeRouter;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.net.URI;

public final class JsonLdOptions {
    private URI base;
    private boolean compactArrays;
    private boolean compactToRelative;
    private DocumentLoader documentLoader;
    private Document expandContext;
    private boolean extractAllScripts;
    private boolean ordered;
    private JsonLdVersion processingMode;
    private boolean produceGeneralizedRdf;
    private RdfDirection rdfDirection;
    private boolean useNativeTypes;
    private boolean useRdfType;
    private JsonLdEmbed embed;
    private boolean explicit;
    private boolean omitDefault;
    private Boolean omitGraph;
    private boolean requiredAll;
    private boolean numericId;
    private Cache<String, JsonValue> contextCache;
    private Cache<String, Document> documentCache;

    public JsonLdOptions() {
        this(SchemeRouter.defaultInstance());
    }

    public JsonLdOptions(DocumentLoader loader) {
        this.base = null;
        this.compactArrays = true;
        this.compactToRelative = true;
        this.documentLoader = loader;
        this.expandContext = null;
        this.extractAllScripts = false;
        this.ordered = false;
        this.processingMode = JsonLdVersion.V1_1;
        this.produceGeneralizedRdf = true;
        this.rdfDirection = null;
        this.useNativeTypes = false;
        this.useRdfType = false;
        this.embed = JsonLdEmbed.ONCE;
        this.explicit = false;
        this.omitDefault = false;
        this.omitGraph = null;
        this.requiredAll = false;
        this.numericId = false;
        this.contextCache = new LruCache<String, JsonValue>(256);
        this.documentCache = null;
    }

    public JsonLdOptions(JsonLdOptions options) {
        this.base = options.base;
        this.compactArrays = options.compactArrays;
        this.compactToRelative = options.compactToRelative;
        this.documentLoader = options.documentLoader;
        this.expandContext = options.expandContext;
        this.extractAllScripts = options.extractAllScripts;
        this.ordered = options.ordered;
        this.processingMode = options.processingMode;
        this.produceGeneralizedRdf = options.produceGeneralizedRdf;
        this.rdfDirection = options.rdfDirection;
        this.useNativeTypes = options.useNativeTypes;
        this.useRdfType = options.useRdfType;
        this.embed = options.embed;
        this.explicit = options.explicit;
        this.omitDefault = options.omitDefault;
        this.omitGraph = options.omitGraph;
        this.requiredAll = options.requiredAll;
        this.numericId = options.numericId;
        this.contextCache = options.contextCache;
        this.documentCache = options.documentCache;
    }

    public URI getBase() {
        return this.base;
    }

    public boolean isCompactArrays() {
        return this.compactArrays;
    }

    public boolean isCompactToRelative() {
        return this.compactToRelative;
    }

    public DocumentLoader getDocumentLoader() {
        return this.documentLoader;
    }

    public boolean isExtractAllScripts() {
        return this.extractAllScripts;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public JsonLdVersion getProcessingMode() {
        return this.processingMode;
    }

    public boolean isProduceGeneralizedRdf() {
        return this.produceGeneralizedRdf;
    }

    public RdfDirection getRdfDirection() {
        return this.rdfDirection;
    }

    public boolean isUseNativeTypes() {
        return this.useNativeTypes;
    }

    public boolean isUseRdfType() {
        return this.useRdfType;
    }

    public Document getExpandContext() {
        return this.expandContext;
    }

    public void setBase(URI baseUri) {
        this.base = baseUri;
    }

    public void setCompactArrays(boolean compactArrays) {
        this.compactArrays = compactArrays;
    }

    public void setCompactToRelative(boolean compactToRelative) {
        this.compactToRelative = compactToRelative;
    }

    public void setDocumentLoader(DocumentLoader documentLoader) {
        this.documentLoader = documentLoader;
    }

    public void setExtractAllScripts(boolean extractAllScripts) {
        this.extractAllScripts = extractAllScripts;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public void setProcessingMode(JsonLdVersion processingMode) {
        this.processingMode = processingMode;
    }

    public void setProduceGeneralizedRdf(boolean produceGeneralizedRdf) {
        this.produceGeneralizedRdf = produceGeneralizedRdf;
    }

    public void setRdfDirection(RdfDirection rdfDirection) {
        this.rdfDirection = rdfDirection;
    }

    public void setUseNativeTypes(boolean useNativeTypes) {
        this.useNativeTypes = useNativeTypes;
    }

    public void setUseRdfType(boolean useRdfType) {
        this.useRdfType = useRdfType;
    }

    public void setExpandContext(String contextLocation) {
        if (contextLocation == null) {
            this.expandContext = null;
            return;
        }
        this.expandContext = JsonDocument.of((JsonStructure)Json.createArrayBuilder().add(contextLocation).build());
    }

    public void setExpandContext(URI contextUri) {
        if (contextUri == null) {
            this.expandContext = null;
            return;
        }
        this.setExpandContext(contextUri.toString());
    }

    public void setExpandContext(JsonObject context) {
        if (context == null) {
            this.expandContext = null;
            return;
        }
        this.expandContext = JsonDocument.of((JsonStructure)context);
    }

    public void setExpandContext(Document context) {
        this.expandContext = context;
    }

    public JsonLdEmbed getEmbed() {
        return this.embed;
    }

    public void setEmbed(JsonLdEmbed embed) {
        this.embed = embed;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public void setExplicit(boolean explicit) {
        this.explicit = explicit;
    }

    public boolean isOmitDefault() {
        return this.omitDefault;
    }

    public void setOmitDefault(boolean omitDefault) {
        this.omitDefault = omitDefault;
    }

    public Boolean isOmitGraph() {
        return this.omitGraph;
    }

    public void setOmitGraph(Boolean omitGraph) {
        this.omitGraph = omitGraph;
    }

    public boolean isRequiredAll() {
        return this.requiredAll;
    }

    public void setRequiredAll(boolean requiredAll) {
        this.requiredAll = requiredAll;
    }

    public void setNumericId(boolean enable) {
        this.numericId = enable;
    }

    public boolean isNumericId() {
        return this.numericId;
    }

    public Cache<String, JsonValue> getContextCache() {
        return this.contextCache;
    }

    public void setContextCache(Cache<String, JsonValue> contextCache) {
        this.contextCache = contextCache;
    }

    public Cache<String, Document> getDocumentCache() {
        return this.documentCache;
    }

    public void setDocumentCache(Cache<String, Document> documentCache) {
        this.documentCache = documentCache;
    }

    public static enum RdfDirection {
        I18N_DATATYPE,
        COMPOUND_LITERAL;

    }
}

