/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public enum JsonLdErrorCode {
    COLLIDING_KEYWORDS,
    CONFLICTING_INDEXES,
    CONTEXT_OVERFLOW,
    CYCLIC_IRI_MAPPING,
    INVALID_KEYWORD_ID_VALUE,
    INVALID_KEYWORD_IMPORT_VALUE,
    INVALID_KEYWORD_INCLUDED_VALUE,
    INVALID_KEYWORD_INDEX_VALUE,
    INVALID_KEYWORD_NEST_VALUE,
    INVALID_KEYWORD_PREFIX_VALUE,
    INVALID_KEYWORD_PROPAGATE_VALUE,
    INVALID_KEYWORD_PROTECTED_VALUE,
    INVALID_KEYWORD_REVERSE_VALUE,
    INVALID_KEYWORD_VERSION_VALUE,
    INVALID_BASE_DIRECTION,
    INVALID_BASE_IRI,
    INVALID_CONTAINER_MAPPING,
    INVALID_CONTEXT_ENTRY,
    INVALID_CONTEXT_NULLIFICATION,
    INVALID_DEFAULT_LANGUAGE,
    INVALID_IRI_MAPPING,
    INVALID_JSON_LITERAL,
    INVALID_KEYWORD_ALIAS,
    INVALID_LANGUAGE_MAP_VALUE,
    INVALID_LANGUAGE_MAPPING,
    INVALID_LANGUAGE_TAGGED_STRING,
    INVALID_LANGUAGE_TAGGED_VALUE,
    INVALID_LOCAL_CONTEXT,
    INVALID_REMOTE_CONTEXT,
    INVALID_REVERSE_PROPERTY_MAP,
    INVALID_REVERSE_PROPERTY_VALUE,
    INVALID_REVERSE_PROPERTY,
    INVALID_SCOPED_CONTEXT,
    INVALID_SCRIPT_ELEMENT,
    INVALID_SET_OR_LIST_OBJECT,
    INVALID_TERM_DEFINITION,
    INVALID_TYPE_MAPPING,
    INVALID_TYPE_VALUE,
    INVALID_TYPED_VALUE,
    INVALID_VALUE_OBJECT_VALUE,
    INVALID_VALUE_OBJECT,
    INVALID_VOCAB_MAPPING,
    IRI_CONFUSED_WITH_PREFIX,
    KEYWORD_REDEFINITION,
    LOADING_DOCUMENT_FAILED,
    LOADING_REMOTE_CONTEXT_FAILED,
    MULTIPLE_CONTEXT_LINK_HEADERS,
    PROCESSING_MODE_CONFLICT,
    PROTECTED_TERM_REDEFINITION,
    INVALID_FRAME,
    INVALID_KEYWORD_EMBED_VALUE,
    UNSPECIFIED;

    private static final Map<JsonLdErrorCode, String> CODE_TO_MESSAGE;

    public String toMessage() {
        return CODE_TO_MESSAGE.getOrDefault((Object)this, "Processing error") + " [code=" + this + "].";
    }

    static {
        EnumMap<JsonLdErrorCode, String> messages = new EnumMap<JsonLdErrorCode, String>(JsonLdErrorCode.class);
        messages.put(COLLIDING_KEYWORDS, "Two properties which expand to the same keyword have been detected");
        messages.put(CONFLICTING_INDEXES, "Multiple conflicting indexes have been found for the same node");
        messages.put(CONTEXT_OVERFLOW, "Maximum number of @context URLs exceeded");
        messages.put(CYCLIC_IRI_MAPPING, "A cycle in IRI mappings has been detected");
        messages.put(INVALID_KEYWORD_ID_VALUE, "An @id entry was encountered whose value was not a string");
        messages.put(INVALID_KEYWORD_IMPORT_VALUE, "An invalid value for @import has been found");
        messages.put(INVALID_KEYWORD_INCLUDED_VALUE, "An included block contains an invalid value");
        messages.put(INVALID_KEYWORD_INDEX_VALUE, "An @index entry was encountered whose value was not a string");
        messages.put(INVALID_KEYWORD_NEST_VALUE, "An invalid value for @nest has been found");
        messages.put(INVALID_KEYWORD_PREFIX_VALUE, "An invalid value for @prefix has been found");
        messages.put(INVALID_KEYWORD_PROPAGATE_VALUE, "An invalid value for @propagate has been found");
        messages.put(INVALID_KEYWORD_PROTECTED_VALUE, "An invalid value for @protected has been found");
        messages.put(INVALID_KEYWORD_REVERSE_VALUE, "An invalid value for an @reverse entry has been detected");
        messages.put(INVALID_KEYWORD_VERSION_VALUE, "The @version entry was used in a context with an out of range value");
        messages.put(INVALID_BASE_DIRECTION, "The value of @direction is not \"ltr\", \"rtl\", or null and thus invalid");
        messages.put(INVALID_BASE_IRI, "An invalid base IRI has been detected");
        messages.put(INVALID_CONTAINER_MAPPING, "An @container entry was encountered whose value was not one of the following strings: @list, @set, @language, @index, @id, @graph, or @type");
        messages.put(INVALID_CONTEXT_ENTRY, "An entry in a context is invalid due to processing mode incompatibility");
        messages.put(INVALID_CONTEXT_NULLIFICATION, "An attempt was made to nullify a context containing protected term definitions");
        messages.put(INVALID_DEFAULT_LANGUAGE, "The value of the default language is not a string or null and thus invalid");
        messages.put(INVALID_IRI_MAPPING, "A local context contains a term that has an invalid or missing IRI mapping");
        messages.put(INVALID_JSON_LITERAL, "An invalid JSON literal was detected");
        messages.put(INVALID_KEYWORD_ALIAS, "An invalid keyword alias definition has been encountered");
        messages.put(INVALID_LANGUAGE_MAP_VALUE, "An invalid value in a language map has been detected. It MUST be a string or an array of strings");
        messages.put(INVALID_LANGUAGE_MAPPING, "An @language entry in a term definition was encountered whose value was neither a string nor null and thus invalid");
        messages.put(INVALID_LANGUAGE_TAGGED_STRING, "A language-tagged string with an invalid language value was detected");
        messages.put(INVALID_LANGUAGE_TAGGED_VALUE, "A number, true, or false with an associated language tag was detected");
        messages.put(INVALID_LOCAL_CONTEXT, "In invalid local context was detected");
        messages.put(INVALID_REMOTE_CONTEXT, "No valid context document has been found for a referenced remote context");
        messages.put(INVALID_REVERSE_PROPERTY_MAP, "An invalid reverse property definition has been detected");
        messages.put(INVALID_REVERSE_PROPERTY_VALUE, "An invalid reverse property map has been detected. No keywords apart from @context are allowed in reverse property maps");
        messages.put(INVALID_REVERSE_PROPERTY, "An invalid value for a reverse property has been detected. The value of an inverse property must be a node object");
        messages.put(INVALID_SCOPED_CONTEXT, "The local context defined within a term definition is invalid");
        messages.put(INVALID_SCRIPT_ELEMENT, "A script element in HTML input which is the target of a fragment identifier does not have an appropriate type attribute");
        messages.put(INVALID_SET_OR_LIST_OBJECT, "A set object or list object with disallowed entries has been detected");
        messages.put(INVALID_TERM_DEFINITION, "An invalid term definition has been detected");
        messages.put(INVALID_TYPE_MAPPING, "An @type entry in a term definition was encountered whose value could not be expanded to an IRI");
        messages.put(INVALID_TYPE_VALUE, "An invalid value for an @type entry has been detected");
        messages.put(INVALID_TYPED_VALUE, "A typed value with an invalid type was detected");
        messages.put(INVALID_VALUE_OBJECT_VALUE, "An invalid value for the @value< entry of a value object has been detected");
        messages.put(INVALID_VALUE_OBJECT, "A value object with disallowed entries has been detected");
        messages.put(INVALID_VOCAB_MAPPING, "An invalid vocabulary mapping has been detected");
        messages.put(IRI_CONFUSED_WITH_PREFIX, "When compacting an IRI would result in an IRI which could be confused with a compact IRI");
        messages.put(KEYWORD_REDEFINITION, "A keyword redefinition has been detected");
        messages.put(LOADING_DOCUMENT_FAILED, "The document could not be loaded or parsed as JSON");
        messages.put(LOADING_REMOTE_CONTEXT_FAILED, "There was a problem encountered loading a remote context");
        messages.put(MULTIPLE_CONTEXT_LINK_HEADERS, "Multiple HTTP Link Headers [RFC8288] using the http://www.w3.org/ns/json-ld#context link relation have been detected");
        messages.put(PROCESSING_MODE_CONFLICT, "An attempt was made to change the processing mode which is incompatible with the previous specified version");
        messages.put(PROTECTED_TERM_REDEFINITION, "An attempt was made to redefine a protected term");
        messages.put(INVALID_FRAME, "The frame is invalid");
        messages.put(INVALID_KEYWORD_EMBED_VALUE, "The value for @embed is not one recognized for the object embed flag");
        CODE_TO_MESSAGE = Collections.unmodifiableMap(messages);
    }
}

