/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.serialization;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdErrorCode;
import com.apicatalog.jsonld.api.JsonLdOptions;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.LanguageTag;
import com.apicatalog.jsonld.lang.Version;
import com.apicatalog.jsonld.serialization.GraphMap;
import com.apicatalog.jsonld.serialization.RdfToObject;
import com.apicatalog.jsonld.uri.UriUtils;
import com.apicatalog.rdf.RdfDataset;
import com.apicatalog.rdf.RdfGraph;
import com.apicatalog.rdf.RdfResource;
import com.apicatalog.rdf.RdfTriple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;

public final class RdfToJsonld {
    private RdfDataset dataset;
    private boolean ordered;
    private JsonLdOptions.RdfDirection rdfDirection;
    private boolean useNativeTypes;
    private boolean useRdfType;
    private Version processingMode;
    private GraphMap graphMap;
    private Map<String, Map<String, Boolean>> compoundLiteralSubjects;
    private Map<String, Reference> referenceOnce;

    private RdfToJsonld(RdfDataset dataset) {
        this.dataset = dataset;
        this.ordered = false;
        this.rdfDirection = null;
        this.useNativeTypes = false;
        this.useRdfType = false;
    }

    public static final RdfToJsonld with(RdfDataset dataset) {
        return new RdfToJsonld(dataset);
    }

    public RdfToJsonld ordered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    public RdfToJsonld rdfDirection(JsonLdOptions.RdfDirection rdfDirection) {
        this.rdfDirection = rdfDirection;
        return this;
    }

    public RdfToJsonld useNativeTypes(boolean useNativeTypes) {
        this.useNativeTypes = useNativeTypes;
        return this;
    }

    public RdfToJsonld useRdfType(boolean useRdfType) {
        this.useRdfType = useRdfType;
        return this;
    }

    public RdfToJsonld processingMode(Version processingMode) {
        this.processingMode = processingMode;
        return this;
    }

    public JsonArray build() throws JsonLdError {
        Map<String, JsonValue> node;
        this.graphMap = new GraphMap();
        this.referenceOnce = new LinkedHashMap<String, Reference>();
        this.compoundLiteralSubjects = new LinkedHashMap<String, Map<String, Boolean>>();
        this.step5("@default", this.dataset.getDefaultGraph());
        for (RdfResource rdfResource : this.dataset.getGraphNames()) {
            this.step5(rdfResource.getValue(), this.dataset.getGraph(rdfResource).orElse(null));
        }
        for (String string : this.graphMap.keys()) {
            if (this.compoundLiteralSubjects.containsKey(string)) {
                for (String cl : this.compoundLiteralSubjects.get(string).keySet()) {
                    Reference clEntry = this.referenceOnce.get(cl);
                    if (clEntry == null) continue;
                    Map<String, JsonValue> clNode = this.graphMap.get(string, cl);
                    this.graphMap.remove(string, cl);
                    if (clNode == null) continue;
                    JsonArrayBuilder clArray = Json.createArrayBuilder();
                    for (JsonValue clReference : this.graphMap.get(clEntry.graphName, clEntry.subject, clEntry.property).asJsonArray()) {
                        if (!JsonUtils.isObject(clReference) || !clReference.asJsonObject().containsKey((Object)"@id") || !cl.equals(clReference.asJsonObject().getString("@id"))) continue;
                        JsonObjectBuilder clObject = Json.createObjectBuilder((JsonObject)clReference.asJsonObject());
                        clObject = clObject.remove("@id");
                        JsonValue value = clNode.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#value");
                        if (JsonUtils.isArray(value) && value.asJsonArray().size() == 1) {
                            value = (JsonValue)value.asJsonArray().get(0);
                        }
                        if (JsonUtils.isObject(value) && value.asJsonObject().containsKey((Object)"@value")) {
                            value = (JsonValue)value.asJsonObject().get((Object)"@value");
                        }
                        clObject = clObject.add("@value", value);
                        if (clNode.containsKey("http://www.w3.org/1999/02/22-rdf-syntax-ns#language")) {
                            JsonValue lang = clNode.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#language");
                            if (JsonUtils.isArray(lang)) {
                                lang = (JsonValue)lang.asJsonArray().get(0);
                            }
                            if (JsonUtils.isObject(lang) && lang.asJsonObject().containsKey((Object)"@value")) {
                                lang = (JsonValue)lang.asJsonObject().get((Object)"@value");
                            }
                            if (JsonUtils.isNotString(lang) || !LanguageTag.isWellFormed(((JsonString)lang).getString())) {
                                throw new JsonLdError(JsonLdErrorCode.INVALID_LANGUAGE_TAGGED_STRING);
                            }
                            clObject = clObject.add("@language", lang);
                        }
                        if (clNode.containsKey("http://www.w3.org/1999/02/22-rdf-syntax-ns#direction")) {
                            JsonValue direction = clNode.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#direction");
                            if (JsonUtils.isArray(direction)) {
                                direction = (JsonValue)direction.asJsonArray().get(0);
                            }
                            if (JsonUtils.isObject(direction) && direction.asJsonObject().containsKey((Object)"@value")) {
                                direction = (JsonValue)direction.asJsonObject().get((Object)"@value");
                            }
                            if (JsonUtils.isNotString(direction) || !"ltr".equalsIgnoreCase(((JsonString)direction).getString()) && !"rtl".equalsIgnoreCase(((JsonString)direction).getString())) {
                                throw new JsonLdError(JsonLdErrorCode.INVALID_BASE_DIRECTION);
                            }
                            clObject = clObject.add("@direction", direction);
                        }
                        clArray = clArray.add(clObject);
                    }
                    this.graphMap.set(clEntry.graphName, clEntry.subject, clEntry.property, (JsonValue)clArray.build());
                }
            }
            if (!this.graphMap.contains(string, "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil")) continue;
            for (Reference usage : this.graphMap.getUsages(string, "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil")) {
                node = this.graphMap.get(usage.graphName, usage.subject);
                ArrayList<JsonValue> list = new ArrayList<JsonValue>();
                ArrayList<String> listNodes = new ArrayList<String>();
                String nodeId = ((JsonString)node.get("@id")).getString();
                while ("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest".equals(usage.property) && BlankNode.isWellFormed(nodeId) && this.referenceOnce.get(nodeId) != null && node.containsKey("http://www.w3.org/1999/02/22-rdf-syntax-ns#first") && node.containsKey("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest") && node.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#first").asJsonArray().size() == 1 && node.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest").asJsonArray().size() == 1 && (node.size() == 3 || node.size() == 4 && node.containsKey("@type") && node.get("@type").asJsonArray().size() == 1 && node.get("@type").asJsonArray().contains((Object)Json.createValue((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#List")))) {
                    list.add((JsonValue)node.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#first").asJsonArray().get(0));
                    listNodes.add(nodeId);
                    usage = this.referenceOnce.get(nodeId);
                    node = this.graphMap.get(usage.graphName, usage.subject);
                    if (node != null && node.containsKey("@id") && !UriUtils.isAbsoluteUri(nodeId = ((JsonString)node.get("@id")).getString())) continue;
                }
                JsonObject head = usage.value;
                head.remove((Object)"@id");
                Collections.reverse(list);
                head.put((Object)"@list", (Object)JsonUtils.toJsonArray(list));
                listNodes.forEach(nid -> this.graphMap.remove(string, (String)nid));
            }
        }
        JsonArrayBuilder result = Json.createArrayBuilder();
        ArrayList<String> arrayList = new ArrayList<String>(this.graphMap.keys("@default"));
        if (this.ordered) {
            Collections.sort(arrayList);
        }
        for (String subject : arrayList) {
            node = this.graphMap.get("@default", subject);
            if (this.graphMap.contains(subject)) {
                ArrayList<String> keys = new ArrayList<String>(this.graphMap.keys(subject));
                if (this.ordered) {
                    Collections.sort(keys);
                }
                JsonArrayBuilder array = Json.createArrayBuilder();
                for (String key : keys) {
                    Map<String, JsonValue> entry = this.graphMap.get(subject, key);
                    if (entry.size() <= 1 && entry.containsKey("@id")) continue;
                    array.add((JsonValue)JsonUtils.toJsonObject(entry));
                }
                node.put("@graph", (JsonValue)array.build());
            }
            if (node.size() <= 1 && node.containsKey("@id")) continue;
            result.add((JsonValue)JsonUtils.toJsonObject(node));
        }
        return result.build();
    }

    private void step5(String graphName, RdfGraph graph) throws JsonLdError {
        if (!this.compoundLiteralSubjects.containsKey(graphName)) {
            this.compoundLiteralSubjects.put(graphName, new LinkedHashMap());
        }
        if (!"@default".equals(graphName) && !this.graphMap.contains("@default", graphName)) {
            this.graphMap.set("@default", graphName, "@id", (JsonValue)Json.createValue((String)graphName));
        }
        Map<String, Boolean> compoundMap = this.compoundLiteralSubjects.get(graphName);
        for (RdfTriple triple : graph.toList()) {
            Reference reference;
            String subject = triple.getSubject().toString();
            String predicate = triple.getPredicate().toString();
            if (!this.graphMap.contains(graphName, subject)) {
                this.graphMap.set(graphName, subject, "@id", (JsonValue)Json.createValue((String)subject));
            }
            if (JsonLdOptions.RdfDirection.COMPOUND_LITERAL == this.rdfDirection && "http://www.w3.org/1999/02/22-rdf-syntax-ns#direction".equals(predicate)) {
                compoundMap.put(subject, Boolean.TRUE);
            }
            if ((triple.getObject().isBlankNode() || triple.getObject().isIRI()) && !this.graphMap.contains(graphName, triple.getObject().toString())) {
                this.graphMap.set(graphName, triple.getObject().toString(), "@id", (JsonValue)Json.createValue((String)triple.getObject().toString()));
            }
            if (!this.useRdfType && "http://www.w3.org/1999/02/22-rdf-syntax-ns#type".equals(predicate) && !triple.getObject().isLiteral()) {
                if (this.graphMap.contains(graphName, subject, "@type")) {
                    JsonArray types = this.graphMap.get(graphName, subject, "@type").asJsonArray();
                    this.graphMap.set(graphName, subject, "@type", (JsonValue)Json.createArrayBuilder((JsonArray)types).add(triple.getObject().toString()).build());
                    continue;
                }
                this.graphMap.set(graphName, subject, "@type", (JsonValue)Json.createArrayBuilder().add(triple.getObject().toString()).build());
                continue;
            }
            JsonObject value = RdfToObject.with(triple.getObject(), this.rdfDirection, this.useNativeTypes).processingMode(this.processingMode).build();
            if (!this.graphMap.contains(graphName, subject, predicate)) {
                this.graphMap.set(graphName, subject, predicate, (JsonValue)Json.createArrayBuilder().add((JsonValue)value).build());
            } else {
                JsonArray array = this.graphMap.get(graphName, subject, predicate).asJsonArray();
                if (!array.contains((Object)value)) {
                    this.graphMap.set(graphName, subject, predicate, (JsonValue)Json.createArrayBuilder((JsonArray)array).add((JsonValue)value).build());
                }
            }
            if (triple.getObject().isIRI() && "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil".equals(triple.getObject().toString())) {
                reference = new Reference();
                reference.graphName = graphName;
                reference.subject = subject;
                reference.property = predicate;
                reference.value = value;
                this.graphMap.addUsage(graphName, triple.getObject().toString(), reference);
                continue;
            }
            if (this.referenceOnce.containsKey(triple.getObject().toString())) {
                this.referenceOnce.put(triple.getObject().toString(), null);
                continue;
            }
            if (!triple.getObject().isBlankNode()) continue;
            reference = new Reference();
            reference.graphName = graphName;
            reference.subject = subject;
            reference.property = predicate;
            reference.value = value;
            this.referenceOnce.put(triple.getObject().toString(), reference);
        }
    }

    protected static class Reference {
        private String graphName;
        private String subject;
        private String property;
        private JsonObject value;

        protected Reference() {
        }
    }
}

