/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.context;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdErrorCode;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.TermDefinitionBuilder;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.DirectionType;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.lang.LanguageTag;
import com.apicatalog.jsonld.lang.Version;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.jsonld.uri.UriResolver;
import com.apicatalog.jsonld.uri.UriUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public class ActiveContextBuilder {
    private static final int MAX_REMOTE_CONTEXTS = 256;
    private static final Logger LOGGER = Logger.getLogger(ActiveContextBuilder.class.getName());
    private final ActiveContext activeContext;
    private Collection<String> remoteContexts;
    private boolean overrideProtected;
    private boolean propagate;
    private boolean validateScopedContext;
    private ActiveContext result;

    private ActiveContextBuilder(ActiveContext activeContext) {
        this.activeContext = activeContext;
        this.remoteContexts = new ArrayList<String>();
        this.overrideProtected = false;
        this.propagate = true;
        this.validateScopedContext = true;
        this.result = null;
    }

    public static final ActiveContextBuilder with(ActiveContext activeContext) {
        return new ActiveContextBuilder(activeContext);
    }

    public ActiveContextBuilder remoteContexts(Collection<String> value) {
        this.remoteContexts = value;
        return this;
    }

    public ActiveContextBuilder overrideProtected(boolean value) {
        this.overrideProtected = value;
        return this;
    }

    public ActiveContextBuilder propagate(boolean value) {
        this.propagate = value;
        return this;
    }

    public ActiveContextBuilder validateScopedContext(boolean value) {
        this.validateScopedContext = value;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActiveContext create(JsonValue localContext, URI baseUrl) throws JsonLdError {
        JsonObject localContextObject;
        this.result = new ActiveContext(this.activeContext);
        this.result.setInverseContext(null);
        if (JsonUtils.isObject(localContext) && (localContextObject = localContext.asJsonObject()).containsKey((Object)"@propagate")) {
            this.propagate = localContextObject.getBoolean("@propagate", this.propagate);
        }
        if (!this.propagate && this.result.getPreviousContext() == null) {
            this.result.setPreviousContext(this.activeContext);
        }
        for (JsonValue itemContext : JsonUtils.toJsonArray(localContext)) {
            String valueString;
            JsonValue value;
            if (JsonUtils.isNull(itemContext)) {
                if (!this.overrideProtected && this.result.containsProtectedTerm()) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_CONTEXT_NULLIFICATION);
                }
                this.result = this.propagate ? new ActiveContext(this.activeContext.getBaseUrl(), this.activeContext.getBaseUrl(), this.activeContext.getOptions()) : new ActiveContext(this.activeContext.getBaseUrl(), this.activeContext.getBaseUrl(), this.result.getPreviousContext(), this.activeContext.getOptions());
                continue;
            }
            if (JsonUtils.isString(itemContext)) {
                this.fetch(((JsonString)itemContext).getString(), baseUrl);
                continue;
            }
            if (JsonUtils.isNotObject(itemContext)) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_LOCAL_CONTEXT);
            }
            JsonObject contextDefinition = itemContext.asJsonObject();
            if (contextDefinition.containsKey((Object)"@version")) {
                JsonValue version = (JsonValue)contextDefinition.get((Object)"@version");
                String versionString = null;
                if (JsonUtils.isString(version)) {
                    versionString = ((JsonString)version).getString();
                } else if (JsonUtils.isNumber(version)) {
                    versionString = version.toString();
                }
                if (!"1.1".equals(versionString)) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_VERSION_VALUE);
                }
                if (this.activeContext.inMode(Version.V1_0)) {
                    throw new JsonLdError(JsonLdErrorCode.PROCESSING_MODE_CONFLICT);
                }
            }
            if (contextDefinition.containsKey((Object)"@import")) {
                if (this.activeContext.inMode(Version.V1_0)) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_CONTEXT_ENTRY);
                }
                JsonValue contextImport = (JsonValue)contextDefinition.get((Object)"@import");
                if (JsonUtils.isNotString(contextImport)) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_IMPORT_VALUE);
                }
                String contextImportUri = UriResolver.resolve(baseUrl, ((JsonString)contextImport).getString());
                if (this.activeContext.getOptions().getDocumentLoader() == null) {
                    throw new JsonLdError(JsonLdErrorCode.LOADING_REMOTE_CONTEXT_FAILED);
                }
                DocumentLoaderOptions loaderOptions = new DocumentLoaderOptions();
                loaderOptions.setProfile("http://www.w3.org/ns/json-ld#context");
                loaderOptions.setRequestProfile(Arrays.asList(loaderOptions.getProfile()));
                JsonStructure importedStructure = null;
                try {
                    Document importedDocument = this.activeContext.getOptions().getDocumentLoader().loadDocument(URI.create(contextImportUri), loaderOptions);
                    if (importedDocument == null) {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT, "Imported context[" + contextImportUri + "] is null.");
                    }
                    importedStructure = importedDocument.getJsonContent().orElseThrow(() -> new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_IMPORT_VALUE));
                }
                catch (JsonLdError e) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_IMPORT_VALUE, (Throwable)e);
                }
                if (JsonUtils.isNotObject((JsonValue)importedStructure)) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT);
                }
                JsonObject importedContext = importedStructure.asJsonObject();
                if (!importedContext.containsKey((Object)"@context") || JsonUtils.isNotObject((JsonValue)importedContext.get((Object)"@context"))) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT);
                }
                if ((importedContext = importedContext.getJsonObject("@context")).containsKey((Object)"@import")) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_CONTEXT_ENTRY);
                }
                contextDefinition = JsonUtils.merge(importedContext, contextDefinition);
            }
            if (contextDefinition.containsKey((Object)"@base")) {
                value = (JsonValue)contextDefinition.get((Object)"@base");
                if (JsonUtils.isNull(value)) {
                    this.result.setBaseUri(null);
                } else {
                    if (JsonUtils.isNotString(value)) {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_BASE_IRI);
                    }
                    valueString = ((JsonString)value).getString();
                    if (UriUtils.isURI(valueString)) {
                        if (UriUtils.isAbsoluteUri(valueString)) {
                            this.result.setBaseUri(URI.create(valueString));
                        } else {
                            if (this.result.getBaseUri() == null) throw new JsonLdError(JsonLdErrorCode.INVALID_BASE_IRI);
                            String resolved = UriResolver.resolve(this.result.getBaseUri(), valueString);
                            this.result.setBaseUri(UriUtils.create(resolved));
                        }
                    } else if (!valueString.isBlank()) {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_BASE_IRI);
                    }
                }
            }
            if (contextDefinition.containsKey((Object)"@vocab")) {
                value = (JsonValue)contextDefinition.get((Object)"@vocab");
                if (JsonUtils.isNull(value)) {
                    this.result.setVocabularyMapping(null);
                } else {
                    if (JsonUtils.isNotString(value)) {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_VOCAB_MAPPING);
                    }
                    valueString = ((JsonString)value).getString();
                    if (!valueString.isBlank() && !BlankNode.hasPrefix(valueString) && !UriUtils.isURI(valueString)) throw new JsonLdError(JsonLdErrorCode.INVALID_VOCAB_MAPPING);
                    String vocabularyMapping = this.result.uriExpansion().vocab(true).documentRelative(true).expand(valueString);
                    if (!BlankNode.hasPrefix(valueString) && !UriUtils.isURI(vocabularyMapping)) throw new JsonLdError(JsonLdErrorCode.INVALID_VOCAB_MAPPING);
                    this.result.setVocabularyMapping(vocabularyMapping);
                }
            }
            if (contextDefinition.containsKey((Object)"@language")) {
                value = (JsonValue)contextDefinition.get((Object)"@language");
                if (JsonUtils.isNull(value)) {
                    this.result.setDefaultLanguage(null);
                } else {
                    if (JsonUtils.isNotString(value)) {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_DEFAULT_LANGUAGE);
                    }
                    this.result.setDefaultLanguage(((JsonString)value).getString());
                    if (!LanguageTag.isWellFormed(this.result.getDefaultLanguage())) {
                        LOGGER.log(Level.WARNING, "Language tag [{0}] is not well formed.", this.result.getDefaultLanguage());
                    }
                }
            }
            if (contextDefinition.containsKey((Object)"@direction")) {
                if (this.activeContext.inMode(Version.V1_0)) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_CONTEXT_ENTRY);
                }
                value = (JsonValue)contextDefinition.get((Object)"@direction");
                if (JsonUtils.isNull(value)) {
                    this.result.setDefaultBaseDirection(DirectionType.NULL);
                } else {
                    if (!JsonUtils.isString(value)) {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_BASE_DIRECTION);
                    }
                    String direction = ((JsonString)value).getString();
                    if ("ltr".equals(direction)) {
                        this.result.setDefaultBaseDirection(DirectionType.LTR);
                    } else {
                        if (!"rtl".equals(direction)) throw new JsonLdError(JsonLdErrorCode.INVALID_BASE_DIRECTION);
                        this.result.setDefaultBaseDirection(DirectionType.RTL);
                    }
                }
            }
            if (contextDefinition.containsKey((Object)"@propagate")) {
                if (this.activeContext.inMode(Version.V1_0)) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_CONTEXT_ENTRY);
                }
                if (JsonUtils.isNotBoolean((JsonValue)contextDefinition.get((Object)"@propagate"))) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_PROPAGATE_VALUE);
                }
            }
            TermDefinitionBuilder termBuilder = this.result.newTerm(contextDefinition, new HashMap<String, Boolean>()).baseUrl(baseUrl).overrideProtectedFlag(this.overrideProtected);
            for (String key : contextDefinition.keySet()) {
                if (!Keywords.noneMatch(key, "@base", "@direction", "@import", "@language", "@propagate", "@protected", "@version", "@vocab")) continue;
                termBuilder.protectedFlag(contextDefinition.containsKey((Object)"@protected") && JsonUtils.isTrue((JsonValue)contextDefinition.get((Object)"@protected"))).remoteContexts(new ArrayList<String>(this.remoteContexts)).create(key);
            }
        }
        return this.result;
    }

    private void fetch(String context, URI baseUrl) throws JsonLdError {
        String contextUri = context;
        if (baseUrl != null) {
            contextUri = UriResolver.resolve(baseUrl, contextUri);
        } else if (UriUtils.isNotURI(contextUri)) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_REMOTE_CONTEXT_FAILED, "Context URI is not URI [" + contextUri + "].");
        }
        if (UriUtils.isNotAbsoluteUri(contextUri)) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_REMOTE_CONTEXT_FAILED, "Context URI is not absolute [" + contextUri + "].");
        }
        if (!this.validateScopedContext && this.remoteContexts.contains(contextUri)) {
            return;
        }
        if (this.remoteContexts.size() > 256) {
            throw new JsonLdError(JsonLdErrorCode.CONTEXT_OVERFLOW, "Too many contexts [>256].");
        }
        this.remoteContexts.add(contextUri);
        if (this.activeContext.getOptions().getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_REMOTE_CONTEXT_FAILED, "Document loader is null. Cannot fetch [" + contextUri + "].");
        }
        DocumentLoaderOptions loaderOptions = new DocumentLoaderOptions();
        loaderOptions.setProfile("http://www.w3.org/ns/json-ld#context");
        loaderOptions.setRequestProfile(Arrays.asList(loaderOptions.getProfile()));
        JsonStructure importedStructure = null;
        URI documentUrl = null;
        try {
            Document remoteImport = this.activeContext.getOptions().getDocumentLoader().loadDocument(URI.create(contextUri), loaderOptions);
            if (remoteImport == null) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT, "Imported context is null.");
            }
            documentUrl = remoteImport.getDocumentUrl();
            importedStructure = remoteImport.getJsonContent().orElseThrow(() -> new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT, "Imported context is null."));
        }
        catch (JsonLdError e) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_REMOTE_CONTEXT_FAILED, (Throwable)e);
        }
        if (JsonUtils.isNotObject((JsonValue)importedStructure)) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT, "Imported context is not valid Json Object [" + importedStructure.getValueType() + "].");
        }
        JsonObject importedContext = importedStructure.asJsonObject();
        if (!importedContext.asJsonObject().containsKey((Object)"@context")) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT, "Imported context does not contain @context key and is not valid JSON-LD context.");
        }
        if (JsonUtils.isObject((JsonValue)(importedContext = (JsonValue)importedContext.asJsonObject().get((Object)"@context"))) && importedContext.asJsonObject().containsKey((Object)"@base")) {
            importedContext = Json.createObjectBuilder((JsonObject)importedContext.asJsonObject()).remove("@base").build();
        }
        try {
            this.result = this.result.newContext().remoteContexts(new ArrayList<String>(this.remoteContexts)).validateScopedContext(this.validateScopedContext).create((JsonValue)importedContext, documentUrl);
        }
        catch (JsonLdError e) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_REMOTE_CONTEXT_FAILED, (Throwable)e);
        }
    }
}

