/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.serialization;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdErrorCode;
import com.apicatalog.jsonld.api.JsonLdOptions;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.Version;
import com.apicatalog.rdf.RdfLiteral;
import com.apicatalog.rdf.RdfValue;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashMap;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;

final class RdfToObject {
    private RdfValue value;
    private JsonLdOptions.RdfDirection rdfDirection;
    private boolean useNativeTypes;
    private Version processingMode;

    private RdfToObject(RdfValue object, JsonLdOptions.RdfDirection rdfDirection, boolean useNativeTypes) {
        this.value = object;
        this.rdfDirection = rdfDirection;
        this.useNativeTypes = useNativeTypes;
        this.processingMode = null;
    }

    public static final RdfToObject with(RdfValue object, JsonLdOptions.RdfDirection rdfDirection, boolean useNativeTypes) {
        return new RdfToObject(object, rdfDirection, useNativeTypes);
    }

    public RdfToObject processingMode(Version processingMode) {
        this.processingMode = processingMode;
        return this;
    }

    public JsonObject build() throws JsonLdError {
        String type;
        JsonString convertedValue;
        LinkedHashMap<String, JsonValue> result;
        block37: {
            if (this.value.isIRI() || this.value.isBlankNode()) {
                return Json.createObjectBuilder().add("@id", this.value.toString()).build();
            }
            result = new LinkedHashMap<String, JsonValue>();
            RdfLiteral literal = this.value.asLiteral();
            convertedValue = Json.createValue((String)literal.getValue());
            type = null;
            if (this.useNativeTypes) {
                if (literal.getDatatype() != null) {
                    if ("http://www.w3.org/2001/XMLSchema#string".equals(literal.getDatatype())) {
                        convertedValue = Json.createValue((String)literal.toString());
                    } else if ("http://www.w3.org/2001/XMLSchema#boolean".equals(literal.getDatatype())) {
                        if ("true".equalsIgnoreCase(literal.getValue())) {
                            convertedValue = JsonValue.TRUE;
                        } else if ("false".equalsIgnoreCase(literal.getValue())) {
                            convertedValue = JsonValue.FALSE;
                        } else {
                            type = "http://www.w3.org/2001/XMLSchema#boolean";
                        }
                    } else if ("http://www.w3.org/2001/XMLSchema#integer".equals(literal.getDatatype())) {
                        convertedValue = Json.createValue((long)Long.parseLong(literal.getValue()));
                    } else if ("http://www.w3.org/2001/XMLSchema#double".equals(literal.getDatatype())) {
                        convertedValue = Json.createValue((double)Double.parseDouble(literal.getValue()));
                    } else if (literal.getDatatype() != null) {
                        type = literal.getDatatype();
                    }
                }
            } else {
                if (this.processingMode != Version.V1_0 && literal.getDatatype() != null && "http://www.w3.org/1999/02/22-rdf-syntax-ns#JSON".equals(literal.getDatatype())) {
                    try (JsonParser parser = Json.createParser((Reader)new StringReader(literal.getValue()));){
                        parser.next();
                        convertedValue = parser.getValue();
                        type = "@json";
                        break block37;
                    }
                    catch (Exception e) {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_JSON_LITERAL, (Throwable)e);
                    }
                }
                if (JsonLdOptions.RdfDirection.I18N_DATATYPE == this.rdfDirection && literal.getDatatype() != null && literal.getDatatype().startsWith("https://www.w3.org/ns/i18n#")) {
                    convertedValue = Json.createValue((String)literal.getValue());
                    String langId = literal.getDatatype().substring("https://www.w3.org/ns/i18n#".length());
                    int directionIndex = langId.indexOf(95);
                    if (directionIndex > 1) {
                        result.put("@language", (JsonValue)Json.createValue((String)langId.substring(0, directionIndex)));
                        result.put("@direction", (JsonValue)Json.createValue((String)langId.substring(directionIndex + 1)));
                    } else if (directionIndex == 0) {
                        result.put("@direction", (JsonValue)Json.createValue((String)langId.substring(1)));
                    } else if (directionIndex == -1) {
                        result.put("@language", (JsonValue)Json.createValue((String)langId));
                    }
                } else if (literal.getLanguage().isPresent()) {
                    result.put("@language", (JsonValue)Json.createValue((String)literal.getLanguage().get()));
                } else if (literal.getDatatype() != null && !"http://www.w3.org/2001/XMLSchema#string".equals(literal.getDatatype())) {
                    type = literal.getDatatype();
                }
            }
        }
        result.put("@value", (JsonValue)convertedValue);
        if (type != null) {
            result.put("@type", (JsonValue)Json.createValue(type));
        }
        return JsonUtils.toJsonObject(result);
    }
}

