/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.http.link;

import com.apicatalog.jsonld.http.HttpAlphabet;
import com.apicatalog.jsonld.http.link.Link;
import com.apicatalog.jsonld.http.link.LinkAttribute;
import com.apicatalog.jsonld.http.link.LinkAttributes;
import com.apicatalog.jsonld.http.media.MediaType;
import com.apicatalog.jsonld.uri.UriResolver;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class LinkHeaderParser {
    private static final String REL = "rel";
    private static final String ANCHOR = "anchor";
    private static final String TYPE = "type";
    private URI baseUri;
    private final StringBuilder valueBuilder;
    private List<Link> links;
    private State state;
    private URI targetUri;
    private String attributeName;
    private String attributeValue;
    private Map<String, List<LinkAttribute>> attributes;

    public LinkHeaderParser(URI baseUri) {
        this.baseUri = baseUri;
        this.valueBuilder = new StringBuilder();
    }

    public List<Link> parse(String httpLink) {
        char[] linkHeader;
        this.resetState(this.baseUri);
        block12: for (char ch : linkHeader = httpLink.toCharArray()) {
            switch (this.state) {
                case INIT: {
                    this.initParser(ch);
                    continue block12;
                }
                case URI_REF: {
                    this.parseTargetUri(ch);
                    continue block12;
                }
                case PARAMS: {
                    this.parseParameters(ch);
                    continue block12;
                }
                case PARAM_NAME_BEGIN: {
                    this.parseParamNameBegin(ch);
                    continue block12;
                }
                case PARAM_NAME: {
                    this.parseParamName(ch);
                    continue block12;
                }
                case PARAM_NAME_END: {
                    this.parseParamNameEnd(ch);
                    continue block12;
                }
                case PARAM_VALUE: {
                    this.parseParamValue(ch);
                    continue block12;
                }
                case LITERAL_VALUE: {
                    this.parseLiteral(ch);
                    continue block12;
                }
                case STRING_VALUE: {
                    this.parseString(ch);
                    continue block12;
                }
                case ESCAPE: {
                    this.escape(ch);
                    continue block12;
                }
                default: {
                    this.addParameter();
                    this.addLink();
                    return this.links;
                }
            }
        }
        return this.sweep();
    }

    private final List<Link> sweep() {
        switch (this.state) {
            case PARAM_NAME_BEGIN: 
            case PARAM_NAME: 
            case PARAM_NAME_END: {
                if (this.valueBuilder.length() <= 0) break;
                this.attributeName = this.valueBuilder.toString().stripTrailing();
                break;
            }
            case LITERAL_VALUE: {
                if (this.valueBuilder.length() <= 0) break;
                this.attributeValue = this.valueBuilder.toString().stripTrailing();
                break;
            }
            case UNEXPECTED: {
                return this.links;
            }
        }
        this.addParameter();
        this.addLink();
        return this.links;
    }

    private final void addLink() {
        if (this.targetUri != null) {
            Set<String> rel = Collections.emptySet();
            URI context = null;
            MediaType type = null;
            if (this.attributes.containsKey(REL) && this.attributes.get(REL) != null) {
                rel = new HashSet<String>(Arrays.asList(this.attributes.get(REL).get(0).value().strip().split("[\\s\\t]+")));
                this.attributes.remove(REL);
            }
            if (this.attributes.containsKey(ANCHOR) && this.attributes.get(ANCHOR) != null) {
                context = URI.create(UriResolver.resolve(this.baseUri, this.attributes.get(ANCHOR).get(0).value().strip()));
                this.attributes.remove(ANCHOR);
            }
            if (this.attributes.containsKey(TYPE) && this.attributes.get(TYPE) != null && (type = MediaType.of(this.attributes.get(TYPE).get(0).value())) != null) {
                this.attributes.remove(TYPE);
            }
            this.links.add(new Link(context, this.targetUri, rel, type, new LinkAttributes(this.attributes)));
            this.targetUri = null;
            this.attributes = new LinkedHashMap<String, List<LinkAttribute>>();
        }
    }

    private final void addParameter() {
        if (this.attributeName != null) {
            if (this.attributeValue != null) {
                this.attributes.computeIfAbsent(this.attributeName, l -> new LinkedList()).add(new LinkAttribute(this.attributeName, this.attributeValue));
                this.attributeValue = null;
            } else {
                this.attributes.computeIfAbsent(this.attributeName, l -> new LinkedList()).add(new LinkAttribute(this.attributeName));
            }
            this.attributeName = null;
        }
    }

    private final void resetState(URI baseUri) {
        this.baseUri = baseUri;
        this.links = new LinkedList<Link>();
        this.attributes = new LinkedHashMap<String, List<LinkAttribute>>();
        this.state = State.INIT;
        this.targetUri = null;
        this.attributeName = null;
        this.attributeValue = null;
    }

    private final void initParser(char ch) {
        if (HttpAlphabet.WHITESPACE.test(ch)) {
            return;
        }
        if (ch == '<') {
            this.valueBuilder.setLength(0);
            this.state = State.URI_REF;
            return;
        }
        this.state = State.UNEXPECTED;
    }

    private final void parseTargetUri(char ch) {
        if (ch != '>') {
            if (this.valueBuilder.length() > 0 || HttpAlphabet.WHITESPACE.negate().test(ch)) {
                this.valueBuilder.append(ch);
            }
            return;
        }
        this.targetUri = URI.create(UriResolver.resolve(this.baseUri, this.valueBuilder.toString().stripTrailing()));
        this.state = State.PARAMS;
    }

    private final void parseParameters(char ch) {
        if (HttpAlphabet.WHITESPACE.test(ch)) {
            return;
        }
        if (ch == ',') {
            this.addLink();
            this.state = State.INIT;
            return;
        }
        if (ch == ';') {
            this.valueBuilder.setLength(0);
            this.state = State.PARAM_NAME_BEGIN;
            return;
        }
        this.addLink();
        this.state = State.UNEXPECTED;
    }

    private final void parseParamNameBegin(char ch) {
        if (HttpAlphabet.WHITESPACE.test(ch)) {
            return;
        }
        if (HttpAlphabet.T_CHAR.test(ch)) {
            this.valueBuilder.append(ch);
            this.state = State.PARAM_NAME;
            return;
        }
        this.addLink();
        this.state = State.UNEXPECTED;
    }

    private final void parseParamName(char ch) {
        if (ch == '=') {
            this.attributeName = this.valueBuilder.toString();
            this.valueBuilder.setLength(0);
            this.state = State.PARAM_VALUE;
            return;
        }
        if (ch == ';') {
            this.attributeName = this.valueBuilder.toString();
            this.valueBuilder.setLength(0);
            this.addParameter();
            return;
        }
        if (ch == ',') {
            this.attributeName = this.valueBuilder.toString();
            this.addParameter();
            this.addLink();
            this.state = State.INIT;
            return;
        }
        if (HttpAlphabet.T_CHAR.test(ch)) {
            this.valueBuilder.append(ch);
            return;
        }
        if (HttpAlphabet.WHITESPACE.test(ch)) {
            this.attributeName = this.valueBuilder.toString();
            this.valueBuilder.setLength(0);
            this.state = State.PARAM_NAME_END;
            return;
        }
        this.addLink();
        this.state = State.UNEXPECTED;
    }

    private final void parseParamNameEnd(char ch) {
        if (HttpAlphabet.WHITESPACE.test(ch)) {
            return;
        }
        if (ch == '=') {
            this.state = State.PARAM_VALUE;
            return;
        }
        if (ch == ';') {
            this.addParameter();
            this.state = State.PARAM_NAME_BEGIN;
            return;
        }
        if (ch == ',') {
            this.addParameter();
            this.addLink();
            this.state = State.INIT;
            return;
        }
        this.addLink();
        this.state = State.UNEXPECTED;
    }

    private final void parseParamValue(char ch) {
        if (HttpAlphabet.WHITESPACE.test(ch)) {
            return;
        }
        if (ch == '\"') {
            this.state = State.STRING_VALUE;
            return;
        }
        if (HttpAlphabet.T_CHAR.test(ch)) {
            this.valueBuilder.append(ch);
            this.state = State.LITERAL_VALUE;
            return;
        }
        this.addLink();
        this.state = State.UNEXPECTED;
    }

    private final void parseString(char ch) {
        if (ch == '\"') {
            this.attributeValue = this.valueBuilder.toString();
            this.addParameter();
            this.state = State.PARAMS;
            return;
        }
        if (ch == '\\') {
            this.state = State.ESCAPE;
            return;
        }
        if (HttpAlphabet.QD_TEXT.test(ch)) {
            this.valueBuilder.append(ch);
            return;
        }
        this.addLink();
        this.state = State.UNEXPECTED;
    }

    private final void parseLiteral(char ch) {
        if (ch == ';') {
            this.attributeValue = this.valueBuilder.toString();
            this.valueBuilder.setLength(0);
            this.addParameter();
            this.state = State.PARAM_NAME;
            return;
        }
        if (ch == ',') {
            this.attributeValue = this.valueBuilder.toString();
            this.addParameter();
            this.addLink();
            this.state = State.INIT;
            return;
        }
        if (HttpAlphabet.T_CHAR.test(ch)) {
            this.valueBuilder.append(ch);
            return;
        }
        if (HttpAlphabet.WHITESPACE.test(ch)) {
            this.attributeValue = this.valueBuilder.toString();
            this.addParameter();
            this.state = State.PARAMS;
            return;
        }
        this.addLink();
        this.state = State.UNEXPECTED;
    }

    private final void escape(char ch) {
        if (ch == 't') {
            this.valueBuilder.append('\t');
        } else {
            this.valueBuilder.append(ch);
        }
        this.state = State.STRING_VALUE;
    }

    private static enum State {
        INIT,
        URI_REF,
        PARAMS,
        PARAM_NAME_BEGIN,
        PARAM_NAME,
        PARAM_NAME_END,
        PARAM_VALUE,
        STRING_VALUE,
        LITERAL_VALUE,
        ESCAPE,
        UNEXPECTED;

    }
}

