/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.framing;

import com.apicatalog.jsonld.api.JsonLdEmbed;
import com.apicatalog.jsonld.flattening.NodeMap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public final class FramingState {
    private JsonLdEmbed embed;
    private boolean requireAll;
    private boolean embedded;
    private boolean explicitInclusion;
    private boolean omitDefault;
    private String graphName;
    private NodeMap graphMap;
    private Map<String, Map<String, Boolean>> done;
    private Deque<String> parents;

    public FramingState() {
        this.done = new HashMap<String, Map<String, Boolean>>();
        this.parents = new ArrayDeque<String>();
    }

    public FramingState(FramingState state) {
        this.embed = state.embed;
        this.requireAll = state.requireAll;
        this.embedded = state.embedded;
        this.explicitInclusion = state.explicitInclusion;
        this.omitDefault = state.omitDefault;
        this.graphMap = state.graphMap;
        this.graphName = state.graphName;
        this.done = state.done;
        this.parents = state.parents;
    }

    public JsonLdEmbed getEmbed() {
        return this.embed;
    }

    public void setEmbed(JsonLdEmbed embed) {
        this.embed = embed;
    }

    public boolean isRequireAll() {
        return this.requireAll;
    }

    public void setRequireAll(boolean requireAll) {
        this.requireAll = requireAll;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public boolean isExplicitInclusion() {
        return this.explicitInclusion;
    }

    public void setExplicitInclusion(boolean explicitInclusion) {
        this.explicitInclusion = explicitInclusion;
    }

    public boolean isOmitDefault() {
        return this.omitDefault;
    }

    public void setOmitDefault(boolean omitDefault) {
        this.omitDefault = omitDefault;
    }

    public String getGraphName() {
        return this.graphName;
    }

    public void setGraphName(String graphName) {
        this.graphName = graphName;
    }

    public NodeMap getGraphMap() {
        return this.graphMap;
    }

    public void setGraphMap(NodeMap graphMap) {
        this.graphMap = graphMap;
    }

    public boolean isDone(String subject) {
        return this.done.containsKey(this.graphName) && this.done.get(this.graphName).containsKey(subject);
    }

    public void markDone(String subject) {
        this.done.computeIfAbsent(this.graphName, x -> new HashMap()).put(subject, Boolean.TRUE);
    }

    public boolean isParent(String subject) {
        return this.parents.contains(this.graphName + "@@@" + subject);
    }

    public void addParent(String subject) {
        this.parents.push(this.graphName + "@@@" + subject);
    }

    public void removeLastParent() {
        this.parents.pop();
    }

    public void clearDone() {
        this.done.clear();
    }
}

