/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.deseralization;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdOptions;
import com.apicatalog.jsonld.deseralization.ListToRdf;
import com.apicatalog.jsonld.flattening.NodeMap;
import com.apicatalog.jsonld.json.JsonCanonicalizer;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.LanguageTag;
import com.apicatalog.jsonld.lang.ListObject;
import com.apicatalog.jsonld.lang.NodeObject;
import com.apicatalog.jsonld.lang.ValueObject;
import com.apicatalog.jsonld.uri.UriUtils;
import com.apicatalog.rdf.Rdf;
import com.apicatalog.rdf.RdfLiteral;
import com.apicatalog.rdf.RdfResource;
import com.apicatalog.rdf.RdfTriple;
import com.apicatalog.rdf.RdfValue;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

final class ObjectToRdf {
    private JsonObject item;
    private List<RdfTriple> triples;
    private NodeMap nodeMap;
    private JsonLdOptions.RdfDirection rdfDirection;

    private ObjectToRdf(JsonObject item, List<RdfTriple> triples, NodeMap nodeMap) {
        this.item = item;
        this.triples = triples;
        this.nodeMap = nodeMap;
        this.rdfDirection = null;
    }

    public static final ObjectToRdf with(JsonObject item, List<RdfTriple> triples, NodeMap nodeMap) {
        return new ObjectToRdf(item, triples, nodeMap);
    }

    public ObjectToRdf rdfDirection(JsonLdOptions.RdfDirection rdfDirection) {
        this.rdfDirection = rdfDirection;
        return this;
    }

    public RdfValue build() throws JsonLdError {
        if (NodeObject.isNodeObject((JsonValue)this.item)) {
            JsonValue id = (JsonValue)this.item.get((Object)"@id");
            if (JsonUtils.isNotString(id) || JsonUtils.isNull(id)) {
                return null;
            }
            String idString = ((JsonString)id).getString();
            if (BlankNode.isWellFormed(idString)) {
                return Rdf.createBlankNode(idString);
            }
            if (UriUtils.isAbsoluteUri(idString)) {
                return Rdf.createIRI(idString);
            }
            return null;
        }
        if (ListObject.isListObject((JsonValue)this.item)) {
            return ListToRdf.with(((JsonValue)this.item.get((Object)"@list")).asJsonArray(), this.triples, this.nodeMap).rdfDirection(this.rdfDirection).build();
        }
        if (!ValueObject.isValueObject((JsonValue)this.item)) {
            return null;
        }
        JsonValue value = (JsonValue)this.item.get((Object)"@value");
        String datatype = this.item.containsKey((Object)"@type") && JsonUtils.isString((JsonValue)this.item.get((Object)"@type")) ? this.item.getString("@type") : null;
        String valueString = null;
        if (datatype != null && !"@json".equals(datatype) && !UriUtils.isAbsoluteUri(datatype)) {
            return null;
        }
        if (this.item.containsKey((Object)"@language") && (JsonUtils.isNotString((JsonValue)this.item.get((Object)"@language")) || !LanguageTag.isWellFormed(this.item.getString("@language")))) {
            return null;
        }
        if ("@json".equals(datatype)) {
            valueString = JsonCanonicalizer.canonicalize(value);
            datatype = "http://www.w3.org/1999/02/22-rdf-syntax-ns#JSON";
        } else if (JsonUtils.isTrue(value)) {
            valueString = "true";
            if (datatype == null) {
                datatype = "http://www.w3.org/2001/XMLSchema#boolean";
            }
        } else if (JsonUtils.isFalse(value)) {
            valueString = "false";
            if (datatype == null) {
                datatype = "http://www.w3.org/2001/XMLSchema#boolean";
            }
        } else if (JsonUtils.isNumber(value)) {
            JsonNumber number = (JsonNumber)value;
            if (!number.isIntegral() && number.doubleValue() % -1.0 != 0.0 || "http://www.w3.org/2001/XMLSchema#double".equals(datatype) || number.bigDecimalValue().compareTo(BigDecimal.ONE.movePointRight(21)) >= 0) {
                valueString = ObjectToRdf.toXsdDouble(number.bigDecimalValue());
                if (datatype == null) {
                    datatype = "http://www.w3.org/2001/XMLSchema#double";
                }
            } else {
                valueString = number.bigIntegerValue().toString();
                if (datatype == null) {
                    datatype = "http://www.w3.org/2001/XMLSchema#integer";
                }
            }
        } else if (datatype == null) {
            String string = datatype = this.item.containsKey((Object)"@language") ? "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString" : "http://www.w3.org/2001/XMLSchema#string";
        }
        if (valueString == null) {
            if (JsonUtils.isNotString(value)) {
                return null;
            }
            valueString = ((JsonString)value).getString();
        }
        RdfLiteral rdfLiteral = null;
        if (this.item.containsKey((Object)"@direction") && this.rdfDirection != null) {
            String language;
            String string = language = this.item.containsKey((Object)"@language") ? this.item.getString("@language").toLowerCase() : "";
            if (JsonLdOptions.RdfDirection.I18N_DATATYPE == this.rdfDirection) {
                datatype = "https://www.w3.org/ns/i18n#".concat(language).concat("_").concat(this.item.getString("@direction"));
                rdfLiteral = Rdf.createTypedString(valueString, datatype);
            } else if (JsonLdOptions.RdfDirection.COMPOUND_LITERAL == this.rdfDirection) {
                String blankNodeId = this.nodeMap.createIdentifier();
                RdfResource subject = Rdf.createBlankNode(blankNodeId);
                this.triples.add(Rdf.createTriple(subject, Rdf.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#value"), Rdf.createString(valueString)));
                if (this.item.containsKey((Object)"@language") && JsonUtils.isString((JsonValue)this.item.get((Object)"@language"))) {
                    this.triples.add(Rdf.createTriple(subject, Rdf.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#language"), Rdf.createString(this.item.getString("@language").toLowerCase())));
                }
                this.triples.add(Rdf.createTriple(subject, Rdf.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#direction"), Rdf.createString(this.item.getString("@direction"))));
                return Rdf.createBlankNode(blankNodeId);
            }
        } else {
            rdfLiteral = this.item.containsKey((Object)"@language") && JsonUtils.isString((JsonValue)this.item.get((Object)"@language")) ? Rdf.createLangString(valueString, this.item.getString("@language")) : Rdf.createTypedString(valueString, datatype);
        }
        return rdfLiteral;
    }

    private static final String toXsdDouble(BigDecimal bigDecimal) {
        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            return "0.0E0";
        }
        return new DecimalFormat("0.0##############E0").format(bigDecimal);
    }
}

