/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.rdf.io.nquad;

import com.apicatalog.rdf.RdfDataset;
import com.apicatalog.rdf.RdfGraphName;
import com.apicatalog.rdf.RdfLiteral;
import com.apicatalog.rdf.RdfNQuad;
import com.apicatalog.rdf.RdfObject;
import com.apicatalog.rdf.RdfPredicate;
import com.apicatalog.rdf.RdfSubject;
import com.apicatalog.rdf.io.RdfWriter;
import java.io.IOException;
import java.io.Writer;

public class NQuadsWriter
implements RdfWriter {
    private final Writer writer;

    public NQuadsWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void write(RdfDataset dataset) throws IOException {
        for (RdfNQuad nquad : dataset.toList()) {
            this.write(nquad);
        }
        this.writer.flush();
    }

    public void write(RdfNQuad nquad) throws IOException {
        this.write(nquad.getSubject());
        this.writer.write(32);
        this.write(nquad.getPredicate());
        this.writer.write(32);
        this.write(nquad.getObject());
        this.writer.write(32);
        if (nquad.getGraphName() != null) {
            this.write(nquad.getGraphName());
            this.writer.write(32);
        }
        this.writer.write(".\n");
    }

    public void write(RdfObject object) throws IOException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (object.isIRI()) {
            this.writeIri(object.toString());
            return;
        }
        if (object.isLiteral()) {
            this.write(object.getLiteral());
            return;
        }
        if (object.isBlankNode()) {
            this.writer.write(object.toString());
            return;
        }
        throw new IllegalStateException();
    }

    private void write(RdfLiteral literal) throws IOException {
        if (literal == null) {
            throw new IllegalArgumentException();
        }
        this.writer.write(34);
        this.writer.write(NQuadsWriter.escape(literal.getValue()));
        this.writer.write(34);
        if (literal.getLanguage() != null) {
            this.writer.write("@");
            this.writer.write(literal.getLanguage());
        } else if (literal.getDatatype() != null) {
            if ("http://www.w3.org/2001/XMLSchema#string".equals(literal.getDatatype())) {
                return;
            }
            this.writer.write("^^");
            this.writeIri(literal.getDatatype());
        }
    }

    public static final String escape(String value) {
        StringBuilder escaped = new StringBuilder();
        int[] codePoints = value.codePoints().toArray();
        for (int i = 0; i < codePoints.length; ++i) {
            int ch = codePoints[i];
            if (ch == 9) {
                escaped.append("\\t");
                continue;
            }
            if (ch == 8) {
                escaped.append("\\b");
                continue;
            }
            if (ch == 10) {
                escaped.append("\\n");
                continue;
            }
            if (ch == 13) {
                escaped.append("\\r");
                continue;
            }
            if (ch == 12) {
                escaped.append("\\f");
                continue;
            }
            if (ch == 34) {
                escaped.append("\\\"");
                continue;
            }
            if (ch == 92) {
                escaped.append("\\\\");
                continue;
            }
            if (ch >= 0 && ch <= 31 || ch == 127) {
                escaped.append(String.format("\\u%04x", ch));
                continue;
            }
            escaped.appendCodePoint(ch);
        }
        return escaped.toString();
    }

    public void writeIri(String iri) throws IOException {
        if (iri == null) {
            throw new IllegalArgumentException();
        }
        this.writer.write(60);
        this.writer.write(iri);
        this.writer.write(62);
    }

    public void write(RdfSubject subject) throws IOException {
        if (subject == null) {
            throw new IllegalArgumentException();
        }
        if (subject.isIRI()) {
            this.writeIri(subject.toString());
            return;
        }
        if (subject.isBlankNode()) {
            this.writer.write(subject.toString());
            return;
        }
        throw new IllegalStateException();
    }

    public void write(RdfPredicate subject) throws IOException {
        if (subject == null) {
            throw new IllegalArgumentException();
        }
        if (subject.isIRI()) {
            this.writeIri(subject.toString());
            return;
        }
        if (subject.isBlankNode()) {
            this.writer.write(subject.toString());
            return;
        }
        throw new IllegalStateException();
    }

    public void write(RdfGraphName graphName) throws IOException {
        if (graphName == null) {
            throw new IllegalArgumentException();
        }
        if (graphName.isIRI()) {
            this.writeIri(graphName.toString());
            return;
        }
        if (graphName.isBlankNode()) {
            this.writer.write(graphName.toString());
            return;
        }
        throw new IllegalStateException();
    }
}

