/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdErrorCode;
import com.apicatalog.jsonld.api.JsonLdOptions;
import com.apicatalog.jsonld.compaction.Compaction;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.document.RemoteDocument;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.loader.LoadDocumentOptions;
import com.apicatalog.jsonld.processor.ExpansionProcessor;
import java.net.URI;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public final class CompactionProcessor {
    private CompactionProcessor() {
    }

    public static final JsonObject compact(URI input, URI context, JsonLdOptions options) throws JsonLdError {
        RemoteDocument jsonContext = options.getDocumentLoader().loadDocument(context, new LoadDocumentOptions());
        return CompactionProcessor.compact(input, jsonContext.getDocument().getJsonStructure(), options);
    }

    public static final JsonObject compact(URI input, JsonStructure context, JsonLdOptions options) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED);
        }
        RemoteDocument remoteDocument = options.getDocumentLoader().loadDocument(input, new LoadDocumentOptions().setExtractAllScripts(options.isExtractAllScripts()));
        if (remoteDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED);
        }
        return CompactionProcessor.compact(remoteDocument, context, options);
    }

    public static final JsonObject compact(RemoteDocument input, JsonStructure context, JsonLdOptions options) throws JsonLdError {
        JsonStructure contextValue;
        JsonLdOptions expansionOptions = new JsonLdOptions(options);
        expansionOptions.setOrdered(false);
        expansionOptions.setExtractAllScripts(false);
        JsonArray expandedInput = ExpansionProcessor.expand(input, expansionOptions, false);
        URI contextBase = input.getDocumentUrl();
        if (contextBase == null) {
            contextBase = options.getBase();
        }
        if (JsonUtils.isArray((JsonValue)(contextValue = context)) && contextValue.asJsonArray().size() == 1) {
            contextValue = (JsonValue)contextValue.asJsonArray().get(0);
        }
        if (JsonUtils.isObject((JsonValue)contextValue) && contextValue.asJsonObject().containsKey((Object)"@context")) {
            contextValue = (JsonValue)contextValue.asJsonObject().get((Object)"@context");
        }
        ActiveContext activeContext = new ActiveContext(options);
        activeContext = activeContext.newContext().create((JsonValue)contextValue, contextBase);
        if (options.getBase() != null) {
            activeContext.setBaseUri(options.getBase());
        } else if (activeContext.getBaseUri() == null && options.isCompactToRelative()) {
            activeContext.setBaseUri(input.getDocumentUrl());
        }
        JsonValue compactedOutput = Compaction.with(activeContext).compactArrays(options.isCompactArrays()).ordered(options.isOrdered()).compact((JsonValue)expandedInput);
        if (JsonUtils.isEmptyArray(compactedOutput)) {
            compactedOutput = JsonValue.EMPTY_JSON_OBJECT;
        } else if (JsonUtils.isArray(compactedOutput)) {
            compactedOutput = Json.createObjectBuilder().add(activeContext.uriCompaction().vocab(true).compact("@graph"), compactedOutput).build();
        }
        if (JsonUtils.isNull(compactedOutput) || compactedOutput.asJsonObject().isEmpty()) {
            return JsonValue.EMPTY_JSON_OBJECT;
        }
        if (JsonUtils.isNotNull((JsonValue)contextValue) && JsonUtils.isNotEmptyArray((JsonValue)contextValue) && JsonUtils.isNotEmptyObject((JsonValue)contextValue)) {
            compactedOutput = Json.createObjectBuilder((JsonObject)compactedOutput.asJsonObject()).add("@context", (JsonValue)contextValue).build();
        }
        return compactedOutput.asJsonObject();
    }
}

