/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.lang;

import com.apicatalog.rdf.lang.RdfAlphabet;
import java.util.stream.IntStream;

public final class LanguageTag {
    private LanguageTag() {
    }

    public static boolean isWellFormed(String languageTag) {
        if (languageTag == null) {
            throw new IllegalArgumentException();
        }
        if (languageTag.isBlank()) {
            return false;
        }
        int[] chars = languageTag.trim().codePoints().toArray();
        if (RdfAlphabet.ASCII_ALPHA.negate().test(chars[0])) {
            return false;
        }
        if (chars.length == 1) {
            return true;
        }
        if (RdfAlphabet.ASCII_ALPHA_NUM.negate().test(chars[chars.length - 1])) {
            return false;
        }
        return IntStream.range(1, chars.length - 1).map(i -> chars[i]).allMatch(RdfAlphabet.ASCII_ALPHA_NUM.or(ch -> ch == 45));
    }
}

