/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.json;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;

public final class JsonUtils {
    JsonUtils() {
    }

    public static final boolean contains(String text, JsonValue value) {
        if (text == null) {
            return value == null;
        }
        if (value == null) {
            return false;
        }
        if (JsonUtils.isString(value)) {
            return text.equals(((JsonString)value).getString());
        }
        if (JsonUtils.isArray(value)) {
            return value.asJsonArray().contains((Object)Json.createValue((String)text));
        }
        if (JsonUtils.isObject(value)) {
            return value.asJsonObject().containsKey((Object)text);
        }
        return false;
    }

    public static final boolean isScalar(JsonValue value) {
        return value != null && !JsonValue.ValueType.ARRAY.equals((Object)value.getValueType()) && !JsonValue.ValueType.OBJECT.equals((Object)value.getValueType());
    }

    public static final boolean isNotScalar(JsonValue value) {
        return !JsonUtils.isScalar(value);
    }

    public static final boolean isNull(JsonValue value) {
        return value == null || JsonValue.ValueType.NULL.equals((Object)value.getValueType());
    }

    public static final boolean isNotNull(JsonValue value) {
        return !JsonUtils.isNull(value);
    }

    public static boolean isString(JsonValue value) {
        return value != null && JsonValue.ValueType.STRING.equals((Object)value.getValueType());
    }

    public static boolean isNotString(JsonValue value) {
        return value == null || !JsonValue.ValueType.STRING.equals((Object)value.getValueType());
    }

    public static boolean isNotArray(JsonValue value) {
        return value == null || !JsonValue.ValueType.ARRAY.equals((Object)value.getValueType());
    }

    public static boolean isArray(JsonValue value) {
        return value != null && JsonValue.ValueType.ARRAY.equals((Object)value.getValueType());
    }

    public static boolean isObject(JsonValue value) {
        return value != null && JsonValue.ValueType.OBJECT.equals((Object)value.getValueType());
    }

    public static boolean isNotObject(JsonValue value) {
        return value == null || !JsonValue.ValueType.OBJECT.equals((Object)value.getValueType());
    }

    public static boolean isNumber(JsonValue value) {
        return value != null && JsonValue.ValueType.NUMBER.equals((Object)value.getValueType());
    }

    public static boolean isNotBoolean(JsonValue value) {
        return value == null || !JsonValue.ValueType.TRUE.equals((Object)value.getValueType()) && !JsonValue.ValueType.FALSE.equals((Object)value.getValueType());
    }

    public static boolean isTrue(JsonValue value) {
        return value != null && JsonValue.ValueType.TRUE.equals((Object)value.getValueType());
    }

    public static boolean isFalse(JsonValue value) {
        return value == null || JsonValue.ValueType.FALSE.equals((Object)value.getValueType());
    }

    public static boolean isEmptyObject(JsonValue value) {
        return JsonUtils.isObject(value) && value.asJsonObject().isEmpty();
    }

    public static boolean isEmptyArray(JsonValue value) {
        return JsonUtils.isArray(value) && value.asJsonArray().isEmpty();
    }

    public static JsonObject toJsonObject(Map<String, JsonValue> map) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        map.entrySet().stream().forEach(e -> builder.add((String)e.getKey(), (JsonValue)e.getValue()));
        return builder.build();
    }

    public static JsonArray toJsonArray(Collection<JsonValue> collection) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        collection.stream().forEach(arg_0 -> ((JsonArrayBuilder)builder).add(arg_0));
        return builder.build();
    }

    public static JsonObject merge(JsonObject target, JsonObject source) {
        LinkedHashMap<String, JsonValue> targetMap = new LinkedHashMap<String, JsonValue>((Map<String, JsonValue>)target);
        source.forEach(targetMap::put);
        return JsonUtils.toJsonObject(targetMap);
    }

    public static JsonArray toJsonArray(JsonValue value) {
        return JsonUtils.isArray(value) ? value.asJsonArray() : Json.createArrayBuilder().add(value).build();
    }

    public static boolean isBlankString(JsonValue value) {
        return JsonUtils.isString(value) && ((JsonString)value).getString().isBlank();
    }

    public static JsonValue toJsonValue(String value) {
        return value != null && !value.isBlank() ? Json.createValue((String)value) : JsonValue.NULL;
    }

    public static void addValue(Map<String, JsonValue> object, String key, JsonValue value, boolean asArray) {
        Iterator original;
        if (asArray) {
            if (!object.containsKey(key)) {
                object.put(key, (JsonValue)Json.createArrayBuilder().build());
            } else {
                original = object.get(key);
                if (JsonUtils.isNotArray((JsonValue)original)) {
                    object.put(key, (JsonValue)Json.createArrayBuilder().add((JsonValue)original).build());
                }
            }
        }
        if (JsonUtils.isArray(value)) {
            for (JsonValue v : value.asJsonArray()) {
                JsonUtils.addValue(object, key, v, asArray);
            }
        } else if (!object.containsKey(key)) {
            object.put(key, value);
        } else {
            original = object.get(key);
            if (JsonUtils.isNotArray((JsonValue)original)) {
                object.put(key, (JsonValue)Json.createArrayBuilder().add((JsonValue)original).add(value).build());
            } else {
                object.put(key, (JsonValue)Json.createArrayBuilder((JsonArray)original.asJsonArray()).add(value).build());
            }
        }
    }

    public static boolean isNotEmptyArray(JsonValue value) {
        return JsonUtils.isNotArray(value) || !value.asJsonArray().isEmpty();
    }

    public static boolean isNotEmptyObject(JsonValue value) {
        return JsonUtils.isNotObject(value) || !value.asJsonObject().isEmpty();
    }
}

