/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.flattening;

import com.apicatalog.jsonld.flattening.BlankNodeIdGenerator;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.Keywords;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonValue;

public final class NodeMap {
    private final Map<String, Map<String, Map<String, JsonValue>>> index;
    private final BlankNodeIdGenerator generator = new BlankNodeIdGenerator();

    public NodeMap() {
        this.index = new LinkedHashMap<String, Map<String, Map<String, JsonValue>>>();
        this.index.put("@default", new LinkedHashMap());
    }

    public boolean doesNotContain(String graphName, String subject, String property) {
        return !this.index.containsKey(graphName) || !this.index.get(graphName).containsKey(subject) || !this.index.get(graphName).get(subject).containsKey(property);
    }

    public void set(String graphName, String subject, String property, JsonValue value) {
        if (subject == null) {
            return;
        }
        this.index.computeIfAbsent(graphName, x -> new LinkedHashMap()).computeIfAbsent(subject, x -> new LinkedHashMap()).put(property, value);
    }

    public JsonValue get(String graphName, String subject, String property) {
        if (this.index.containsKey(graphName) && this.index.get(graphName).containsKey(subject)) {
            return this.index.get(graphName).get(subject).get(property);
        }
        return null;
    }

    public Map<String, JsonValue> get(String graphName, String subject) {
        if (this.index.containsKey(graphName)) {
            return this.index.get(graphName).get(subject);
        }
        return null;
    }

    public boolean doesNotContain(String graphName, String subject) {
        return !this.index.containsKey(graphName) || !this.index.get(graphName).containsKey(subject);
    }

    /*
     * Exception decompiling
     */
    public Map<String, JsonObject> get(String graphName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String createIdentifier(String name) {
        return this.generator.createIdentifier(name);
    }

    public String createIdentifier() {
        return this.generator.createIdentifier();
    }

    public Collection<String> graphs(boolean sorted) {
        return sorted ? (Collection)this.index.keySet().stream().sorted().collect(Collectors.toList()) : this.index.keySet();
    }

    public Collection<String> subjects(String graphName) {
        return this.subjects(graphName, false);
    }

    public Collection<String> subjects(String graphName, boolean sorted) {
        return sorted ? (Collection)this.index.getOrDefault(graphName, Collections.emptyMap()).keySet().stream().sorted().collect(Collectors.toList()) : this.index.getOrDefault(graphName, Collections.emptyMap()).keySet();
    }

    public Collection<String> properties(String graphName, String subject, boolean sorted) {
        return sorted ? (Collection)this.index.getOrDefault(graphName, Collections.emptyMap()).getOrDefault(subject, Collections.emptyMap()).keySet().stream().sorted().collect(Collectors.toList()) : this.index.getOrDefault(graphName, Collections.emptyMap()).getOrDefault(subject, Collections.emptyMap()).keySet();
    }

    public void merge() {
        NodeMap result = new NodeMap();
        for (Map.Entry<String, Map<String, Map<String, JsonValue>>> graphEntry : this.index.entrySet()) {
            for (Map.Entry<String, Map<String, JsonValue>> subject : graphEntry.getValue().entrySet()) {
                if (result.doesNotContain("@merged", subject.getKey())) {
                    result.set("@merged", subject.getKey(), "@id", (JsonValue)Json.createValue((String)subject.getKey()));
                }
                for (Map.Entry<String, JsonValue> property : subject.getValue().entrySet()) {
                    if (!"@type".equals(property.getKey()) && Keywords.matchForm(property.getKey())) {
                        result.set("@merged", subject.getKey(), property.getKey(), property.getValue());
                        continue;
                    }
                    JsonArrayBuilder array = result.doesNotContain("@merged", subject.getKey(), property.getKey()) ? Json.createArrayBuilder() : Json.createArrayBuilder((JsonArray)JsonUtils.toJsonArray(result.get("@merged", subject.getKey(), property.getKey())));
                    JsonUtils.toJsonArray(property.getValue()).forEach(arg_0 -> ((JsonArrayBuilder)array).add(arg_0));
                    result.set("@merged", subject.getKey(), property.getKey(), (JsonValue)array.build());
                }
            }
        }
        this.index.put("@merged", result.index.get("@merged"));
    }

    public boolean contains(String id) {
        return this.index.containsKey(id);
    }

    public String toString() {
        return Objects.toString(this.index);
    }

    private static /* synthetic */ JsonObject lambda$get$4(Object[] e) {
        return (JsonObject)e[1];
    }

    private static /* synthetic */ String lambda$get$3(Object[] e) {
        return (String)e[0];
    }
}

