/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.expansion;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdErrorCode;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.expansion.Expansion;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.DefaultObject;
import com.apicatalog.jsonld.lang.DirectionType;
import com.apicatalog.jsonld.lang.GraphObject;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.lang.LanguageTag;
import com.apicatalog.jsonld.lang.ListObject;
import com.apicatalog.jsonld.lang.NodeObject;
import com.apicatalog.jsonld.lang.ValueObject;
import com.apicatalog.jsonld.lang.Version;
import com.apicatalog.jsonld.uri.UriUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;

final class ObjectExpansion1314 {
    private static final Logger LOGGER = Logger.getLogger(ObjectExpansion1314.class.getName());
    private final ActiveContext activeContext;
    private final JsonObject element;
    private final String activeProperty;
    private final URI baseUrl;
    private ActiveContext typeContext;
    private Map<String, JsonValue> result;
    private String inputType;
    private Map<String, JsonValue> nest;
    private boolean frameExpansion;
    private boolean ordered;

    private ObjectExpansion1314(ActiveContext activeContext, JsonObject element, String activeProperty, URI baseUrl) {
        this.activeContext = activeContext;
        this.element = element;
        this.activeProperty = activeProperty;
        this.baseUrl = baseUrl;
        this.frameExpansion = false;
        this.ordered = false;
    }

    public static final ObjectExpansion1314 with(ActiveContext activeContext, JsonObject element, String activeProperty, URI baseUrl) {
        return new ObjectExpansion1314(activeContext, element, activeProperty, baseUrl);
    }

    public ObjectExpansion1314 frameExpansion(boolean value) {
        this.frameExpansion = value;
        return this;
    }

    public ObjectExpansion1314 ordered(boolean value) {
        this.ordered = value;
        return this;
    }

    public ObjectExpansion1314 nest(Map<String, JsonValue> nest) {
        this.nest = nest;
        return this;
    }

    public ObjectExpansion1314 typeContext(ActiveContext typeContext) {
        this.typeContext = typeContext;
        return this;
    }

    public ObjectExpansion1314 result(Map<String, JsonValue> result) {
        this.result = result;
        return this;
    }

    public ObjectExpansion1314 inputType(String inputType) {
        this.inputType = inputType;
        return this;
    }

    public void expand() throws JsonLdError {
        ArrayList keys = new ArrayList(this.element.keySet());
        if (this.ordered) {
            Collections.sort(keys);
        }
        for (String key : keys) {
            JsonArray expandedValue;
            JsonValue item5;
            String expandedProperty;
            if ("@context".equals(key) || (expandedProperty = this.activeContext.uriExpansion().documentRelative(false).vocab(true).expand(key)) == null || !expandedProperty.contains(":") && !Keywords.contains(expandedProperty)) continue;
            JsonValue value = (JsonValue)this.element.get((Object)key);
            if (Keywords.contains(expandedProperty)) {
                Object expandedStringValue;
                JsonArrayBuilder array;
                String expandedStringValue2;
                JsonValue expandedValue2 = JsonValue.NULL;
                if ("@reverse".equals(this.activeProperty)) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_REVERSE_PROPERTY_MAP);
                }
                if (this.result.containsKey(expandedProperty) && Keywords.noneMatch(expandedProperty, "@included", "@type")) {
                    throw new JsonLdError(JsonLdErrorCode.COLLIDING_KEYWORDS);
                }
                if ("@id".equals(expandedProperty)) {
                    if (JsonUtils.isNotString(value) && !this.frameExpansion || this.frameExpansion && JsonUtils.isNotString(value) && JsonUtils.isNotEmptyObject(value) && (JsonUtils.isNotArray(value) || !value.asJsonArray().stream().allMatch(JsonUtils::isString))) {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_ID_VALUE);
                    }
                    if (JsonUtils.isString(value)) {
                        expandedStringValue2 = this.activeContext.uriExpansion().documentRelative(true).vocab(false).expand(((JsonString)value).getString());
                        if (expandedStringValue2 != null) {
                            expandedValue2 = Json.createValue((String)expandedStringValue2);
                            if (this.frameExpansion) {
                                expandedValue2 = JsonUtils.toJsonArray(expandedValue2);
                            }
                        }
                    } else if (JsonUtils.isObject(value)) {
                        expandedValue2 = Json.createArrayBuilder().add((JsonValue)JsonValue.EMPTY_JSON_OBJECT).build();
                    } else if (JsonUtils.isEmptyArray(value)) {
                        expandedValue2 = JsonValue.EMPTY_JSON_ARRAY;
                    } else if (JsonUtils.isArray(value)) {
                        array = Json.createArrayBuilder();
                        for (JsonValue item2 : JsonUtils.toJsonArray(value)) {
                            expandedStringValue = this.activeContext.uriExpansion().documentRelative(true).vocab(false).expand(((JsonString)item2).getString());
                            if (expandedStringValue == null) continue;
                            array.add((String)expandedStringValue);
                        }
                        expandedValue2 = array.build();
                    }
                }
                if ("@type".equals(expandedProperty)) {
                    if (!this.frameExpansion && JsonUtils.isNotString(value) && (JsonUtils.isNotArray(value) || !value.asJsonArray().stream().allMatch(JsonUtils::isString)) || this.frameExpansion && JsonUtils.isNotString(value) && JsonUtils.isNotEmptyObject(value) && (JsonUtils.isNotArray(value) || !value.asJsonArray().stream().allMatch(JsonUtils::isString)) && !DefaultObject.isDefaultObject(value) && (JsonUtils.isNotString(DefaultObject.getValue(value)) || !UriUtils.isURI(((JsonString)DefaultObject.getValue(value)).getString()))) {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_TYPE_VALUE, "@type value is not valid [" + value + "].");
                    }
                    if (JsonUtils.isEmptyObject(value)) {
                        expandedValue2 = value;
                    } else if (DefaultObject.isDefaultObject(value)) {
                        value = DefaultObject.getValue(value);
                        expandedValue2 = Json.createObjectBuilder().add("@default", this.typeContext.uriExpansion().vocab(true).documentRelative(true).expand(((JsonString)value).getString())).build();
                    } else if (JsonUtils.isString(value)) {
                        expandedStringValue2 = this.typeContext.uriExpansion().vocab(true).documentRelative(true).expand(((JsonString)value).getString());
                        if (expandedStringValue2 != null) {
                            expandedValue2 = Json.createValue((String)expandedStringValue2);
                        }
                    } else if (JsonUtils.isArray(value)) {
                        array = Json.createArrayBuilder();
                        for (JsonValue item2 : value.asJsonArray()) {
                            if (!JsonUtils.isString(item2) || (expandedStringValue = this.typeContext.uriExpansion().vocab(true).documentRelative(true).expand(((JsonString)item2).getString())) == null) continue;
                            array.add((JsonValue)Json.createValue((String)expandedStringValue));
                        }
                        expandedValue2 = array.build();
                    }
                    if (this.result.containsKey("@type")) {
                        JsonValue typeValue = this.result.get("@type");
                        expandedValue2 = JsonUtils.isArray(typeValue) ? Json.createArrayBuilder((JsonArray)typeValue.asJsonArray()).add(expandedValue2).build() : Json.createArrayBuilder().add(typeValue).add(expandedValue2).build();
                    }
                }
                if ("@graph".equals(expandedProperty)) {
                    expandedValue2 = JsonUtils.toJsonArray(Expansion.with(this.typeContext, value, "@graph", this.baseUrl).frameExpansion(this.frameExpansion).ordered(this.ordered).compute());
                }
                if ("@included".equals(expandedProperty)) {
                    if (this.activeContext.inMode(Version.V1_0)) continue;
                    expandedValue2 = Expansion.with(this.activeContext, value, null, this.baseUrl).frameExpansion(this.frameExpansion).ordered(this.ordered).compute();
                    if (JsonUtils.isNotNull(expandedValue2)) {
                        if (JsonUtils.isNotArray(expandedValue2)) {
                            expandedValue2 = Json.createArrayBuilder().add(expandedValue2).build();
                        }
                        if (!expandedValue2.asJsonArray().stream().allMatch(NodeObject::isNodeObject)) {
                            throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_INCLUDED_VALUE);
                        }
                        if (this.result.containsKey("@included")) {
                            JsonArrayBuilder includes = Json.createArrayBuilder((JsonArray)this.result.get("@included").asJsonArray());
                            expandedValue2.asJsonArray().stream().forEach(arg_0 -> ((JsonArrayBuilder)includes).add(arg_0));
                            expandedValue2 = includes.build();
                        }
                    } else {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_INCLUDED_VALUE);
                    }
                }
                if ("@value".equals(expandedProperty)) {
                    if ("@json".equals(this.inputType)) {
                        if (this.activeContext.inMode(Version.V1_0)) {
                            throw new JsonLdError(JsonLdErrorCode.INVALID_VALUE_OBJECT_VALUE);
                        }
                        expandedValue2 = value;
                    } else if (JsonUtils.isNull(value) || JsonUtils.isScalar(value) || this.frameExpansion && (JsonUtils.isEmptyObject(value) || JsonUtils.isEmptyArray(value) || JsonUtils.isArray(value) && value.asJsonArray().stream().allMatch(JsonUtils::isScalar))) {
                        expandedValue2 = value;
                        if (this.frameExpansion) {
                            expandedValue2 = JsonUtils.toJsonArray(expandedValue2);
                        }
                    } else {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_VALUE_OBJECT_VALUE);
                    }
                    if (JsonUtils.isNull(expandedValue2)) {
                        this.result.put("@value", JsonValue.NULL);
                        continue;
                    }
                }
                if ("@language".equals(expandedProperty)) {
                    if (JsonUtils.isString(value) || this.frameExpansion && (JsonUtils.isEmptyObject(value) || JsonUtils.isEmptyArray(value) || JsonUtils.isArray(value) && value.asJsonArray().stream().allMatch(JsonUtils::isString))) {
                        if (JsonUtils.isString(value) && !LanguageTag.isWellFormed(((JsonString)value).getString())) {
                            LOGGER.log(Level.WARNING, "Language tag [{0}] is not well formed.", ((JsonString)value).getString());
                        }
                        Object object = expandedValue2 = JsonUtils.isString(value) ? Json.createValue((String)((JsonString)value).getString().toLowerCase()) : value;
                        if (this.frameExpansion) {
                            expandedValue2 = JsonUtils.toJsonArray(expandedValue2);
                        }
                    } else {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_LANGUAGE_TAGGED_STRING);
                    }
                }
                if ("@direction".equals(expandedProperty)) {
                    if (this.activeContext.inMode(Version.V1_0)) continue;
                    if (JsonUtils.isString(value) && "ltr".equals(((JsonString)value).getString()) || "rtl".equals(((JsonString)value).getString()) || this.frameExpansion && (JsonUtils.isEmptyObject(value) || JsonUtils.isEmptyArray(value) || JsonUtils.isArray(value) && value.asJsonArray().stream().allMatch(JsonUtils::isString))) {
                        expandedValue2 = value;
                        if (this.frameExpansion) {
                            expandedValue2 = JsonUtils.toJsonArray(expandedValue2);
                        }
                    } else {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_BASE_DIRECTION);
                    }
                }
                if ("@index".equals(expandedProperty)) {
                    if (JsonUtils.isNotString(value)) {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_INDEX_VALUE);
                    }
                    expandedValue2 = value;
                }
                if ("@list".equals(expandedProperty)) {
                    if (this.activeProperty == null || "@graph".equals(this.activeProperty)) continue;
                    expandedValue2 = Expansion.with(this.activeContext, value, this.activeProperty, this.baseUrl).frameExpansion(this.frameExpansion).ordered(this.ordered).compute();
                    if (JsonUtils.isNotArray(expandedValue2)) {
                        expandedValue2 = Json.createArrayBuilder().add(expandedValue2).build();
                    }
                }
                if ("@set".equals(expandedProperty)) {
                    expandedValue2 = Expansion.with(this.activeContext, value, this.activeProperty, this.baseUrl).frameExpansion(this.frameExpansion).ordered(this.ordered).compute();
                }
                if ("@reverse".equals(expandedProperty)) {
                    Object entry2;
                    if (JsonUtils.isNotObject(value)) {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_REVERSE_VALUE);
                    }
                    expandedValue2 = Expansion.with(this.activeContext, value, "@reverse", this.baseUrl).frameExpansion(this.frameExpansion).ordered(this.ordered).compute();
                    if (!JsonUtils.isObject(expandedValue2)) continue;
                    if (expandedValue2.asJsonObject().containsKey((Object)"@reverse")) {
                        for (Object entry2 : ((JsonValue)expandedValue2.asJsonObject().get((Object)"@reverse")).asJsonObject().entrySet()) {
                            JsonUtils.addValue(this.result, (String)entry2.getKey(), (JsonValue)entry2.getValue(), true);
                        }
                    }
                    if (expandedValue2.asJsonObject().size() <= 1 && expandedValue2.asJsonObject().containsKey((Object)"@reverse")) continue;
                    LinkedHashMap<String, JsonValue> reverseMap = null;
                    if (this.result.containsKey("@reverse")) {
                        reverseMap = new LinkedHashMap(this.result.get("@reverse").asJsonObject());
                    }
                    if (reverseMap == null) {
                        reverseMap = new LinkedHashMap<String, JsonValue>();
                    }
                    entry2 = expandedValue2.asJsonObject().entrySet().iterator();
                    while (entry2.hasNext()) {
                        Map.Entry entry3 = (Map.Entry)entry2.next();
                        if ("@reverse".equals(entry3.getKey()) || !JsonUtils.isArray((JsonValue)entry3.getValue())) continue;
                        expandedStringValue = ((JsonValue)entry3.getValue()).asJsonArray().iterator();
                        while (expandedStringValue.hasNext()) {
                            item5 = (JsonValue)expandedStringValue.next();
                            if (ListObject.isListObject(item5) || ValueObject.isValueObject(item5)) {
                                throw new JsonLdError(JsonLdErrorCode.INVALID_REVERSE_PROPERTY_VALUE);
                            }
                            JsonUtils.addValue(reverseMap, (String)entry3.getKey(), item5, true);
                        }
                    }
                    if (reverseMap.isEmpty()) continue;
                    this.result.put("@reverse", (JsonValue)JsonUtils.toJsonObject(reverseMap));
                    continue;
                }
                if ("@nest".equals(expandedProperty)) {
                    if (this.nest.containsKey(key)) continue;
                    this.nest.put(key, (JsonValue)Json.createArrayBuilder().build());
                    continue;
                }
                if (this.frameExpansion && ("@default".equals(expandedProperty) || "@embed".equals(expandedProperty) || "@explicit".equals(expandedProperty) || "@omitDefault".equals(expandedProperty) || "@requireAll".equals(expandedProperty))) {
                    expandedValue2 = Expansion.with(this.activeContext, value, expandedProperty, this.baseUrl).frameExpansion(this.frameExpansion).ordered(this.ordered).compute();
                }
                if (expandedValue2 == null && (!"@value".equals(expandedProperty) || !"@json".equals(this.inputType))) continue;
                this.result.put(expandedProperty, expandedValue2);
                continue;
            }
            Optional<TermDefinition> keyTermDefinition = this.activeContext.getTerm(key);
            Collection containerMapping = keyTermDefinition.map(TermDefinition::getContainerMapping).orElse(Collections.emptyList());
            if (keyTermDefinition.isPresent() && "@json".equals(keyTermDefinition.get().getTypeMapping())) {
                expandedValue = Json.createObjectBuilder().add("@value", value).add("@type", (JsonValue)Json.createValue((String)"@json")).build();
            } else if (containerMapping.contains("@language") && JsonUtils.isObject(value)) {
                expandedValue = Json.createArrayBuilder().build();
                DirectionType direction = this.activeContext.getDefaultBaseDirection();
                if (keyTermDefinition.isPresent() && keyTermDefinition.map(TermDefinition::getDirectionMapping).isPresent()) {
                    direction = keyTermDefinition.get().getDirectionMapping();
                }
                ArrayList langCodes = new ArrayList(value.asJsonObject().keySet());
                if (this.ordered) {
                    Collections.sort(langCodes);
                }
                for (String langCode : langCodes) {
                    JsonValue langValue = (JsonValue)value.asJsonObject().get((Object)langCode);
                    if (JsonUtils.isNotArray(langValue)) {
                        langValue = Json.createArrayBuilder().add(langValue).build();
                    }
                    for (JsonValue item3 : langValue.asJsonArray()) {
                        String expandedLangCode;
                        if (JsonUtils.isNull(item3)) continue;
                        if (JsonUtils.isNotString(item3)) {
                            throw new JsonLdError(JsonLdErrorCode.INVALID_LANGUAGE_MAP_VALUE);
                        }
                        JsonObjectBuilder langMap = Json.createObjectBuilder().add("@value", item3);
                        if (!"@none".equals(langCode) && !"@none".equals(expandedLangCode = this.activeContext.uriExpansion().vocab(true).expand(langCode))) {
                            if (!LanguageTag.isWellFormed(langCode)) {
                                LOGGER.log(Level.WARNING, "Language tag [{0}] is not well formed.", langCode);
                            }
                            langMap.add("@language", (JsonValue)Json.createValue((String)langCode.toLowerCase()));
                        }
                        if (direction != null && !DirectionType.NULL.equals((Object)direction)) {
                            langMap.add("@direction", (JsonValue)Json.createValue((String)direction.name().toLowerCase()));
                        }
                        expandedValue = Json.createArrayBuilder((JsonArray)expandedValue.asJsonArray()).add(langMap).build();
                    }
                }
            } else if ((containerMapping.contains("@index") || containerMapping.contains("@type") || containerMapping.contains("@id")) && JsonUtils.isObject(value)) {
                expandedValue = Json.createArrayBuilder().build();
                String indexKey = keyTermDefinition.map(TermDefinition::getIndexMapping).orElse("@index");
                ArrayList indicies = new ArrayList(value.asJsonObject().keySet());
                if (this.ordered) {
                    Collections.sort(indicies);
                }
                item5 = indicies.iterator();
                while (item5.hasNext()) {
                    String index = (String)item5.next();
                    JsonValue indexValue = (JsonValue)value.asJsonObject().get((Object)index);
                    ActiveContext mapContext = this.activeContext;
                    if (this.activeContext.getPreviousContext() != null && (containerMapping.contains("@id") || containerMapping.contains("@type"))) {
                        mapContext = this.activeContext.getPreviousContext();
                    }
                    Optional<TermDefinition> indexTermDefinition = mapContext.getTerm(index);
                    if (containerMapping.contains("@type") && indexTermDefinition.map(TermDefinition::getLocalContext).isPresent()) {
                        mapContext = mapContext.newContext().create(indexTermDefinition.get().getLocalContext(), indexTermDefinition.get().getBaseUrl());
                    }
                    if (mapContext == null) {
                        mapContext = this.activeContext;
                    }
                    String expandedIndex = this.activeContext.uriExpansion().vocab(true).expand(index);
                    if (JsonUtils.isNotArray(indexValue)) {
                        indexValue = Json.createArrayBuilder().add(indexValue).build();
                    }
                    indexValue = Expansion.with(mapContext, indexValue, key, this.baseUrl).fromMap(true).frameExpansion(this.frameExpansion).ordered(this.ordered).compute();
                    for (JsonValue item4 : indexValue.asJsonArray()) {
                        if (containerMapping.contains("@graph") && !GraphObject.isGraphObject(item4)) {
                            item4 = GraphObject.toGraphObject(item4);
                        }
                        if (containerMapping.contains("@index") && !"@index".equals(indexKey) && !"@none".equals(expandedIndex)) {
                            JsonValue reExpandedIndex = this.activeContext.valueExpansion().expand((JsonValue)Json.createValue((String)index), indexKey);
                            String expandedIndexKey = this.activeContext.uriExpansion().vocab(true).expand(indexKey);
                            JsonArrayBuilder indexPropertyValues = Json.createArrayBuilder().add(reExpandedIndex);
                            JsonValue existingValues = (JsonValue)item4.asJsonObject().get((Object)expandedIndexKey);
                            if (JsonUtils.isNotNull(existingValues)) {
                                if (JsonUtils.isArray(existingValues)) {
                                    existingValues.asJsonArray().forEach(arg_0 -> ((JsonArrayBuilder)indexPropertyValues).add(arg_0));
                                } else {
                                    indexPropertyValues.add(existingValues);
                                }
                            }
                            if (ValueObject.isValueObject(item4 = Json.createObjectBuilder((JsonObject)item4.asJsonObject()).add(expandedIndexKey, indexPropertyValues).build()) && item4.asJsonObject().size() > 1) {
                                throw new JsonLdError(JsonLdErrorCode.INVALID_VALUE_OBJECT);
                            }
                        } else if (containerMapping.contains("@index") && !item4.asJsonObject().containsKey((Object)"@index") && !"@none".equals(expandedIndex)) {
                            item4 = Json.createObjectBuilder((JsonObject)item4.asJsonObject()).add("@index", index).build();
                        } else if (containerMapping.contains("@id") && !item4.asJsonObject().containsKey((Object)"@id") && !"@none".equals(expandedIndex)) {
                            expandedIndex = this.activeContext.uriExpansion().vocab(false).documentRelative(true).expand(index);
                            item4 = Json.createObjectBuilder((JsonObject)item4.asJsonObject()).add("@id", expandedIndex).build();
                        } else if (containerMapping.contains("@type") && !"@none".equals(expandedIndex)) {
                            JsonArrayBuilder types = Json.createArrayBuilder().add(expandedIndex);
                            JsonValue existingType = (JsonValue)item4.asJsonObject().get((Object)"@type");
                            if (JsonUtils.isNotNull(existingType)) {
                                if (JsonUtils.isArray(existingType)) {
                                    existingType.asJsonArray().stream().forEach(arg_0 -> ((JsonArrayBuilder)types).add(arg_0));
                                } else {
                                    types.add(existingType);
                                }
                            }
                            item4 = Json.createObjectBuilder((JsonObject)item4.asJsonObject()).add("@type", types).build();
                        }
                        expandedValue = Json.createArrayBuilder((JsonArray)expandedValue.asJsonArray()).add(item4).build();
                    }
                }
            } else {
                expandedValue = Expansion.with(this.activeContext, value, key, this.baseUrl).frameExpansion(this.frameExpansion).ordered(this.ordered).compute();
            }
            if (JsonUtils.isNull((JsonValue)expandedValue)) continue;
            if (containerMapping.contains("@list") && !ListObject.isListObject((JsonValue)expandedValue)) {
                expandedValue = ListObject.toListObject((JsonValue)expandedValue);
            }
            if (containerMapping.contains("@graph") && !containerMapping.contains("@id") && !containerMapping.contains("@index")) {
                expandedValue = JsonUtils.toJsonArray((JsonValue)expandedValue);
                JsonArrayBuilder array = Json.createArrayBuilder();
                for (JsonValue ev : expandedValue.asJsonArray()) {
                    array.add((JsonValue)GraphObject.toGraphObject(ev));
                }
                expandedValue = array.build();
            }
            if (keyTermDefinition.isPresent() && keyTermDefinition.get().isReverseProperty()) {
                LinkedHashMap<String, JsonValue> reverseMap = null;
                if (this.result.containsKey("@reverse")) {
                    reverseMap = new LinkedHashMap(this.result.get("@reverse").asJsonObject());
                }
                if (reverseMap == null) {
                    reverseMap = new LinkedHashMap<String, JsonValue>();
                }
                expandedValue = JsonUtils.toJsonArray((JsonValue)expandedValue);
                for (JsonValue item5 : expandedValue.asJsonArray()) {
                    if (ListObject.isListObject(item5) || ValueObject.isValueObject(item5)) {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_REVERSE_PROPERTY_VALUE);
                    }
                    if (!reverseMap.containsKey(expandedProperty)) {
                        reverseMap.put(expandedProperty, (JsonValue)Json.createArrayBuilder().build());
                    }
                    JsonUtils.addValue(reverseMap, expandedProperty, item5, true);
                }
                this.result.put("@reverse", (JsonValue)JsonUtils.toJsonObject(reverseMap));
                continue;
            }
            JsonUtils.addValue(this.result, expandedProperty, (JsonValue)expandedValue, true);
        }
        ArrayList<String> nestedKeys = new ArrayList<String>(this.nest.keySet());
        if (this.ordered) {
            Collections.sort(nestedKeys);
        }
        for (String nestedKey : nestedKeys) {
            JsonValue nestedValues = (JsonValue)this.element.get((Object)nestedKey);
            if (JsonUtils.isNotArray(nestedValues)) {
                nestedValues = Json.createArrayBuilder().add(nestedValues).build();
            }
            for (JsonValue nestValue : nestedValues.asJsonArray()) {
                if (JsonUtils.isNotObject(nestValue)) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_NEST_VALUE);
                }
                for (String nestedValueKey : nestValue.asJsonObject().keySet()) {
                    String expandedNestedValueKey = this.typeContext.uriExpansion().vocab(true).expand(nestedValueKey);
                    if (!"@value".equals(expandedNestedValueKey)) continue;
                    throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_NEST_VALUE);
                }
                ObjectExpansion1314.with(this.activeContext, nestValue.asJsonObject(), this.activeProperty, this.baseUrl).inputType(this.inputType).result(this.result).typeContext(this.typeContext).nest(new LinkedHashMap<String, JsonValue>()).frameExpansion(this.frameExpansion).ordered(this.ordered).expand();
            }
        }
    }
}

