/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.api.builder;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdOptions;
import com.apicatalog.jsonld.lang.Version;
import com.apicatalog.jsonld.loader.LoadDocumentCallback;
import com.apicatalog.jsonld.processor.ToRdfProcessor;
import com.apicatalog.rdf.RdfDataset;
import java.net.URI;

public final class ToRdfApi {
    private final URI document;
    private JsonLdOptions options;

    public ToRdfApi(URI document) {
        this.document = document;
        this.options = new JsonLdOptions();
    }

    public ToRdfApi options(JsonLdOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Parameter 'options' is null.");
        }
        this.options = options;
        return this;
    }

    public ToRdfApi context(URI contextUri) {
        this.options.setExpandContext(contextUri);
        return this;
    }

    public ToRdfApi context(String contextUri) {
        return this.context(URI.create(contextUri));
    }

    public ToRdfApi produceGeneralizedRdf(JsonLdOptions.RdfDirection rdfDirection) {
        this.options.setRdfDirection(rdfDirection);
        return this;
    }

    public ToRdfApi produceGeneralizedRdf() {
        return this.produceGeneralizedRdf(true);
    }

    public ToRdfApi produceGeneralizedRdf(boolean enable) {
        this.options.setProduceGeneralizedRdf(enable);
        return this;
    }

    public ToRdfApi mode(Version processingMode) {
        this.options.setProcessingMode(processingMode);
        return this;
    }

    public ToRdfApi base(URI baseUri) {
        this.options.setBase(baseUri);
        return this;
    }

    public ToRdfApi base(String baseUri) {
        return this.base(URI.create(baseUri));
    }

    public ToRdfApi loader(LoadDocumentCallback loader) {
        this.options.setDocumentLoader(loader);
        return this;
    }

    public ToRdfApi ordered(boolean enable) {
        this.options.setOrdered(enable);
        return this;
    }

    public ToRdfApi ordered() {
        return this.ordered(true);
    }

    public RdfDataset get() throws JsonLdError {
        return ToRdfProcessor.toRdf(this.document, this.options);
    }
}

