/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.api.builder;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdOptions;
import com.apicatalog.jsonld.lang.Version;
import com.apicatalog.jsonld.loader.LoadDocumentCallback;
import com.apicatalog.jsonld.processor.FramingProcessor;
import java.net.URI;
import javax.json.JsonObject;

public final class FramingApi {
    private final URI documentUri;
    private final URI frameUri;
    private JsonLdOptions options;

    public FramingApi(URI documentUri, URI frameUri) {
        this.documentUri = documentUri;
        this.frameUri = frameUri;
        this.options = new JsonLdOptions();
    }

    public FramingApi options(JsonLdOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Parameter 'options' is null.");
        }
        this.options = options;
        return this;
    }

    public FramingApi context(URI contextUri) {
        this.options.setExpandContext(contextUri);
        return this;
    }

    public FramingApi context(String contextUri) {
        return this.context(URI.create(contextUri));
    }

    public FramingApi mode(Version processingMode) {
        this.options.setProcessingMode(processingMode);
        return this;
    }

    public FramingApi base(URI baseUri) {
        this.options.setBase(baseUri);
        return this;
    }

    public FramingApi base(String baseUri) {
        return this.base(URI.create(baseUri));
    }

    public FramingApi loader(LoadDocumentCallback loader) {
        this.options.setDocumentLoader(loader);
        return this;
    }

    public FramingApi ordered(boolean enable) {
        this.options.setOrdered(enable);
        return this;
    }

    public FramingApi ordered() {
        return this.ordered(true);
    }

    public JsonObject get() throws JsonLdError {
        return FramingProcessor.frame(this.documentUri, this.frameUri, this.options);
    }
}

