/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.api.builder;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdOptions;
import com.apicatalog.jsonld.lang.Version;
import com.apicatalog.jsonld.loader.LoadDocumentCallback;
import com.apicatalog.jsonld.processor.FlatteningProcessor;
import java.net.URI;
import javax.json.JsonStructure;

public final class FlatteningApi {
    private final URI document;
    private JsonStructure jsonContext;
    private URI contextUri;
    private JsonLdOptions options;

    public FlatteningApi(URI document) {
        this.document = document;
        this.jsonContext = null;
        this.contextUri = null;
        this.options = new JsonLdOptions();
    }

    public FlatteningApi options(JsonLdOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Parameter 'options' is null.");
        }
        this.options = options;
        return this;
    }

    public FlatteningApi mode(Version processingMode) {
        this.options.setProcessingMode(processingMode);
        return this;
    }

    public FlatteningApi base(URI baseUri) {
        this.options.setBase(baseUri);
        return this;
    }

    public FlatteningApi base(String baseUri) {
        return this.base(URI.create(baseUri));
    }

    public FlatteningApi compactArrays(boolean enable) {
        this.options.setCompactArrays(enable);
        return this;
    }

    public FlatteningApi compactArrays() {
        return this.compactArrays(true);
    }

    public FlatteningApi loader(LoadDocumentCallback loader) {
        this.options.setDocumentLoader(loader);
        return this;
    }

    public FlatteningApi ordered(boolean enable) {
        this.options.setOrdered(enable);
        return this;
    }

    public FlatteningApi ordered() {
        return this.ordered(true);
    }

    public FlatteningApi context(URI contextUri) {
        this.contextUri = contextUri;
        return this;
    }

    public FlatteningApi context(String contextUri) {
        return this.context(URI.create(contextUri));
    }

    public FlatteningApi context(JsonStructure jsonContext) {
        this.jsonContext = jsonContext;
        return this;
    }

    public JsonStructure get() throws JsonLdError {
        if (this.jsonContext != null) {
            return FlatteningProcessor.flatten(this.document, this.jsonContext, this.options);
        }
        if (this.contextUri != null) {
            return FlatteningProcessor.flatten(this.document, this.jsonContext, this.options);
        }
        return FlatteningProcessor.flatten(this.document, (JsonStructure)null, this.options);
    }
}

