/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.riemann;

import com.aphyr.riemann.client.AbstractRiemannClient;
import com.aphyr.riemann.client.RiemannBatchClient;
import com.aphyr.riemann.client.RiemannClient;
import com.aphyr.riemann.client.UnsupportedJVMException;
import java.io.Closeable;
import java.io.IOException;

public class Riemann
implements Closeable {
    AbstractRiemannClient client;

    public Riemann(String host, Integer port) throws IOException {
        this(host, port, 10);
    }

    public Riemann(String host, Integer port, int batchSize) throws IOException {
        this(Riemann.getClient(host, port, batchSize));
    }

    private static AbstractRiemannClient getClient(String host, Integer port, int batchSize) throws IOException {
        RiemannClient c = RiemannClient.tcp(host, port);
        try {
            return new RiemannBatchClient(batchSize, c);
        }
        catch (UnsupportedJVMException e) {
            return c;
        }
    }

    public Riemann(AbstractRiemannClient client) {
        this.client = client;
    }

    public void connect() throws IOException {
        if (!this.client.isConnected()) {
            this.client.connect();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.disconnect();
        }
    }
}

