/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.util.validation;

import com.aol.cyclops.control.Maybe;
import com.aol.cyclops.control.Xor;
import java.beans.ConstructorProperties;

public interface ValidationResult<T, E> {
    public Maybe<T> success();

    public Maybe<E> failure();

    default public Xor<E, T> toXor() {
        return this.success().isPresent() ? Xor.primary(this.success().get()) : Xor.secondary(this.failure().get());
    }

    public static class FailedResult<T, E>
    implements ValidationResult<T, E> {
        private final E error;

        public static <T, E> ValidationResult<T, E> fail(E error) {
            return new FailedResult<T, E>(error);
        }

        @Override
        public Maybe<T> success() {
            return Maybe.none();
        }

        @Override
        public Maybe<E> failure() {
            return Maybe.of(this.error);
        }

        @ConstructorProperties(value={"error"})
        public FailedResult(E error) {
            this.error = error;
        }

        public String toString() {
            return "ValidationResult.FailedResult(error=" + this.error + ")";
        }
    }

    public static class SuccessfulResult<T, E>
    implements ValidationResult<T, E> {
        private final T result;

        public static <T, E> ValidationResult<T, E> success(T result) {
            return new SuccessfulResult<T, E>(result);
        }

        @Override
        public Maybe<T> success() {
            return Maybe.of(this.result);
        }

        @Override
        public Maybe<E> failure() {
            return Maybe.none();
        }

        @ConstructorProperties(value={"result"})
        public SuccessfulResult(T result) {
            this.result = result;
        }

        public String toString() {
            return "ValidationResult.SuccessfulResult(result=" + this.result + ")";
        }
    }
}

