/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.util.stream;

import com.aol.cyclops.data.collections.extensions.CollectionX;
import com.aol.cyclops.internal.stream.SeqUtils;
import com.aol.cyclops.internal.stream.StreamableImpl;
import com.aol.cyclops.util.stream.Streamable;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;

public class AsStreamable {
    public static <T> Streamable<T> fromObject(Object toCoerce) {
        return new StreamableImpl<Object>(AsStreamable.collectStream(toCoerce));
    }

    public static <T> Streamable<T> fromStream(Stream<T> toCoerce) {
        return new StreamableImpl<Stream<T>>(AsStreamable.collectStream(toCoerce));
    }

    public static <T> Streamable<T> fromIterable(Iterable<T> toCoerce) {
        return new StreamableImpl<Iterable<T>>(AsStreamable.collectStream(toCoerce));
    }

    public static <T> Streamable<T> synchronizedFromStream(Stream<T> toCoerce) {
        return new StreamableImpl<Stream<T>>(AsStreamable.collectStreamConcurrent(toCoerce));
    }

    public static <T> Streamable<T> synchronizedFromIterable(Iterable<T> toCoerce) {
        return new StreamableImpl<Iterable<T>>(AsStreamable.collectStreamConcurrent(toCoerce));
    }

    private static <T> Iterable<T> collectStreamConcurrent(T object) {
        if (object instanceof Stream) {
            CollectionX c = SeqUtils.toConcurrentLazyCollection((Stream)object);
            return new PrintableIterable(c);
        }
        if (object instanceof Object[]) {
            return Arrays.asList((Object[])object);
        }
        if (object instanceof Iterable) {
            return (Iterable)object;
        }
        return Arrays.asList(object);
    }

    private static <T> Iterable<T> collectStream(T object) {
        if (object instanceof Stream) {
            CollectionX c = SeqUtils.toLazyCollection((Stream)object);
            return new PrintableIterable(c);
        }
        if (object instanceof Object[]) {
            return Arrays.asList((Object[])object);
        }
        if (object instanceof Iterable) {
            return (Iterable)object;
        }
        return Arrays.asList(object);
    }

    static class PrintableIterable<T>
    implements Iterable<T> {
        private final Collection c;

        @Override
        public Iterator<T> iterator() {
            return this.c.iterator();
        }

        public String toString() {
            return String.format("%s", this.c);
        }

        @ConstructorProperties(value={"c"})
        public PrintableIterable(Collection c) {
            this.c = c;
        }
    }
}

