/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.util.function;

import com.aol.cyclops.util.ExceptionSoftener;
import com.aol.cyclops.util.function.Cacheable;
import com.aol.cyclops.util.function.QuadFunction;
import com.aol.cyclops.util.function.TriFunction;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jooq.lambda.tuple.Tuple;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;

public class Memoize {
    public static <T> Supplier<T> memoizeSupplier(Supplier<T> s) {
        ConcurrentHashMap lazy = new ConcurrentHashMap();
        return () -> lazy.computeIfAbsent("k", arg_0 -> Memoize.lambda$null$0((Supplier)s, arg_0));
    }

    public static <T> Supplier<T> memoizeSupplier(Supplier<T> s, Cacheable<T> cache) {
        return () -> cache.soften().computeIfAbsent("k", arg_0 -> Memoize.lambda$null$2((Supplier)s, arg_0));
    }

    public static <T> Callable<T> memoizeCallable(Callable<T> s, Cacheable<T> cache) {
        return () -> cache.soften().computeIfAbsent("k", a -> ExceptionSoftener.softenCallable(s).get());
    }

    public static <T> Callable<T> memoizeCallable(Callable<T> s) {
        ConcurrentHashMap lazy = new ConcurrentHashMap();
        return () -> lazy.computeIfAbsent("k", a -> ExceptionSoftener.softenCallable(s).get());
    }

    public static Runnable memoizeRunnable(Runnable r) {
        AtomicReference<Boolean> isSet = new AtomicReference<Boolean>(false);
        Object lock = new Object();
        return () -> {
            if (((Boolean)isSet.get()).booleanValue()) {
                return;
            }
            Object object = lock;
            synchronized (object) {
                if (((Boolean)isSet.get()).booleanValue()) {
                    return;
                }
                isSet.compareAndSet(false, true);
                r.run();
            }
        };
    }

    public static <T, R> Function<T, R> memoizeFunction(Function<T, R> fn) {
        ConcurrentHashMap lazy = new ConcurrentHashMap();
        return t -> lazy.computeIfAbsent(t, fn);
    }

    public static <T, R> Function<T, R> memoizeFunction(Function<T, R> fn, Cacheable<R> cache) {
        return t -> cache.soften().computeIfAbsent(t, fn);
    }

    public static <T1, T2, R> BiFunction<T1, T2, R> memoizeBiFunction(BiFunction<T1, T2, R> fn) {
        Function<Tuple2, Object> memoise2 = Memoize.memoizeFunction(pair -> fn.apply(pair.v1, pair.v2));
        return (t1, t2) -> memoise2.apply(Tuple.tuple((Object)t1, (Object)t2));
    }

    public static <T1, T2, R> BiFunction<T1, T2, R> memoizeBiFunction(BiFunction<T1, T2, R> fn, Cacheable<R> cache) {
        Function<Tuple2, Object> memoise2 = Memoize.memoizeFunction(pair -> fn.apply(pair.v1, pair.v2), cache);
        return (t1, t2) -> memoise2.apply(Tuple.tuple((Object)t1, (Object)t2));
    }

    public static <T1, T2, T3, R> TriFunction<T1, T2, T3, R> memoizeTriFunction(TriFunction<T1, T2, T3, R> fn) {
        Function<Tuple3, Object> memoise2 = Memoize.memoizeFunction(triple -> fn.apply(triple.v1, triple.v2, triple.v3));
        return (t1, t2, t3) -> memoise2.apply(Tuple.tuple((Object)t1, (Object)t2, (Object)t3));
    }

    public static <T1, T2, T3, R> TriFunction<T1, T2, T3, R> memoizeTriFunction(TriFunction<T1, T2, T3, R> fn, Cacheable<R> cache) {
        Function<Tuple3, Object> memoise2 = Memoize.memoizeFunction(triple -> fn.apply(triple.v1, triple.v2, triple.v3), cache);
        return (t1, t2, t3) -> memoise2.apply(Tuple.tuple((Object)t1, (Object)t2, (Object)t3));
    }

    public static <T1, T2, T3, T4, R> QuadFunction<T1, T2, T3, T4, R> memoizeQuadFunction(QuadFunction<T1, T2, T3, T4, R> fn) {
        Function<Tuple4, Object> memoise2 = Memoize.memoizeFunction(quad -> fn.apply(quad.v1, quad.v2, quad.v3, quad.v4));
        return (t1, t2, t3, t4) -> memoise2.apply(Tuple.tuple((Object)t1, (Object)t2, (Object)t3, (Object)t4));
    }

    public static <T1, T2, T3, T4, R> QuadFunction<T1, T2, T3, T4, R> memoizeQuadFunction(QuadFunction<T1, T2, T3, T4, R> fn, Cacheable<R> cache) {
        Function<Tuple4, Object> memoise2 = Memoize.memoizeFunction(quad -> fn.apply(quad.v1, quad.v2, quad.v3, quad.v4), cache);
        return (t1, t2, t3, t4) -> memoise2.apply(Tuple.tuple((Object)t1, (Object)t2, (Object)t3, (Object)t4));
    }

    public static <T> Predicate<T> memoizePredicate(Predicate<T> p) {
        Function<Object, Boolean> memoised = Memoize.memoizeFunction(t -> p.test(t));
        return t -> (Boolean)memoised.apply(t);
    }

    public static <T> Predicate<T> memoizePredicate(Predicate<T> p, Cacheable<Boolean> cache) {
        Function<Object, Boolean> memoised = Memoize.memoizeFunction(t -> p.test(t), cache);
        return t -> (Boolean)memoised.apply(t);
    }

    private static /* synthetic */ Object lambda$null$2(Supplier s, Object a) {
        return s.get();
    }

    private static /* synthetic */ Object lambda$null$0(Supplier s, Object a) {
        return s.get();
    }
}

