/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.stream;

import com.aol.cyclops.control.LazyReact;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.internal.stream.ReversedIterator;
import com.aol.cyclops.internal.stream.SeqUtils;
import com.aol.cyclops.types.futurestream.LazyFutureStream;
import com.aol.cyclops.types.stream.ConvertableToReactiveSeq;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface ToStream<T>
extends Iterable<T>,
ConvertableToReactiveSeq<T> {
    default public LazyFutureStream<T> futureStream(LazyReact react) {
        return react.fromIterable(this);
    }

    @Override
    default public ReactiveSeq<T> reactiveSeq() {
        return ReactiveSeq.fromStream(StreamSupport.stream(this.getStreamable().spliterator(), false));
    }

    @Override
    default public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    default public Iterable<T> getStreamable() {
        return this;
    }

    default public ReactiveSeq<T> reveresedStream() {
        return ReactiveSeq.fromStream(this.reveresedStream());
    }

    default public ReactiveSeq<T> stream() {
        return ReactiveSeq.fromStream(StreamSupport.stream(this.getStreamable().spliterator(), false));
    }

    default public Stream<T> reveresedJDKStream() {
        Iterable<T> streamable = this.getStreamable();
        if (streamable instanceof List) {
            return StreamSupport.stream(new ReversedIterator((List)streamable).spliterator(), false);
        }
        return SeqUtils.reverse(this.jdkStream());
    }

    default public boolean isEmpty() {
        return this.reactiveSeq().isEmpty();
    }

    default public Stream<T> jdkStream() {
        return StreamSupport.stream(this.getStreamable().spliterator(), false);
    }
}

