/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.futurestream;

import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.internal.react.async.future.FastFuture;
import com.aol.cyclops.internal.react.stream.LazyStreamWrapper;
import com.aol.cyclops.react.async.subscription.Continueable;
import com.aol.cyclops.types.futurestream.LazyFutureStream;
import com.aol.cyclops.types.stream.HeadAndTail;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;

public interface OperationsOnFutures<T> {
    public LazyFutureStream<T> fromStreamOfFutures(Stream<FastFuture<T>> var1);

    public LazyStreamWrapper<T> getLastActive();

    public LazyFutureStream<T> withLastActive(LazyStreamWrapper<T> var1);

    public T safeJoin(FastFuture<T> var1);

    public Continueable getSubscription();

    default public LazyFutureStream<T> reverse() {
        return this.fromStreamOfFutures((Stream<FastFuture<T>>)this.getLastActive().injectFuturesSeq().reverse());
    }

    default public LazyFutureStream<T> cycle(int times) {
        return this.fromStreamOfFutures((Stream<FastFuture<T>>)((Object)this.getLastActive().injectFuturesSeq().cycle(times)));
    }

    default public LazyFutureStream<T> cycle() {
        return this.fromStreamOfFutures((Stream<FastFuture<T>>)this.getLastActive().injectFuturesSeq().cycle());
    }

    default public Tuple2<LazyFutureStream<T>, LazyFutureStream<T>> duplicate() {
        return ReactiveSeq.fromStream(this.getLastActive().injectFutures()).duplicateSequence().map1(s -> this.fromStreamOfFutures((Stream<FastFuture<T>>)s)).map2(s -> this.fromStreamOfFutures((Stream<FastFuture<T>>)s));
    }

    default public Tuple3<LazyFutureStream<T>, LazyFutureStream<T>, LazyFutureStream<T>> triplicate() {
        return ReactiveSeq.fromStream(this.getLastActive().injectFutures()).triplicate().map1(s -> this.fromStreamOfFutures((Stream<FastFuture<T>>)s)).map2(s -> this.fromStreamOfFutures((Stream<FastFuture<T>>)s)).map3(s -> this.fromStreamOfFutures((Stream<FastFuture<T>>)s));
    }

    default public Tuple4<LazyFutureStream<T>, LazyFutureStream<T>, LazyFutureStream<T>, LazyFutureStream<T>> quadruplicate() {
        return ReactiveSeq.fromStream(this.getLastActive().injectFutures()).quadruplicate().map1(s -> this.fromStreamOfFutures((Stream<FastFuture<T>>)s)).map2(s -> this.fromStreamOfFutures((Stream<FastFuture<T>>)s)).map3(s -> this.fromStreamOfFutures((Stream<FastFuture<T>>)s)).map4(s -> this.fromStreamOfFutures((Stream<FastFuture<T>>)s));
    }

    default public Tuple2<Optional<T>, LazyFutureStream<T>> splitAtHead() {
        return ReactiveSeq.fromStream(this.getLastActive().injectFutures()).splitSequenceAtHead().map1(o -> o.map(f -> f.join())).map2(s -> this.fromStreamOfFutures((Stream<FastFuture<T>>)s));
    }

    default public Tuple2<LazyFutureStream<T>, LazyFutureStream<T>> splitAt(int where) {
        return ReactiveSeq.fromStream(this.getLastActive().injectFutures()).splitAt(where).map1(s -> this.fromStreamOfFutures((Stream<FastFuture<T>>)s)).map2(s -> this.fromStreamOfFutures((Stream<FastFuture<T>>)s));
    }

    default public <R> LazyFutureStream<Tuple2<T, R>> zipLfs(LazyFutureStream<R> other) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().map(f -> f.toCompletableFuture()).zip((Seq)((LazyStreamWrapper)other.getLastActive()).injectFuturesSeq().map(f -> f.toCompletableFuture())).map(t -> ((CompletableFuture)t.v1).thenApply(r -> Tuple.tuple((Object)r, ((CompletableFuture)t.v2).join()))).map(cf -> FastFuture.fromCompletableFuture(cf)));
    }

    default public <R, T2> LazyFutureStream<R> zipLfs(LazyFutureStream<T2> other, BiFunction<CompletableFuture<T>, CompletableFuture<T2>, CompletableFuture<R>> combiner) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().map(f -> f.toCompletableFuture()).zip((Seq)((LazyStreamWrapper)other.getLastActive()).injectFuturesSeq().map(f -> f.toCompletableFuture())).map(t -> (CompletableFuture)combiner.apply((CompletableFuture)t.v1, (CompletableFuture)t.v2)).map(cf -> FastFuture.fromCompletableFuture(cf)));
    }

    default public <R> LazyFutureStream<Tuple2<T, R>> zip(Stream<R> other) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().map(f -> f.toCompletableFuture()).zip(other).map(t -> ((CompletableFuture)t.v1).thenApply(r -> Tuple.tuple((Object)r, (Object)t.v2))).map(cf -> FastFuture.fromCompletableFuture(cf)));
    }

    default public <S, U> LazyFutureStream<Tuple3<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().map(f -> f.toCompletableFuture()).zip3(second, third).map(t -> ((CompletableFuture)t.v1).thenApply(r -> Tuple.tuple((Object)r, (Object)t.v2, (Object)t.v3))).map(cf -> FastFuture.fromCompletableFuture(cf)));
    }

    default public <S, U> LazyFutureStream<Tuple3<T, S, U>> zip3Lfs(LazyFutureStream<? extends S> second, LazyFutureStream<? extends U> third) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().map(f -> f.toCompletableFuture()).zip3(((LazyStreamWrapper)second.getLastActive()).injectFuturesSeq().map(f -> f.toCompletableFuture()), ((LazyStreamWrapper)third.getLastActive()).injectFuturesSeq().map(f -> f.toCompletableFuture())).map(t -> ((CompletableFuture)t.v1).thenApply(r -> Tuple.tuple((Object)r, ((CompletableFuture)t.v2).join(), ((CompletableFuture)t.v3).join()))).map(cf -> FastFuture.fromCompletableFuture(cf)));
    }

    default public <T2, T3, T4> LazyFutureStream<Tuple4<T, T2, T3, T4>> zip4(Stream<T2> second, Stream<T3> third, Stream<T4> fourth) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().map(f -> f.toCompletableFuture()).zip4(second, third, fourth).map(t -> ((CompletableFuture)t.v1).thenApply(r -> Tuple.tuple((Object)r, (Object)t.v2, (Object)t.v3, (Object)t.v4))).map(cf -> FastFuture.fromCompletableFuture(cf)));
    }

    default public <T2, T3, T4> LazyFutureStream<Tuple4<T, T2, T3, T4>> zip4Lfs(LazyFutureStream<T2> second, LazyFutureStream<T3> third, LazyFutureStream<T4> fourth) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().map(f -> f.toCompletableFuture()).zip4(((LazyStreamWrapper)second.getLastActive()).injectFuturesSeq().map(f -> f.toCompletableFuture()), ((LazyStreamWrapper)third.getLastActive()).injectFuturesSeq().map(f -> f.toCompletableFuture()), ((LazyStreamWrapper)fourth.getLastActive()).injectFuturesSeq().map(f -> f.toCompletableFuture())).map(t -> ((CompletableFuture)t.v1).thenApply(r -> Tuple.tuple((Object)r, ((CompletableFuture)t.v2).join(), ((CompletableFuture)t.v3).join(), ((CompletableFuture)t.v4).join()))).map(cf -> FastFuture.fromCompletableFuture(cf)));
    }

    default public LazyFutureStream<Tuple2<T, Long>> zipWithIndex() {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().map(f -> f.toCompletableFuture()).zipWithIndex().map(t -> ((CompletableFuture)t.v1).thenApply(r -> Tuple.tuple((Object)r, (Object)t.v2))).map(cf -> FastFuture.fromCompletableFuture(cf)));
    }

    default public LazyFutureStream<List<T>> sliding(int windowSize) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().sliding(windowSize).map(list -> Tuple.tuple((Object)list, (Object)list.stream().map(f -> f.toCompletableFuture()))).map(tuple -> FastFuture.fromCompletableFuture(CompletableFuture.allOf(((ReactiveSeq)tuple.v2).collect(Collectors.toList()).toArray(new CompletableFuture[0])).thenApply(v -> ((ListX)tuple.v1).stream().map(f -> this.safeJoin((FastFuture<T>)f)).collect(Collectors.toList())))));
    }

    default public LazyFutureStream<List<T>> sliding(int windowSize, int increment) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().sliding(windowSize, increment).map(list -> Tuple.tuple((Object)list, (Object)list.stream().map(f -> f.toCompletableFuture()))).map(tuple -> FastFuture.fromCompletableFuture(CompletableFuture.allOf(((ReactiveSeq)tuple.v2).collect(Collectors.toList()).toArray(new CompletableFuture[0])).thenApply(v -> ((ListX)tuple.v1).stream().map(f -> this.safeJoin((FastFuture<T>)f)).collect(Collectors.toList())))));
    }

    default public LazyFutureStream<List<T>> grouped(int groupSize) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().grouped(groupSize).map(list -> Tuple.tuple((Object)list, (Object)list.stream().map(f -> f.toCompletableFuture()))).map(tuple -> FastFuture.fromCompletableFuture(CompletableFuture.allOf(((ReactiveSeq)tuple.v2).collect(Collectors.toList()).toArray(new CompletableFuture[0])).thenApply(v -> ((ListX)tuple.v1).stream().map(f -> this.safeJoin((FastFuture<T>)f)).collect(Collectors.toList())))));
    }

    default public LazyFutureStream<T> skip(long n) {
        Continueable sub = this.getSubscription();
        sub.registerSkip(n);
        LazyStreamWrapper<T> lastActive = this.getLastActive();
        LazyStreamWrapper limited = lastActive.withStream(lastActive.stream().skip(n));
        return this.withLastActive(limited);
    }

    default public LazyFutureStream<T> limit(long maxSize) {
        Continueable sub = this.getSubscription();
        sub.registerLimit(maxSize);
        LazyStreamWrapper<T> lastActive = this.getLastActive();
        LazyStreamWrapper limited = lastActive.withStream(lastActive.stream().limit(maxSize));
        return this.withLastActive(limited);
    }

    default public HeadAndTail<T> headAndTail() {
        return this.getLastActive().injectFuturesSeq().map(f -> this.safeJoin((FastFuture<T>)f)).headAndTail();
    }

    default public LazyFutureStream<T> intersperse(T value) {
        return this.fromStreamOfFutures((Stream<FastFuture<T>>)this.getLastActive().injectFuturesSeq().intersperse((Object)FastFuture.completedFuture(value)));
    }

    default public LazyFutureStream<T> intersperse(CompletableFuture<T> value) {
        return this.fromStreamOfFutures((Stream<FastFuture<T>>)this.getLastActive().injectFuturesSeq().intersperse((Object)FastFuture.fromCompletableFuture(value)));
    }

    default public LazyFutureStream<T> shuffle() {
        return this.fromStreamOfFutures((Stream<FastFuture<T>>)this.getLastActive().injectFuturesSeq().shuffle());
    }

    default public LazyFutureStream<T> appendStream(Stream<T> stream) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().appendStream(stream.map(v -> FastFuture.completedFuture(v))));
    }

    default public LazyFutureStream<T> appendStreamFutures(Stream<CompletableFuture<T>> stream) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().appendStream(stream.map(v -> FastFuture.fromCompletableFuture(v))));
    }

    default public LazyFutureStream<T> prependStream(Stream<T> stream) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().prependStream(stream.map(v -> FastFuture.completedFuture(v))));
    }

    default public LazyFutureStream<T> prependStreamFutures(Stream<CompletableFuture<T>> stream) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().prependStream(stream.map(v -> FastFuture.fromCompletableFuture(v))));
    }

    default public LazyFutureStream<T> append(T ... values) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().appendStream(Stream.of(values).map(v -> FastFuture.completedFuture(v))));
    }

    default public LazyFutureStream<T> appendFutures(CompletableFuture<T> ... values) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().appendStream(Stream.of(values).map(v -> FastFuture.fromCompletableFuture(v))));
    }

    default public LazyFutureStream<T> prepend(T ... values) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().prependStream(Stream.of(values).map(v -> FastFuture.completedFuture(v))));
    }

    default public LazyFutureStream<T> prependFutures(CompletableFuture<T> ... values) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().prependStream(Stream.of(values).map(v -> FastFuture.fromCompletableFuture(v))));
    }

    default public LazyFutureStream<T> insertAt(int pos, T ... values) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().insertStreamAt(pos, Stream.of(values).map(v -> FastFuture.completedFuture(v))));
    }

    default public LazyFutureStream<T> deleteBetween(int start, int end) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().deleteBetween(start, end));
    }

    default public LazyFutureStream<T> insertStreamAt(int pos, Stream<T> stream) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().insertStreamAt(pos, stream.map(v -> FastFuture.completedFuture(v))));
    }

    default public LazyFutureStream<T> insertStreamFuturesAt(int pos, Stream<CompletableFuture<T>> stream) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().insertStreamAt(pos, stream.map(v -> FastFuture.fromCompletableFuture(v))));
    }

    default public LazyFutureStream<T> skipLast(int num) {
        return this.fromStreamOfFutures((Stream<FastFuture<T>>)((Object)this.getLastActive().injectFuturesSeq().skipLast(num)));
    }

    default public LazyFutureStream<T> limitLast(int num) {
        return this.fromStreamOfFutures((Stream<FastFuture<T>>)((Object)this.getLastActive().injectFuturesSeq().limitLast(num)));
    }

    default public Optional<T> elementAt(long index) {
        return this.getLastActive().injectFuturesSeq().zipWithIndex().filter(t -> (Long)t.v2 == index).findFirst().map(t -> this.safeJoin((FastFuture)t.v1()));
    }

    default public Tuple2<T, LazyFutureStream<T>> get(long index) {
        Tuple2<ReactiveSeq<FastFuture<T>>, ReactiveSeq<FastFuture<T>>> tuple = this.getLastActive().injectFuturesSeq().duplicateSequence();
        return tuple.map1(s -> s.zipWithIndex().filter(t -> (Long)t.v2 == index).map(f -> this.safeJoin((FastFuture)f.v1)).findFirst().get()).map2(s -> this.fromStreamOfFutures((Stream<FastFuture<T>>)s));
    }

    default public <R> LazyFutureStream<R> thenCombine(BiFunction<T, T, R> combiner) {
        return this.fromStreamOfFutures(this.getLastActive().injectFuturesSeq().map(f -> f.toCompletableFuture()).grouped(2).filter(list -> list.size() == 2).map(list -> ((CompletableFuture)list.get(0)).thenCombine((CompletionStage)list.get(1), combiner)).map(cf -> FastFuture.fromCompletableFuture(cf)));
    }

    default public LazyFutureStream<T> concat(Stream<T> other) {
        return this.fromStreamOfFutures((Stream<FastFuture<T>>)this.getLastActive().injectFuturesSeq().concat(other.map(t -> FastFuture.completedFuture(t))));
    }

    default public LazyFutureStream<T> concat(T other) {
        return this.fromStreamOfFutures((Stream<FastFuture<T>>)this.getLastActive().injectFuturesSeq().concat((Object)FastFuture.completedFuture(other)));
    }

    default public LazyFutureStream<T> concat(T ... other) {
        return this.concat((T)Stream.of(other));
    }

    default public LazyFutureStream<T> concatFutures(CompletableFuture<T> ... other) {
        return this.concatStreamFutures(Stream.of(other));
    }

    default public LazyFutureStream<T> concatStreamFutures(Stream<CompletableFuture<T>> other) {
        return this.fromStreamOfFutures((Stream<FastFuture<T>>)this.getLastActive().injectFuturesSeq().concat(other.map(t -> FastFuture.fromCompletableFuture(t))));
    }

    default public LazyFutureStream<T> shuffle(Random random) {
        return this.fromStreamOfFutures((Stream<FastFuture<T>>)this.getLastActive().injectFuturesSeq().shuffle(random));
    }

    default public LazyFutureStream<T> slice(long from, long to) {
        return this.fromStreamOfFutures((Stream<FastFuture<T>>)this.getLastActive().injectFuturesSeq().slice(from, to));
    }

    default public ReactiveSeq<CompletableFuture<T>> toStream() {
        return this.getLastActive().injectFuturesSeq().map(f -> f.toCompletableFuture());
    }

    default public Set<CompletableFuture<T>> toSet() {
        return this.toStream().collect(Collectors.toSet());
    }

    default public <R, A> R collect(Collector<? super CompletableFuture<T>, A, R> collector) {
        return this.toStream().collect(collector);
    }

    default public List<CompletableFuture<T>> toList() {
        return this.toStream().collect(Collectors.toList());
    }

    default public <C extends Collection<CompletableFuture<T>>> C toCollection(Supplier<C> collectionFactory) {
        return (C)((Collection)this.toStream().collect(Collectors.toCollection(collectionFactory)));
    }

    default public Optional<CompletableFuture<T>> reduce(BinaryOperator<CompletableFuture<T>> accumulator) {
        return this.toStream().reduce(accumulator);
    }

    default public CompletableFuture<T> foldRight(CompletableFuture<T> identity, BinaryOperator<CompletableFuture<T>> accumulator) {
        return this.toStream().foldRight(identity, accumulator);
    }

    default public CompletableFuture<T> foldLeft(CompletableFuture<T> identity, BinaryOperator<CompletableFuture<T>> accumulator) {
        return (CompletableFuture)this.toStream().foldLeft(identity, accumulator);
    }

    default public CompletableFuture<T> reduce(CompletableFuture<T> identity, BinaryOperator<CompletableFuture<T>> accumulator) {
        return this.toStream().reduce(identity, accumulator);
    }

    default public <U> CompletableFuture<U> reduce(CompletableFuture<U> identity, BiFunction<CompletableFuture<U>, ? super CompletableFuture<T>, CompletableFuture<U>> accumulator, BinaryOperator<CompletableFuture<U>> combiner) {
        return this.toStream().reduce(identity, accumulator, combiner);
    }
}

