/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.futurestream;

import com.aol.cyclops.control.LazyReact;
import com.aol.cyclops.data.async.QueueFactory;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.internal.react.async.future.FastFuture;
import com.aol.cyclops.internal.react.async.future.PipelineBuilder;
import com.aol.cyclops.internal.react.exceptions.FilteredExecutionPathException;
import com.aol.cyclops.internal.react.stream.LazyStreamWrapper;
import com.aol.cyclops.react.SimpleReactFailedStageException;
import com.aol.cyclops.react.async.subscription.Continueable;
import com.aol.cyclops.types.futurestream.BaseSimpleReactStream;
import com.aol.cyclops.types.futurestream.BlockingStream;
import com.aol.cyclops.types.futurestream.ConfigurableStream;
import com.aol.cyclops.types.futurestream.ToQueue;
import com.aol.cyclops.util.stream.StreamUtils;
import com.nurkiewicz.asyncretry.RetryExecutor;
import com.nurkiewicz.asyncretry.policy.AbortRetryException;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface LazySimpleReactStream<U>
extends BlockingStream<U>,
ConfigurableStream<U, FastFuture<U>>,
ToQueue<U>,
BaseSimpleReactStream<U> {
    @Override
    public LazyReact getSimpleReact();

    public LazySimpleReactStream<U> withTaskExecutor(Executor var1);

    @Override
    public LazySimpleReactStream<U> withRetrier(RetryExecutor var1);

    @Override
    public LazySimpleReactStream<U> withQueueFactory(QueueFactory<U> var1);

    public LazySimpleReactStream<U> withErrorHandler(Optional<Consumer<Throwable>> var1);

    @Override
    public LazySimpleReactStream<U> withSubscription(Continueable var1);

    public LazySimpleReactStream<U> withAsync(boolean var1);

    @Override
    public Continueable getSubscription();

    public <R> LazySimpleReactStream<R> withLastActive(LazyStreamWrapper<R> var1);

    @Override
    public LazyStreamWrapper<U> getLastActive();

    @Override
    default public <R> LazySimpleReactStream<R> then(Function<? super U, ? extends R> fn, Executor service) {
        return this.withLastActive(((LazyStreamWrapper)this.getLastActive()).operation(ft -> ft.thenApplyAsync(LazySimpleReactStream.handleExceptions(fn), service)));
    }

    @Override
    default public <R> LazySimpleReactStream<R> thenSync(Function<? super U, ? extends R> fn) {
        return this.withLastActive(((LazyStreamWrapper)this.getLastActive()).operation(ft -> ft.thenApply(LazySimpleReactStream.handleExceptions(fn))));
    }

    @Override
    default public <R> LazySimpleReactStream<R> retry(Function<? super U, ? extends R> fn) {
        Function<PipelineBuilder, PipelineBuilder> mapper = ft -> ft.thenApplyAsync(res -> this.getRetrier().getWithRetry(() -> LazySimpleReactStream.handleExceptions(fn).apply(res)).join(), this.getTaskExecutor());
        return this.withLastActive(((LazyStreamWrapper)this.getLastActive()).operation(mapper));
    }

    @Override
    default public <R> LazySimpleReactStream<R> then(Function<? super U, ? extends R> fn) {
        if (!this.isAsync()) {
            return this.thenSync((Function)fn);
        }
        Function<PipelineBuilder, PipelineBuilder> streamMapper = ft -> ft.thenApplyAsync(LazySimpleReactStream.handleExceptions(fn), this.getTaskExecutor());
        return this.withLastActive(((LazyStreamWrapper)this.getLastActive()).operation(streamMapper));
    }

    @Override
    default public LazySimpleReactStream<U> peek(Consumer<? super U> consumer) {
        if (!this.isAsync()) {
            return this.peekSync((Consumer)consumer);
        }
        return this.then((T t) -> {
            consumer.accept((Object)t);
            return t;
        });
    }

    @Override
    default public LazySimpleReactStream<U> peekSync(Consumer<? super U> consumer) {
        return this.thenSync((T t) -> {
            consumer.accept((Object)t);
            return t;
        });
    }

    public static <U, R> Function<U, R> handleExceptions(Function<? super U, ? extends R> fn) {
        return input -> {
            try {
                return fn.apply((Object)input);
            }
            catch (Throwable t) {
                if (t instanceof AbortRetryException) {
                    throw t;
                }
                throw new SimpleReactFailedStageException(input, t);
            }
        };
    }

    @Override
    default public <R> LazySimpleReactStream<R> flatMapToCompletableFuture(Function<? super U, CompletableFuture<? extends R>> flatFn) {
        if (!this.isAsync()) {
            return this.flatMapToCompletableFutureSync((Function)flatFn);
        }
        Function<PipelineBuilder, PipelineBuilder> streamMapper = ft -> ft.thenComposeAsync(LazySimpleReactStream.handleExceptions(flatFn), this.getTaskExecutor());
        return this.withLastActive(((LazyStreamWrapper)this.getLastActive()).operation(streamMapper));
    }

    @Override
    default public <R> LazySimpleReactStream<R> flatMapToCompletableFutureSync(Function<? super U, CompletableFuture<? extends R>> flatFn) {
        Function<PipelineBuilder, PipelineBuilder> streamMapper = ft -> ft.thenCompose(LazySimpleReactStream.handleExceptions(flatFn));
        return this.withLastActive(((LazyStreamWrapper)this.getLastActive()).operation(streamMapper));
    }

    @Override
    default public <R> LazySimpleReactStream<R> flatMap(Function<? super U, ? extends Stream<? extends R>> flatFn) {
        return this.getSimpleReact().construct(Stream.of(new Object[0])).withSubscription(this.getSubscription()).withQueueFactory(this.getQueueFactory()).fromStream(this.toQueue().stream(this.getSubscription()).flatMap(flatFn));
    }

    default public ListX<BaseSimpleReactStream<U>> copySimpleReactStream(int times) {
        return StreamUtils.toBufferingCopier(this.iterator(), times).stream().map(it -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false)).map(fs -> this.getSimpleReact().construct((Stream)fs)).toListX();
    }

    @Override
    default public LazySimpleReactStream<U> filter(Predicate<? super U> p) {
        if (!this.isAsync()) {
            return this.filterSync((Predicate)p);
        }
        Function<PipelineBuilder, PipelineBuilder> fn = ft -> ft.thenApplyAsync(in -> {
            if (!p.test((Object)in)) {
                throw new FilteredExecutionPathException();
            }
            return in;
        }, this.getTaskExecutor());
        return this.withLastActive(((LazyStreamWrapper)this.getLastActive()).operation(fn));
    }

    @Override
    default public LazySimpleReactStream<U> filterSync(Predicate<? super U> p) {
        Function<PipelineBuilder, PipelineBuilder> fn = ft -> ft.thenApply(in -> {
            if (!p.test((Object)in)) {
                throw new FilteredExecutionPathException();
            }
            return in;
        });
        return this.withLastActive(((LazyStreamWrapper)this.getLastActive()).operation(fn));
    }

    @Override
    default public <T> Stream<CompletableFuture<T>> streamCompletableFutures() {
        Stream<CompletableFuture<T>> s = ((LazyStreamWrapper)this.getLastActive()).stream();
        return s;
    }

    @Override
    default public LazySimpleReactStream<U> onFail(Function<? super SimpleReactFailedStageException, ? extends U> fn) {
        return this.onFail(Throwable.class, (Function)fn);
    }

    @Override
    default public LazySimpleReactStream<U> onFail(Class<? extends Throwable> exceptionClass, Function<? super SimpleReactFailedStageException, ? extends U> fn) {
        Function<PipelineBuilder, PipelineBuilder> mapper = ft -> ft.exceptionally(t -> {
            SimpleReactFailedStageException simpleReactException;
            if (t instanceof FilteredExecutionPathException) {
                throw (FilteredExecutionPathException)t;
            }
            Throwable throwable = t;
            if (t instanceof CompletionException) {
                throwable = ((Exception)t).getCause();
            }
            if (exceptionClass.isAssignableFrom((simpleReactException = LazySimpleReactStream.assureSimpleReactException(throwable)).getCause().getClass())) {
                return fn.apply(simpleReactException);
            }
            throw simpleReactException;
        });
        return this.withLastActive(((LazyStreamWrapper)this.getLastActive()).operation(mapper));
    }

    public static SimpleReactFailedStageException assureSimpleReactException(Throwable throwable) {
        if (throwable instanceof SimpleReactFailedStageException) {
            return (SimpleReactFailedStageException)throwable;
        }
        return new SimpleReactFailedStageException((Object)null, throwable);
    }

    @Override
    default public LazySimpleReactStream<U> capture(Consumer<Throwable> errorHandler) {
        return this.withErrorHandler((Optional)Optional.of(errorHandler));
    }
}

