/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.react.collectors.lazy;

import java.beans.ConstructorProperties;

public class MaxActive {
    private final int maxActive;
    private final int reduceTo;
    public static final MaxActive IO = new MaxActive(100, 90);
    public static final MaxActive CPU = new MaxActive(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() - 1);
    public static final MaxActive SEQUENTIAL = new MaxActive(10, 1);

    public static MaxActiveBuilder builder() {
        return new MaxActiveBuilder();
    }

    @ConstructorProperties(value={"maxActive", "reduceTo"})
    public MaxActive(int maxActive, int reduceTo) {
        this.maxActive = maxActive;
        this.reduceTo = reduceTo;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public int getReduceTo() {
        return this.reduceTo;
    }

    public MaxActive withMaxActive(int maxActive) {
        return this.maxActive == maxActive ? this : new MaxActive(maxActive, this.reduceTo);
    }

    public MaxActive withReduceTo(int reduceTo) {
        return this.reduceTo == reduceTo ? this : new MaxActive(this.maxActive, reduceTo);
    }

    public static class MaxActiveBuilder {
        private int maxActive;
        private int reduceTo;

        MaxActiveBuilder() {
        }

        public MaxActiveBuilder maxActive(int maxActive) {
            this.maxActive = maxActive;
            return this;
        }

        public MaxActiveBuilder reduceTo(int reduceTo) {
            this.reduceTo = reduceTo;
            return this;
        }

        public MaxActive build() {
            return new MaxActive(this.maxActive, this.reduceTo);
        }

        public String toString() {
            return "MaxActive.MaxActiveBuilder(maxActive=" + this.maxActive + ", reduceTo=" + this.reduceTo + ")";
        }
    }
}

